/****************************************************************************
 *
 * Copyright (c) 2015-2018 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ***************************************************************************/

#ifndef __FLOWMGR_FAP_OPS_H
#define __FLOWMGR_FAP_OPS_H

#define	NFAP	0	/* No FAP */
#define	SFAP	1	/* Software FAP */
#define	GFAP	2	/* Hardware GFAP */
#define	RFAP	3	/* Hardware Runner */

struct fap_ops {
	int type;
	const char *name;
	int features;
	int (*dump)(struct seq_file *s);
	int (*enable)(bool enable);
	int (*config)(char *pri_lan_dev_name, char *wan_dev_name,
		      char *sec_lan_dev_name);
	int (*config_dslite)(void *params, int oindex);
	int (*unconfig_dslite)(int id);
	int (*config_gre)(void *params, int oindex);
	int (*config_mapt)(void *params);
	int (*unconfig_gre)(int id);
	int (*flow_add)(void *params, int *flow_id);
	int (*flow_add_expected)(void *params, int *flow_id);
	int (*flow_remove)(int flow_id);
	int (*flow_remove_mcast)(int flow_id, __be32 *group_id, int oindex);
	int (*flow_get_counter)(int flow_id, u32 *packets, u32 *bytes,
				bool reset);
	int (*flow_get_mcast_counter)(int flow_id, u32 *packets, u32 *bytes,
				bool reset);
	int (*flow_get_dhdol)(struct sk_buff *skb,
			      const struct net_device *dev,
			      int *wifi_flowring,
			      u8 *wifi_pri);
	int (*flow_max)(void);
};
struct fap_ops *fap(void);
extern void flowmgr_register_fap(struct fap_ops *ops);
extern void flowmgr_unregister_fap(struct fap_ops *ops);

#endif
