 /****************************************************************************
 *
 * Copyright (c) 2015-2022 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef BRCM_BA_RPC_H
#define BRCM_BA_RPC_H

#include <uapi/linux/bcm_media_gw/rpc_services/power_services.h>
#include <linux/bcm_media_gw/rpc_services/ba_rpc_services.h>

#define BA_RPC_CPU_RG           "RG"

#define BA_RPC_RS_OFF           RPC_RS_OFF
#define BA_RPC_RS_RESET         RPC_RS_RESET
#define BA_RPC_RS_BOOT          RPC_RS_BOOT
#define BA_RPC_RS_CRASH         RPC_RS_CRASH
#define BA_RPC_RS_SHUTDOWN      RPC_RS_SHUTDOWN
#define BA_RPC_RS_BAUP          RPC_RS_BAUP
#define BA_RPC_RS_READY         RPC_RS_READY
#define BA_RPC_RS_BATTERY       RPC_RS_BATTERY

	/* BA_RPC_RS_INIT(RS ID,	        RS Name)*/
#define BA_RPC_RS_LIST \
	BA_RPC_RS_INIT(RUNSTATE_OFF,		BA_RPC_RS_OFF)\
	BA_RPC_RS_INIT(RUNSTATE_RESET,		BA_RPC_RS_RESET)\
	BA_RPC_RS_INIT(RUNSTATE_BOOT,		BA_RPC_RS_BOOT)\
	BA_RPC_RS_INIT(RUNSTATE_CRASH,		BA_RPC_RS_CRASH)\
	BA_RPC_RS_INIT(RUNSTATE_SHUTDOWN,	BA_RPC_RS_SHUTDOWN)\
	BA_RPC_RS_INIT(RUNSTATE_BAUP,		BA_RPC_RS_BAUP)\
	BA_RPC_RS_INIT(RUNSTATE_READY,		BA_RPC_RS_READY)\
	BA_RPC_RS_INIT(RUNSTATE_BATTERY,	BA_RPC_RS_BATTERY)\

#define BA_RPC_RS_INIT(index, rs_name) index,
typedef enum {
	BA_RPC_RS_LIST
	BA_RPC_RS_MAX_STATE
}rs_e;
#undef BA_RPC_RS_INIT

enum rg_battery_mode {
	RG_CPU_OFF_UTILITY 	= 0,
	RG_CPU_ON_UTILITY,
	RG_CPU_OFF_BATTERY,
	RG_CPU_ON_BATTERY,
	RG_CPU_OFF_UTILITY_DELAYED
};

enum rg_battery_mode brcm_rpc_ba_rg_batt_mode(void);
int bcm_ba_req_cpu_shutdown(char *cpu, bool rude);
int bcm_ba_get_cpu_run_state(char *run_state, char *cpu_name);

#endif //BRCM_BA_RPC_H
