/****************************************************************************
 *
 * Copyright (c) 2021 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Broadcom MoCA Linux PHY Driver implementation.
 *
 * Author: Ravi Patel <ravi.patel@broadcom.com>
 ****************************************************************************/

#include <linux/brcmphy.h>

#define PHY_ID_BCMMOCA 0xBC330CA

#if !defined(SIMULATE_AUTONEG)
static int bcmmoca_config_init(struct phy_device *phydev)
{
	phydev->autoneg = AUTONEG_DISABLE;

	return 0;
}
#endif

static int bcmmoca_config_aneg(struct phy_device *phydev)
{
	return 0;
}

static int bcmmoca_aneg_done(struct phy_device *phydev)
{
#if defined(SIMULATE_AUTONEG)
	if (phydev->state == PHY_NOLINK)
		return BMSR_ANEGCOMPLETE;
#endif

	return 0;
}

static int bcmmoca_update_link(struct phy_device *phydev)
{
	phydev->link = 1;

	return 0;
}

static int bcmmoca_read_status(struct phy_device *phydev)
{
	if (phydev->state == PHY_NOLINK)
		phydev->link = 1;

	phydev->speed = SPEED_1000;
	phydev->duplex = DUPLEX_FULL;

	return 0;
}

static int bcmmoca_match_phy_device(struct phy_device *phydev)
{
	return phydev->phy_id == PHY_ID_BCMMOCA;
}

static struct phy_driver bcmmoca_phydev_driver[] = {
	{
	.phy_id			= PHY_ID_BCMMOCA,
	.name			= "Broadcom MoCA PHY",
	.phy_id_mask		= 0xffffffff,
	.soft_reset		= genphy_no_soft_reset,
#if !defined(SIMULATE_AUTONEG)
	.config_init		= bcmmoca_config_init,
#endif
	.config_aneg		= bcmmoca_config_aneg,
	.aneg_done		= bcmmoca_aneg_done,
	.update_link		= bcmmoca_update_link,
	.read_status		= bcmmoca_read_status,
	.match_phy_device	= bcmmoca_match_phy_device,
	}
};

module_phy_driver(bcmmoca_phydev_driver);

static struct mdio_device_id __maybe_unused bcmmoca_phydev_tbl[] = {
	{ PHY_ID_BCMMOCA, 0xffffffff, },
	{ }
};

MODULE_DEVICE_TABLE(mdio, bcmmoca_phydev_tbl);

MODULE_DESCRIPTION("Broadcom BCMMOCA PHY driver");
MODULE_AUTHOR("Ravi Patel <ravi.patel@broadcom.com>");
MODULE_LICENSE("GPL");
