This module matches a given string by using some pattern matching strategy. It requires a linux kernel >= 2.6.14.
.TP
\fB\-\-algo\fP {\fBbm\fP|\fBkmp\fP}
Select the pattern matching strategy. (bm = Boyer-Moore, kmp = Knuth-Pratt-Morris)
.TP
\fB\-\-from\fP \fIoffset\fP
Set the offset from which it starts looking for any matching. If not passed, default is 0.
.TP
\fB\-\-to\fP \fIoffset\fP
Set the offset up to which should be scanned. That is, byte \fIoffset\fP-1
(counting from 0) is the last one that is scanned.
If not passed, default is the packet size.
.TP
[\fB!\fP] \fB\-\-string\fP \fIpattern\fP
Matches the given pattern.
.TP
[\fB!\fP] \fB\-\-hex\-string\fP \fIpattern\fP
Matches the given pattern in hex notation.
.TP
\fB\-\-icase\fP
Ignore case when searching.
.TP
Examples:
.IP
# The string pattern can be used for simple text characters.
.br
iptables \-A INPUT \-p tcp \-\-dport 80 \-m string \-\-algo bm \-\-string 'GET /index.html' \-j LOG
.IP
# The hex string pattern can be used for non-printable characters, like |0D 0A| or |0D0A|.
.br
iptables \-p udp \-\-dport 53 \-m string \-\-algo bm \-\-from 40 \-\-to 57 \-\-hex\-string '|03|www|09|netfilter|03|org|00|'
