 /****************************************************************************
 *
 * Copyright (c) 2017 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Broadcom BCM8488x Multi-Gigabit Ethernet external transceivers.
 *
 * Author: Ravi Patel <ravi.patel@broadcom.com>
 ****************************************************************************/

#ifndef _LINUX_BCM8488X_H
#define _LINUX_BCM8488X_H

#include <linux/mdio.h>

/* FW Retry load count */
#define FW_RETRY	2

/* MDIO busy count */
#define MDIO_RETRY	5

/* MDIO busy check delay interval */
#define MDIO_DELAY	1000

/* MDIO_MMD_PMAPMD registers */
#define PROCTL			0xA817
#define PROCTL_CLEAR	(0x00)
#define PROCTL_WRITE	(0x09)
#define PROCTL_DOWNLOAD	(0x38)

#define ADDR_L			0xA819
#define ADDR_H			0xA81A
#define DATA_L			0xA81B
#define DATA_H			0xA81C

/* MDIO_MMD_AN registers */
#define MDIO_MII_BASE		(0xFFE0)
#define MDIO_MII_BMCR		(MDIO_MII_BASE + MII_BMCR)
#define MDIO_MII_BMSR		(MDIO_MII_BASE + MII_BMSR)
#define MDIO_MII_ADVERTISE	(MDIO_MII_BASE + MII_ADVERTISE)
#define MDIO_MII_LPA		(MDIO_MII_BASE + MII_LPA)
#define MDIO_MII_CTRL1000	(MDIO_MII_BASE + MII_CTRL1000)
#define MDIO_MII_STAT1000	(MDIO_MII_BASE + MII_STAT1000)
#define MDIO_MII_ESTATUS	(MDIO_MII_BASE + MII_ESTATUS)

/* MDIO_MMD_VEND1 registers */
#define STATUS			0x400D
#define GOOD_CRC			(1 << 14)
#define MAC_LINK			(1 << 13)
#define LINESIDE_XFI_PHY	(1 << 11)
#define COPPER_LINK			(1 << 5)
#define COPPER_SPEED_SHIFT	(2)
#define COPPER_SPEED_MASK	(7 << COPPER_SPEED_SHIFT)
#define COPPER_SPEED_2P5G	(1 << COPPER_SPEED_SHIFT)
#define COPPER_SPEED_100M	(2 << COPPER_SPEED_SHIFT)
#define COPPER_SPEED_5G		(3 << COPPER_SPEED_SHIFT)
#define COPPER_SPEED_1G		(4 << COPPER_SPEED_SHIFT)
#define COPPER_SPEED_10G	(6 << COPPER_SPEED_SHIFT)
#define COPPER_DETECTED		(1 << 1)

#define REQ1_STATUS		0x400E
#define DONT_CHANGE_STRAP	(1 << 1)

#define FW_REV			0x400F
#define FW_BUILD_VER_SHIFT	(12)
#define FW_BUILD_VER_MASK	(0xF << FW_BUILD_VER_SHIFT)
#define FW_MAIN_VER_SHIFT	(7)
#define FW_MAIN_VER_MASK	(0x1F << FW_MAIN_VER_SHIFT)
#define FW_BRANCH_VER_MASK	(0x7F)

#define FW_DATE			0x4010
#define FW_YEAR4_SHIFT	(13)
#define FW_YEAR4_MASK	(1 << FW_YEAR4_SHIFT)
#define FW_MONTH_SHIFT	(9)
#define FW_MONTH_MASK	(0xF << FW_MONTH_SHIFT)
#define FW_DAY_SHIFT	(4)
#define FW_DAY_MASK		(0x1F << FW_DAY_SHIFT)
#define FW_YEAR_MASK	(0xF)

#define BCM8488X_PINSTRAP	0x401A
#define BCM8488X_SUPER_I	(1 << 15)

#define BCM5499X_PINSTRAP	0x401C
#define BCM5499X_SUPER_I	(1 << 8)

/* MDIO Command Handler Register set */
#define MDIO_CMD_TIMEOUT	50

#define MDIO_CMD		0x4005
#define MDIO_CMD_SET_PAIR_SWAP	0x8001
#define MDIO_CMD_MSK_PAIR_SWAP	0x2
#define MDIO_CMD_VAL_PAIR_SWAP	0x1b
#define MDIO_CMD_SET_LED_TYPE	0x8022
#define MDIO_CMD_MSK_LED_TYPE	0x1
#define MDIO_CMD_VAL_LED_FW	0x0000
#define MDIO_CMD_VAL_LED_USER	0x0001
#define MDIO_CMD_SET_USXGMII	0x8026
#define MDIO_CMD_GET_USXGMII	0x8027
#define MDIO_CMD_MSK_USXGMII	0x17
#define MDIO_CMD_MSK_USXGMII_G	0x5
#define MDIO_CMD_VAL_USXGMII_EN	0x0001
#define MDIO_CMD_VAL_USXGMII_AN	0x0000
#define MDIO_CMD_VAL_USXGMII_2P5	0x0241
#define MDIO_CMD_VAL_USXGMII_5	0x0242
#define MDIO_CMD_VAL_USXGMII_10	0x0244
#define MDIO_CMD_VAL_USXGMII_MP	0x0000
#define MDIO_CMD_GET_CURR_TEMP	0x8031
#define MDIO_CMD_MSK_CURR_TEMP	0x1

#define MDIO_STATUS		0x4037
#define MDIO_CMD_IN_PROGRESS	0x0002
#define MDIO_CMD_COMPLETE_PASS	0x0004
#define MDIO_CMD_COMPLETE_ERROR	0x0008
#define MDIO_CMD_SYSTEM_BUSY	0xBBBB

#define MDIO_DATA1		0x4038
#define MDIO_DATA2		0x4039
#define MDIO_DATA3		0x403a
#define MDIO_DATA4		0x403b
#define MDIO_DATA5		0x403c

/* MDIO Command Handler Sequence macros */
enum bcm8488x_mdio_cmd_operation {
	MDIO_READ_OUT,
	MDIO_READ_POLL,
	MDIO_WRITE_IN,
	MDIO_CMD_MAX,
};

/* Firmware filenames */
#define BCM8488_A0_FILE "bcm8488x/BCM8488-A0-TCM.bin"
#define BCM8488_B0_FILE "bcm8488x/BCM8488-B0-TCM.bin"
#define BCM5499_A0_FILE "bcm8488x/BCM5499-A0-TCM.bin"
#define BLACKFIN_B0_FILE "bcm8488x/BLACKFIN-B0-TCM.bin"
#define LONGFIN_FILE "bcm8488x/LONGFIN-TCM.bin"

/* core */
enum bcm8488x_core_index {
	BCM8488X_CORE = 0,
	BCM54991E_CORE,
	BCM5499X_CORE,
};

/* devad for comparing devid */
enum bcm8488x_devad_devid {
	BCM8488X_DEVAD = MDIO_MMD_PCS,
	BCM5499X_DEVAD = MDIO_MMD_PMAPMD,
};

/* BCM8488 Model IDs */
enum bcm8488x_model_ids {
	BCM84880_A0 = 0x18,
	BCM84880_B0 = 0x19,
	BCM84886_B0 = 0x31,
};

/* BCM5499/BCM8489 Model IDs */
enum bcm5499x_model_ids {
	BCM84891L_B0   = 0x001,
	BCM54991EL_A0  = 0x008,
	BCM54991EL_B0  = 0x009,
	BCM84891_A0    = 0x010,
	BCM54991E_A0   = 0x018,
	BCM50991EL_B0  = 0x049,
	BCM84892_B0    = 0x021,
	BCM54991ELM_A0 = 0x108,
	BCM50991ELM_B0 = 0x10D,
};

enum bcm8488x_sequences {
	BCM8488X_HALT_SEQ0 = 0,
	BCM8488X_HALT_SEQ1,
	BCM8488X_HALT_SEQ2,
	BCM8488X_BCAST_SEQ,
	BCM8488X_START_SEQ,
	BCM8488X_SUPER_I_SEQ,
	BCM8488X_MAX_SEQ,
};

struct bcm8488x_core {
	unsigned short *seq[BCM8488X_MAX_SEQ];
	unsigned int seqlen[BCM8488X_MAX_SEQ];
	u16 devad_id;
};

struct bcm8488x_prop {
	u32 phy_id;
	u16 lane_max;
	const char *model;
	const char *fw_name;
	struct bcm8488x_core *core;
	u32 max_speed;
};

#define BCM8488X_PHYS_MAX 4
struct bcm8488x_phys {
	struct phy_device *phydev[BCM8488X_PHYS_MAX];
	struct mutex lock;
	u32 lane_map;
	u32 lane_set;
};

struct bcm8488x_lane {
	struct bcm8488x_prop *prop;
	struct bcm8488x_phys *phys;
	struct device *hwmon_dev;
	int status;
	int speed;
	u32 mask;
	u32 idx;
	u32 fixed_link;
	bool pair_swap;
};

#endif /* _LINUX_BCM8488X_H */
