
FILESEXTRAPATHS_prepend := "${THISDIR}/${BPN}-${PV}:"

# TCHBCM-240: move the cfg setting to common OEM layer; no longer need to patch netxl20 after SWRGROUTER-12765
# SRC_URI_append_tchxb6 += "file://netxl20-bcm_nio.cfg"
# SRC_URI_append_tchxb6 += "file://netxl20-kernel.patch"

SRC_URI += "file://spi.patch"
SRC_URI += "file://squashfs.cfg"
SRC_URI += "file://spidev.cfg"
SRC_URI += "file://pci-brcmstb_memory_api.cfg"
SRC_URI_append_tchxb6 += "file://SWRGROUTER-14639_0005-0009_pcie-brcmstb.patch"
SRC_URI_append_tchxb6 += "file://SWRGROUTER-13537_pcie_post-linkup_delay.patch"
SRC_URI += "file://gpio_direction_affects_led_tcxb6-2094_19.2.patch"
SRC_URI += "file://ecryptfs.cfg"
SRC_URI += "file://nf_conn.cfg"

SRC_URI += " ${@bb.utils.contains('DISTRO_FEATURES', 'wifi-emulator', 'file://mac80211.cfg', '', d)} "
SRC_URI += " ${@bb.utils.contains('DISTRO_FEATURES', 'wifi-emulator', 'file://mac80211_fix.patch', '', d)} "
SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES', 'wifi-emulator', '${RDK_CPC_ROOT_GIT}/rdkfmac;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH};name=rdkfmac', '', d)}"
SRC_URI += " ${@bb.utils.contains('DISTRO_FEATURES', 'wifi-emulator', 'file://rdkfmac.patch', '', d)} "

SRC_URI_append_tchxb6 += "file://MTD_LCK_UNLCK_TCXB6-10026_21.3.patch"

# Starting from OpenBFC 20.2, DHD is enabled by default.
SRC_URI_append_tchxb6 += "file://disable_bcm_runner_offload.cfg"
SRC_URI += "file://TCHBCM-260_Zigbee_LED_Clkfreq.patch"
SRC_URI += "file://TCHBCM-248_CacheFlush_IncTimeout_5.4.patch"
SRC_URI += "file://TCHBCM-377_Kioxia_AutoBKOPSEnbl.patch"

# RDKB-45972 for XB8 channel change
#   SWRGROUTER-15116 has disabled CFG80211 CRDA by default, so enable it for non-BCM WiFi
SRC_URI_append_tchxb6 = " file://TCHBCM-441_enable-CFG80211_CRDA_SUPPORT.patch"

do_configure_prepend() {
    if ${@bb.utils.contains('DISTRO_FEATURES','wifi-emulator','true','false',d)}; then
        mkdir -p ${S}/drivers/net/wireless/rdkfmac
        cp -r ${WORKDIR}/git/src/* ${S}/drivers/net/wireless/rdkfmac
    fi
}
