 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/proc_fs.h>
#include <linux/if_link.h>
#include <linux/netdevice.h>
#include <linux/bcm_media_gw/msgfifo.h>
#include "dqnet_priv.h"
#include "dqnet_fap.h"
#include "BcmGfapApi.h"
#include "fpm.h"

static int dqnet_gfap_init_system(void)
{
	return 0;
}

static int dqnet_gfap_init_port(struct net_device *dev)
{
	return 0;
}

static int dqnet_gfap_get_tx_prio(struct net_device *dev, int *prio)
{
	*prio = 0;
	return 0;
}

static int dqnet_gfap_get_tx_q_type(struct net_device *dev,
				    enum dqnet_q_type *type)
{
	*type = DQNET_QUEUE_US;
	return 0;
}

/*
 * Query the GFAP for stats on the interface
 *
 * Parameters
 *      dev	device to query
 *      stats	statistics struct to fill in
*/
static struct rtnl_link_stats64 *dqnet_gfap_link_stats(struct net_device *dev,
				 struct rtnl_link_stats64 *stats)
{
	struct dqnet_netdev *ndev = netdev_priv(dev);

	pr_debug("%s:-->\n",dev->name);

	if (stats) {
		stats->rx_packets =
			BcmGfapApi_GetMacIdRxPacketUnicastCounter(
					ndev->if_id, false);
		stats->multicast =
			BcmGfapApi_GetMacIdRxPacketMulticastCounter(
					ndev->if_id, false);
		stats->rx_packets += stats->multicast;
		stats->rx_packets +=
			BcmGfapApi_GetMacIdRxPacketBroadcastCounter(
					ndev->if_id, false);
		stats->tx_packets =
			BcmGfapApi_GetMacIdTxPacketUnicastCounter(
					ndev->if_id, false);
		stats->tx_packets +=
			BcmGfapApi_GetMacIdTxPacketMulticastCounter(
					ndev->if_id, false);
		stats->tx_packets +=
			BcmGfapApi_GetMacIdTxPacketBroadcastCounter(
					ndev->if_id, false);
		stats->rx_bytes =
			BcmGfapApi_GetMacIdRxByteUnicastCounter(
					ndev->if_id, false);
		stats->rx_bytes +=
			BcmGfapApi_GetMacIdRxByteMulticastCounter(
					ndev->if_id, false);
		stats->rx_bytes +=
			BcmGfapApi_GetMacIdRxByteBroadcastCounter(
					ndev->if_id, false);
		stats->tx_bytes =
			BcmGfapApi_GetMacIdTxByteUnicastCounter(
					ndev->if_id, false);
		stats->tx_bytes +=
			BcmGfapApi_GetMacIdTxByteMulticastCounter(
					ndev->if_id, false);
		stats->tx_bytes +=
			BcmGfapApi_GetMacIdTxByteBroadcastCounter(
					ndev->if_id, false);
	}

	pr_debug("%s:<--\n",dev->name);

	return stats;
}

static int dqnet_gfap_get_tag_len(struct net_device *dev)
{
	return 0;
}

static int dqnet_gfap_add_tag(struct net_device *dev, struct fpm_buff *fb)
{
	return 0;
}

static enum dqnet_qmsg_fmt dqnet_gfap_get_qmsg_fmt(struct net_device *dev)
{
	return DQNET_QMSG_FMT_GFAP_FPM;
}

static int dqnet_gfap_imp_lag_port(struct net_device *dev)
{
	return 0;
}

static int dqnet_gfap_dump(void)
{
	return 0;
}
struct dqnet_fap_ops dqnet_gfap = {
	.init_system	= dqnet_gfap_init_system,
	.init_port	= dqnet_gfap_init_port,
	.get_tx_prio	= dqnet_gfap_get_tx_prio,
	.get_tx_q_type	= dqnet_gfap_get_tx_q_type,
	.link_stats	= dqnet_gfap_link_stats,
	.get_tag_len	= dqnet_gfap_get_tag_len,
	.add_tag	= dqnet_gfap_add_tag,
	.get_qmsg_fmt	= dqnet_gfap_get_qmsg_fmt,
	.dump           = dqnet_gfap_dump,
	.get_imp_lag_port = dqnet_gfap_imp_lag_port,
};
EXPORT_SYMBOL(dqnet_gfap);

MODULE_LICENSE("GPL v2");
