 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef _ETHSW_CORE_H_
#define _ETHSW_CORE_H_

#ifdef __KERNEL__
#include <linux/kernel.h>
#endif


/****************************************************************************
  Page List
****************************************************************************/

#define PAGE_CTLREG                                             0x00
#define PAGE_STSREG                                             0x01
#define PAGE_MNGMODE                                            0x02
#define PAGE_CTLREG_1                                           0x03
#define PAGE_ARLCTL                                             0x04
#define PAGE_ARLACCS                                            0x05
#define PAGE_FLOWCON                                            0x0A
#define PAGE_FLOWCON_LAN                                        0x0B
#define PAGE_FLOWCON_IMP0                                       0x0D
#define PAGE_FLOWCON_WAN_IMP1                                   0x0C
#define PAGE_PORT_0_INT                                         0x10
#define PAGE_PORT_1_INT                                         0x11
#define PAGE_PORT_2_INT                                         0x12
#define PAGE_PORT_3_INT                                         0x13
#define PAGE_PORT_4_INT                                         0x14
#define PAGE_PORT_7_INT                                         0x17
#define PAGE_MIB_PORT_0                                         0x20
#define PAGE_MIB_PORT_1                                         0x21
#define PAGE_MIB_PORT_2                                         0x22
#define PAGE_MIB_PORT_3                                         0x23
#define PAGE_MIB_PORT_4                                         0x24
#define PAGE_MIB_PORT_5                                         0x25
#define PAGE_MIB_PORT_7                                         0x27
#define PAGE_MIB_PORT_IMP                                       0x28
#define PAGE_QOS                                                0x30
#define PAGE_VLAN                                               0x31
#define PAGE_TRUNK                                              0x32
#define PAGE_BCM8021Q                                           0x34
#define PAGE_DOS                                                0x36
#define PAGE_JUMBO_CTRL                                         0x40
#define PAGE_BC_SUPPRESS                                        0x41
#define PAGE_IEEE8021X                                          0x42
#define PAGE_IEEE8021S                                          0x43
#define PAGE_MAC_LIMIT                                          0x45
#define PAGE_SCHEDULER                                          0x46
#define PAGE_EGRESS_SHAPER_CTRREG                               0x47
#define PAGE_EGRESS_SHAPER_Q0_CONFIG                            0x48
#define PAGE_EGRESS_SHAPER_Q1_CONFIG                            0x49
#define PAGE_EGRESS_SHAPER_Q2_CONFIG                            0x4A
#define PAGE_EGRESS_SHAPER_Q3_CONFIG                            0x4B
#define PAGE_EGRESS_SHAPER_Q4_CONFIG                            0x4C
#define PAGE_EGRESS_SHAPER_Q5_CONFIG                            0x4D
#define PAGE_EGRESS_SHAPER_Q6_CONFIG                            0x4E
#define PAGE_EGRESS_SHAPER_Q7_CONFIG                            0x4F
#define PAGE_MIB_SNAPSHOT                                       0x70
#define PAGE_MIB_SNAPSHOT_PORT                                  0x71
#define PAGE_PORT5_EXT                                          0x85
#define PAGE_MII_PORT_EXT                                       0x88
#define PAGE_AVB                                                0x90
#define PAGE_TRREG                                              0x91
#define PAGE_EEE_CTL                                            0x92
#define PAGE_IEEE_1588v2_PAGE0                                  0x93
#define PAGE_IEEE_1588v2_PAGE1                                  0x94
#define PAGE_WRED                                               0x95
#define PAGE_CFP                                                0xA0
#define PAGE_CFP_CTL                                            0xA1

/****************************************************************************
  Page 00h: PAGE_CTLREG, Control Registers
****************************************************************************/

#define CREG_G_PCTL_P0                                          0x00
#define CREG_G_PCTL_P1                                          0x01
#define CREG_G_PCTL_P2                                          0x02
#define CREG_G_PCTL_P3                                          0x03
#define CREG_G_PCTL_P4                                          0x04
#define CREG_G_PCTL_P5                                          0x05
#define CREG_G_PCTL_P7                                          0x07

#define CREG_G_PCTL                                             CREG_G_PCTL_P0
	#define CREG_G_PCTL_SIZE                                    1
	#define CREG_G_PCTL_STEP                                    1

	#define CREG_G_PCTL_G_MISTP_STATE_MASK                      0xe0
	#define CREG_G_PCTL_G_MISTP_STATE_SHIFT                     5
	#define CREG_G_PCTL_G_MISTP_STATE_NO_ST                     0
	#define CREG_G_PCTL_G_MISTP_STATE_DISABLED                  1
	#define CREG_G_PCTL_G_MISTP_STATE_BLOCKING                  2
	#define CREG_G_PCTL_G_MISTP_STATE_LISTENING                 3
	#define CREG_G_PCTL_G_MISTP_STATE_LEARNING                  4
	#define CREG_G_PCTL_G_MISTP_STATE_FORWARDING                5

	#define CREG_G_PCTL_TX_DIS_MASK                             0x02
	#define CREG_G_PCTL_TX_DIS_SHIFT                            1

	#define CREG_G_PCTL_RX_DIS_MASK                             0x01
	#define CREG_G_PCTL_RX_DIS_SHIFT                            0


#define CREG_IMP_CTL                                            0x08
	#define CREG_IMP_CTL_SIZE                                   1

	#define CREG_IMP_CTL_RX_UCST_EN_MASK                        0x10
	#define CREG_IMP_CTL_RX_UCST_EN_SHIFT                       4

	#define CREG_IMP_CTL_RX_MCST_EN_MASK                        0x08
	#define CREG_IMP_CTL_RX_MCST_EN_SHIFT                       3

	#define CREG_IMP_CTL_RX_BCST_EN_MASK                        0x04
	#define CREG_IMP_CTL_RX_BCST_EN_SHIFT                       2

#define CREG_SWMODE                                             0x0B
	#define CREG_SWMODE_SIZE                                    1

	#define CREG_SWMODE_NOBLKCD_MASK                            0x10
	#define CREG_SWMODE_NOBLKCD_SHIFT                           4

	#define CREG_SWMODE_FAST_TXDESC_RERURN_MASK                 0x08
	#define CREG_SWMODE_FAST_TXDESC_RERURN_SHIFT                3

	#define CREG_SWMODE_RTRY_LMT_DIS_MASK                       0x04
	#define CREG_SWMODE_RTRY_LMT_DIS_SHIFT                      2

	#define CREG_SWMODE_SW_FWDG_EN_MASK                         0x02
	#define CREG_SWMODE_SW_FWDG_EN_SHIFT                        1

	#define CREG_SWMODE_SW_FWDG_MODE_MASK                       0x01
	#define CREG_SWMODE_SW_FWDG_MODE_SHIFT                      0

#define CREG_STS_OVERRIDE_IMP                                   0x0E
	#define CREG_STS_OVERRIDE_IMP_SIZE                          1

	#define CREG_STS_OVERRIDE_IMP_MII_SW_OR_MASK                0x80
	#define CREG_STS_OVERRIDE_IMP_MII_SW_OR_SHIFT               7

	#define CREG_STS_OVERRIDE_IMP_GMII_SPEED_UP_2G_MASK         0x40
	#define CREG_STS_OVERRIDE_IMP_GMII_SPEED_UP_2G_SHIFT        6

	#define CREG_STS_OVERRIDE_IMP_TXFLOW_CNTL_MASK              0x20
	#define CREG_STS_OVERRIDE_IMP_TXFLOW_CNTL_SHIFT             5

	#define CREG_STS_OVERRIDE_IMP_RXFLOW_CNTL_MASK              0x10
	#define CREG_STS_OVERRIDE_IMP_RXFLOW_CNTL_SHIFT             4

	#define CREG_STS_OVERRIDE_IMP_SPEED_MASK                    0x0c
	#define CREG_STS_OVERRIDE_IMP_SPEED_SHIFT                   2

	#define CREG_STS_OVERRIDE_IMP_DUPLX_MODE_MASK               0x02
	#define CREG_STS_OVERRIDE_IMP_DUPLX_MODE_SHIFT              1

	#define CREG_STS_OVERRIDE_IMP_LINK_STS_MASK                 0x01
	#define CREG_STS_OVERRIDE_IMP_LINK_STS_SHIFT                0

#define CREG_NEW_CTRL                                           0x21
	#define CREG_NEW_CTRL_SIZE                                  1
	#define CREG_NEW_CTRL_MC_FWD_EN_MASK                        0x80
	#define CREG_NEW_CTRL_MC_FWD_EN_SHIFT                       7
	#define CREG_NEW_CTRL_UC_FWD_EN_MASK                        0x40
	#define CREG_NEW_CTRL_UC_FWD_EN_SHIFT                       6

#define CREG_SWITCH_CTRL                                        0x22
	#define CREG_SWITCH_CTRL_SIZE                               2

	#define CREG_SWITCH_CTRL_MII_DUMB_FWDG_EN_MASK              0x0040
	#define CREG_SWITCH_CTRL_MII_DUMB_FWDG_EN_SHIFT             6

#define CREG_WAN_PORT_SEL                                       0x26
	#define CREG_WAN_PORT_SEL_SIZE                              2

	#define CREG_WAN_PORT_SEL_EN_MAN2WAN_MASK                   0x0200
	#define CREG_WAN_PORT_SEL_EN_MAN2WAN_SHIFT                  9

	#define CREG_WAN_PORT_SEL_WAN_SELECT_MASK                   0x00ff
	#define CREG_WAN_PORT_SEL_WAN_SELECT_SHIFT                  0

#define CREG_PAUSE_CAPABILITY_REG                             	0x28
	#define CREG_PAUSE_CAPABILITY_REG_SIZE						4
	#define CREG_PAUSE_CAPABILITY_EN_LAN_PORTS_DEFAULT_VAL      0x807E3f

#define CREG_ULF_DROP_MAP                                       0x32
	#define CREG_ULF_DROP_MAP_SIZE                             2
#define CREG_MLF_DROP_MAP                                       0x34
	#define CREG_MLF_DROP_MAP_SIZE                             2
#define CREG_MLF_IPMC_FWD_MAP                                   0x36
	#define CREG_MLF_IPMC_FWD_MAP_SIZE                         2
#define CREG_HW_LEARN                                           0x3C
	#define CREG_HW_LEARN_SIZE                                 2

#define CREG_SW_LEARN                                           0x3E
	#define CREG_SW_LEARN_SIZE                                 2

#define CREG_FAST_AGEING                                        0x88
	#define CREG_FAST_AGEING_SIZE                              1

	#define CREG_FAST_AGEING_FAST_AGE_STR_DONE_MASK      0x80
	#define CREG_FAST_AGEING_FAST_AGE_STR_DONE_SHIFT     7

	#define CREG_FAST_AGEING_EN_AGE_PORT_MASK            0x04
	#define CREG_FAST_AGEING_EN_AGE_PORT_SHIFT           2

#define CREG_FAST_AGE_PORT                                        0x89
	#define CREG_FAST_AGE_PORT_SIZE                              1

#define CREG_STS_OVERRIDE_GMII_P0                               0x58
#define CREG_STS_OVERRIDE_GMII_P1                               0x59
#define CREG_STS_OVERRIDE_GMII_P2                               0x5A
#define CREG_STS_OVERRIDE_GMII_P3                               0x5B
#define CREG_STS_OVERRIDE_GMII_P4                               0x5C
#define CREG_STS_OVERRIDE_P5                                    0x5D
#define CREG_STS_OVERRIDE_P7                                    0x5F

#define CREG_STS_OVERRIDE_GMII                                  CREG_STS_OVERRIDE_GMII_P0
	#define CREG_STS_OVERRIDE_GMII_SIZE                         1
	#define CREG_STS_OVERRIDE_GMII_STEP                         1

	#define CREG_STS_OVERRIDE_GMII_SPEED_UP_2G_MASK             0x80
	#define CREG_STS_OVERRIDE_GMII_SPEED_UP_2G_SHIFT            7

	#define CREG_STS_OVERRIDE_GMII_SW_OVERRIDE_MASK             0x40
	#define CREG_STS_OVERRIDE_GMII_SW_OVERRIDE_SHIFT            6

	#define CREG_STS_OVERRIDE_GMII_TXFLOW_CNTL_MASK             0x20
	#define CREG_STS_OVERRIDE_GMII_TXFLOW_CNTL_SHIFT            5

	#define CREG_STS_OVERRIDE_GMII_RXFLOW_CNTL_MASK             0x10
	#define CREG_STS_OVERRIDE_GMII_RXFLOW_CNTL_SHIFT            4

	#define CREG_STS_OVERRIDE_GMII_SPEED_MASK                   0x0c
	#define CREG_STS_OVERRIDE_GMII_SPEED_SHIFT                  2

	#define CREG_STS_OVERRIDE_GMII_DUPLX_MODE_MASK              0x02
	#define CREG_STS_OVERRIDE_GMII_DUPLX_MODE_SHIFT             1

	#define CREG_STS_OVERRIDE_GMII_LINK_STS_MASK                0x01
	#define CREG_STS_OVERRIDE_GMII_LINK_STS_SHIFT               0

#define CREG_RSV_MCAST_CTRL                                     0x2F
	#define CREG_RSV_MCAST_CTRL_SIZE                            1

	#define CREG_RSV_MCAST_CTRL_EN_RES_MUL_LEARN_MASK           0x80
	#define CREG_RSV_MCAST_CTRL_EN_RES_MUL_LEARN_SHIFT          7

	#define CREG_RSV_MCAST_CTRL_EN_MUL_4_MASK                   0x10
	#define CREG_RSV_MCAST_CTRL_EN_MUL_4_SHIFT                  4

	#define CREG_RSV_MCAST_CTRL_EN_MUL_3_MASK                   0x08
	#define CREG_RSV_MCAST_CTRL_EN_MUL_3_SHIFT                  3

	#define CREG_RSV_MCAST_CTRL_EN_MUL_2_MASK                   0x04
	#define CREG_RSV_MCAST_CTRL_EN_MUL_2_SHIFT                  2

	#define CREG_RSV_MCAST_CTRL_EN_MUL_1_MASK                   0x02
	#define CREG_RSV_MCAST_CTRL_EN_MUL_1_SHIFT                  1

	#define CREG_RSV_MCAST_CTRL_EN_MUL_0_MASK                   0x01
	#define CREG_RSV_MCAST_CTRL_EN_MUL_0_SHIFT                  0

#define CREG_WATCH_DOG_CTRL                                     0x79
	#define CREG_WATCH_DOG_CTRL_SIZE                            1
	#define CREG_WATCH_DOG_CTRL_EN_RESET_MASK                   0x01
	#define CREG_WATCH_DOG_CTRL_EN_RESET_SHIFT		            4
	#define CREG_WATCH_DOG_CTRL_SOFTWARE_RESET_MASK             0x01
	#define CREG_WATCH_DOG_CTRL_SOFTWARE_RESET_SHIFT            7

/****************************************************************************
  Page 01h: PAGE_STSREG, Status Registers
****************************************************************************/

#define CREG_LNKSTS                                             0x00
	#define CREG_LNKSTS_SIZE                                    2

#define CREG_LNKSTSCHG                                          0x02
	#define CREG_LNKSTSCHG_SIZE                                 2

#define CREG_SPDSTS                                             0x04
	#define CREG_SPDSTS_SIZE                                    4

#define CREG_DUPSTS                                             0x08
	#define CREG_DUPSTS_SIZE                                    2

#define CREG_PAUSESTS                                           0x0A
	#define CREG_PAUSESTS_SIZE                                  4

#define CREG_SRCADRCHG                                          0x0E
	#define CREG_SRCADRCHG_SIZE                                 2

/****************************************************************************
  Page 02h: PAGE_MNGMODE, Management Mode Registers
****************************************************************************/

#define CREG_GMNGCFG                                            0x00
	#define CREG_GMNGCFG_SIZE                                   1

	#define CREG_GMNGCFG_FRM_MNGP_MASK                          0xc0
	#define CREG_GMNGCFG_FRM_MNGP_SHIFT                         6

	#define CREG_GMNGCFG_RXBPDU_EN_MASK                         0x02
	#define CREG_GMNGCFG_RXBPDU_EN_SHIFT                        1

	#define CREG_GMNGCFG_RST_MIB_CNT_MASK                       0x01
	#define CREG_GMNGCFG_RST_MIB_CNT_SHIFT                      0

#define CREG_BRCM_HDR_CTRL                                      0x03
	#define CREG_BRCM_HDR_CTRL_SIZE                             1

	#define CREG_BRCM_HDR_CTRL_BRCM_HDR_EN_MASK                 0x07
	#define CREG_BRCM_HDR_CTRL_BRCM_HDR_EN_SHIFT                0

#define CREG_SPTAGT                                             0x06
	#define CREG_SPTAGT_SIZE                                    4

#define CREG_BRCM_HDR_CTRL2                                     0x0a
	#define CREG_BRCM_HDR_CTRL2_SIZE                            2

	#define CREG_BRCM_HDR_CTRL2_BRCM_HDR_EN_MASK                0x001f
	#define CREG_BRCM_HDR_CTRL2_BRCM_HDR_EN_SHIFT               0

#define CREG_RST_MIB_CNT_EN                                     0x54
	#define CREG_RST_MIB_CNT_EN_SIZE                            2

#define CREG_BRCM_HDR_RX_DIS									0x60
	#define CREG_BRCM_HDR_RX_DIS_SIZE                           2

	#define CREG_BRCM_HDR_RX_DIS_PHY_PORT_MASK					0x1f
	#define CREG_BRCM_HDR_RX_DIS_IMP_PORT_MASK					0xe0

#define CREG_BRCM_HDR_TX_DIS									0x62
	#define CREG_BRCM_HDR_TX_DIS_SIZE                           2

	#define CREG_BRCM_HDR_TX_DIS_PHY_PORT_MASK					0x1f
	#define CREG_BRCM_HDR_TX_DIS_IMP_PORT_MASK					0xe0


/****************************************************************************
  Page 03h: PAGE_CTLREG_1, Control 1 Registers
****************************************************************************/

/****************************************************************************
  Page 04h: PAGE_ARLCTL, ARL Control Registers
****************************************************************************/

#define CREG_GARLCFG                                            0x00
	#define CREG_GARLCFG_SIZE                                   1

	#define CREG_GARLCFG_AGE_ACC_MASK                           0x04
	#define CREG_GARLCFG_AGE_ACC_SHIFT                          2

	#define CREG_GARLCFG_HASH_DISABLE_MASK                      0x01
	#define CREG_GARLCFG_HASH_DISABLE_SHIFT                     0

#define CREG_MULTI_PORT_CTL                                     0x0E
	#define CREG_MULTI_PORT_CTL_SIZE                            2

	#define CREG_MULTI_PORT_CTL_MPORT0_TS_EN_MASK               0x8000
	#define CREG_MULTI_PORT_CTL_MPORT0_TS_EN_SHIFT              15

	#define CREG_MULTI_PORT_CTL_SWITCH_RESV_MASK                0x7000
	#define CREG_MULTI_PORT_CTL_SWITCH_RESV_SHIFT               12

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL5_MASK                0x0c00
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL5_SHIFT               10

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL4_MASK                0x0300
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL4_SHIFT               8

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL3_MASK                0x00c0
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL3_SHIFT               6

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL2_MASK                0x0030
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL2_SHIFT               4

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL1_MASK                0x000c
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL1_SHIFT               2

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL0_MASK                0x0003
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL0_SHIFT               0

	#define CREG_MULTI_PORT_CTL_MPORT_CTRL_MASK                 CREG_MULTI_PORT_CTL_MPORT_CTRL0_MASK
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL_SHIFT                CREG_MULTI_PORT_CTL_MPORT_CTRL0_SHIFT
	#define CREG_MULTI_PORT_CTL_MPORT_CTRL_BSTEP                2

#define CREG_MULTIPORT_ADDR0                                    0x10
#define CREG_MPORTVEC0                                          0x18
#define CREG_MULTIPORT_ADDR1                                    0x20
#define CREG_MPORTVEC1                                          0x28
#define CREG_MULTIPORT_ADDR2                                    0x30
#define CREG_MPORTVEC2                                          0x38
#define CREG_MULTIPORT_ADDR3                                    0x40
#define CREG_MPORTVEC3                                          0x48
#define CREG_MULTIPORT_ADDR4                                    0x50
#define CREG_MPORTVEC4                                          0x58
#define CREG_MULTIPORT_ADDR5                                    0x60
#define CREG_MPORTVEC5                                          0x68

#define CREG_MULTIPORT_ADDR                                     CREG_MULTIPORT_ADDR0
	#define CREG_MULTIPORT_ADDR_SIZE                            8
	#define CREG_MULTIPORT_ADDR_STEP                            16

	#define CREG_MULTIPORT_ADDR_MPORT_E_TYPE_MASK               0xffff000000000000
	#define CREG_MULTIPORT_ADDR_MPORT_E_TYPE_SHIFT              48

	#define CREG_MULTIPORT_ADDR_MPORT_ADDR_MASK                 0x00000000
	#define CREG_MULTIPORT_ADDR_MPORT_ADDR_SHIFT                0

#define CREG_MPORTVEC                                           CREG_MPORTVEC0
	#define CREG_MPORTVEC_SIZE                                  4
	#define CREG_MPORTVEC_STEP                                  16

	#define CREG_MPORTVEC_PORT_VCTR_MASK                        0x000001ff
	#define CREG_MPORTVEC_PORT_VCTR_SHIFT                       0

/****************************************************************************
  Page 05h: PAGE_ARLACCS, ARL Access Registers
****************************************************************************/

#define CREG_ARLA_RWCTL                                         0x00
	#define CREG_ARLA_RWCTL_SIZE                                1

	#define CREG_ARLA_RWCTL_ARL_STRTDN_MASK                     0x80
	#define CREG_ARLA_RWCTL_ARL_STRTDN_SHIFT                    7

	#define CREG_ARLA_RWCTL_IVL_SVL_SELECT_MASK                 0x40
	#define CREG_ARLA_RWCTL_IVL_SVL_SELECT_SHIFT                6

	#define CREG_ARLA_RWCTL_ARL_RW_MASK                         0x01
	#define CREG_ARLA_RWCTL_ARL_RW_SHIFT                        0

#define CREG_ARLA_MAC                                           0x02
	#define CREG_ARLA_MAC_SIZE                                  6

#define CREG_ARLA_VID                                           0x08
	#define CREG_ARLA_VID_SIZE                                  2

#define CREG_ARLA_MACVID_ENTRY0                                 0x10
#define CREG_ARLA_FWD_ENTRY0                                    0x18
#define CREG_ARLA_MACVID_ENTRY1                                 0x20
#define CREG_ARLA_FWD_ENTRY1                                    0x28
#define CREG_ARLA_MACVID_ENTRY2                                 0x30
#define CREG_ARLA_FWD_ENTRY2                                    0x38
#define CREG_ARLA_MACVID_ENTRY3                                 0x40
#define CREG_ARLA_FWD_ENTRY3                                    0x48

#define CREG_ARLA_MACVID_ENTRY                                  CREG_ARLA_MACVID_ENTRY0
	#define CREG_ARLA_MACVID_ENTRY_SIZE                         8
	#define CREG_ARLA_MACVID_ENTRY_STEP                         16

	#define CREG_ARLA_MACVID_ENTRY_VID_MASK                     0xfff000000000000
	#define CREG_ARLA_MACVID_ENTRY_VID_SHIFT                    48

	#define CREG_ARLA_MACVID_ENTRY_ARL_MACADDR_MASK             0x00000000
	#define CREG_ARLA_MACVID_ENTRY_ARL_MACADDR_SHIFT            0

#define CREG_ARLA_FWD_ENTRY                                     CREG_ARLA_FWD_ENTRY0
	#define CREG_ARLA_FWD_ENTRY_SIZE                            4
	#define CREG_ARLA_FWD_ENTRY_STEP                            16

	#define CREG_ARLA_FWD_ENTRY_ARL_VALID_MASK                  0x00010000
	#define CREG_ARLA_FWD_ENTRY_ARL_VALID_SHIFT                 16

	#define CREG_ARLA_FWD_ENTRY_ARL_STATIC_MASK                 0x00008000
	#define CREG_ARLA_FWD_ENTRY_ARL_STATIC_SHIFT                15

	#define CREG_ARLA_FWD_ENTRY_ARL_AGE_MASK                    0x00004000
	#define CREG_ARLA_FWD_ENTRY_ARL_AGE_SHIFT                   14

	#define CREG_ARLA_FWD_ENTRY_ARL_PRI_MASK                    0x00003800
	#define CREG_ARLA_FWD_ENTRY_ARL_PRI_SHIFT                   11

	#define CREG_ARLA_FWD_ENTRY_ARL_CON_MASK                    0x00000600
	#define CREG_ARLA_FWD_ENTRY_ARL_CON_SHIFT                   9

	#define CREG_ARLA_FWD_ENTRY_PORTID_MASK                     0x000001ff
	#define CREG_ARLA_FWD_ENTRY_PORTID_SHIFT                    0

#define CREG_ARLA_VTBL_RWCTRL                                   0x80
	#define CREG_ARLA_VTBL_RWCTRL_SIZE                          1

	#define CREG_ARLA_VTBL_RWCTRL_VTBL_STDN_MASK                0x80
	#define CREG_ARLA_VTBL_RWCTRL_VTBL_STDN_SHIFT               7

	#define CREG_ARLA_VTBL_RWCTRL_VTBL_RW_CLR_MASK              0x03
	#define CREG_ARLA_VTBL_RWCTRL_VTBL_RW_CLR_SHIFT             0

#define CREG_ARLA_VTBL_ADDR                                     0x81
	#define CREG_ARLA_VTBL_ADDR_SIZE                            2

#define CREG_ARLA_VTBL_ENTRY                                    0x83
	#define CREG_ARLA_VTBL_ENTRY_SIZE                           4

	#define CREG_ARLA_VTBL_ENTRY_FWD_MODE_MASK                  0x00200000
	#define CREG_ARLA_VTBL_ENTRY_FWD_MODE_SHIFT                 21

	#define CREG_ARLA_VTBL_ENTRY_MSPT_INDEX_MASK                0x001c0000
	#define CREG_ARLA_VTBL_ENTRY_MSPT_INDEX_SHIFT               18

	#define CREG_ARLA_VTBL_ENTRY_UNTAG_MAP_MASK                 0x0003fe00
	#define CREG_ARLA_VTBL_ENTRY_UNTAG_MAP_SHIFT                9

	#define CREG_ARLA_VTBL_ENTRY_FWD_MAP_MASK                   0x000001ff
	#define CREG_ARLA_VTBL_ENTRY_FWD_MAP_SHIFT                  0

/****************************************************************************
  Page 0Ah: PAGE_FLOWCON, Flow Control Registers
****************************************************************************/

#define CREG_FC_PAUSE_DROP_CTRL                                 0x1C
	#define CREG_FC_PAUSE_DROP_CTRL_SIZE                        2

	#define CREG_FC_PAUSE_DROP_CTRL_QUEUE_BASED_PAUSE_EN_MASK   0x1000
	#define CREG_FC_PAUSE_DROP_CTRL_QUEUE_BASED_PAUSE_EN_SHIFT  12

	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP0_TOTAL_PAUSE_EN_MASK 0x0800
	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP0_TOTAL_PAUSE_EN_SHIFT 11

	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP0_TXQ_PAUSE_EN_MASK   0x0400
	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP0_TXQ_PAUSE_EN_SHIFT  10

	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP1_TOTAL_PAUSE_EN_MASK 0x0200
	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP1_TOTAL_PAUSE_EN_SHIFT 9

	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP1_TXQ_PAUSE_EN_MASK   0x0100
	#define CREG_FC_PAUSE_DROP_CTRL_TX_IMP1_TXQ_PAUSE_EN_SHIFT  8

	#define CREG_FC_PAUSE_DROP_CTRL_TX_TOTAL_PAUSE_EN_MASK      0x0080
	#define CREG_FC_PAUSE_DROP_CTRL_TX_TOTAL_PAUSE_EN_SHIFT     7

	#define CREG_FC_PAUSE_DROP_CTRL_TX_TXQ_PAUSE_EN_MASK        0x0040
	#define CREG_FC_PAUSE_DROP_CTRL_TX_TXQ_PAUSE_EN_SHIFT       6

	#define CREG_FC_PAUSE_DROP_CTRL_RX_DROP_EN_MASK             0x0020
	#define CREG_FC_PAUSE_DROP_CTRL_RX_DROP_EN_SHIFT            5

	#define CREG_FC_PAUSE_DROP_CTRL_TX_TOTAL_DROP_EN_MASK       0x0010
	#define CREG_FC_PAUSE_DROP_CTRL_TX_TOTAL_DROP_EN_SHIFT      4

	#define CREG_FC_PAUSE_DROP_CTRL_TX_TXQ_DROP_EN_MASK         0x0008
	#define CREG_FC_PAUSE_DROP_CTRL_TX_TXQ_DROP_EN_SHIFT        3

	#define CREG_FC_PAUSE_DROP_CTRL_RX_BASED_CTRL_EN_MASK       0x0004
	#define CREG_FC_PAUSE_DROP_CTRL_RX_BASED_CTRL_EN_SHIFT      2

	#define CREG_FC_PAUSE_DROP_CTRL_TX_QUANTUM_CTRL_EN_MASK     0x0002
	#define CREG_FC_PAUSE_DROP_CTRL_TX_QUANTUM_CTRL_EN_SHIFT    1

	#define CREG_FC_PAUSE_DROP_CTRL_TX_BASED_CTRL_EN_MASK       0x0001
	#define CREG_FC_PAUSE_DROP_CTRL_TX_BASED_CTRL_EN_SHIFT      0

/****************************************************************************
  Page 0Bh: PAGE_FLOWCON_LAN, Flow Control Registers for LAN
****************************************************************************/

/****************************************************************************
  Page 0Dh: PAGE_FLOWCON_IMP0, Flow Control Registers for IMP0
****************************************************************************/

/****************************************************************************
  Page 0Ch: PAGE_FLOWCON_WAN_IMP1, Flow Control Registers for WAN/IMP1
****************************************************************************/

/****************************************************************************
  Page 10h-17h: PAGE_PORT_N_INT, Port Internal GPHY Registers
****************************************************************************/

/****************************************************************************
  Page 20h-28h: PAGE_MIB_PORT_N, Port MIB Registers
****************************************************************************/

#define CREG_TX_OCTETS                                          0x00
#define CREG_TX_DROP_PKTS                                       0x08
#define CREG_TX_Q0_PKT                                          0x0C
#define CREG_TX_BROADCAST_PKTS                                  0x10
#define CREG_TX_MULTICAST_PKTS                                  0x14
#define CREG_TX_UNICAST_PKTS                                    0x18
#define CREG_TX_COLLISIONS                                      0x1C
#define CREG_TX_SINGLE_COLLISION                                0x20
#define CREG_TX_MULTIPLE_COLLISION                              0x24
#define CREG_TX_DEFERRED_TRANSMIT                               0x28
#define CREG_TX_LATE_COLLISION                                  0x2C
#define CREG_TX_EXCESSIVE_COLLISION                             0x30
#define CREG_TX_FRAME_IN_DISC                                   0x34
#define CREG_TX_PAUSE_PKTS                                      0x38
#define CREG_TX_Q1_PKT                                          0x3C
#define CREG_TX_Q2_PKT                                          0x40
#define CREG_TX_Q3_PKT                                          0x44
#define CREG_TX_Q4_PKT                                          0x48
#define CREG_TX_Q5_PKT                                          0x4C
#define CREG_RX_OCTETS                                          0x50
#define CREG_RX_UNDERSIZE_PKTS                                  0x58
#define CREG_RX_PAUSE_PKTS                                      0x5C
#define CREG_RX_PKTS_64_OCTETS                                  0x60
#define CREG_RX_PKTS_65TO127_OCTETS                             0x64
#define CREG_RX_PKTS_128TO255_OCTETS                            0x68
#define CREG_RX_PKTS_256TO511_OCTETS                            0x6C
#define CREG_RX_PKTS_512TO1023_OCTETS                           0x70
#define CREG_RX_PKTS_1024TOMAX_OCTETS                           0x74
#define CREG_RX_OVERSIZE_PKTS                                   0x78
#define CREG_RX_JABBERS                                         0x7C
#define CREG_RX_ALIGNMENT_ERRORS                                0x80
#define CREG_RX_FCS_ERRORS                                      0x84
#define CREG_RX_GOOD_OCTETS                                     0x88
#define CREG_RX_DROP_PKTS                                       0x90
#define CREG_RX_UNICAST_PKTS                                    0x94
#define CREG_RX_MULTICAST_PKTS                                  0x98
#define CREG_RX_BROADCAST_PKTS                                  0x9C
#define CREG_RX_SA_CHANGES                                      0xA0
#define CREG_RX_FRAGMENTS                                       0xA4
#define CREG_RX_JUMBO_PKTS                                      0xA8
#define CREG_RX_SYMBOL_ERRORS                                   0xAC
#define CREG_RX_IN_RANGE_ERRORS                                 0xB0
#define CREG_RX_OUT_OF_RANGE_ERRORS                             0xB4
#define CREG_EEE_LPI_EVENT                                      0xB8
#define CREG_EEE_LPI_DURATION                                   0xBC
#define CREG_RX_DISCARD                                         0xC0
/* The offset of 0xC4 is skipped! */
#define CREG_TX_Q6_PKT                                          0xC8
#define CREG_TX_Q7_PKT                                          0xCC
#define CREG_TX_PKTS_64_OCTETS                                  0xD0
#define CREG_TX_PKTS_65TO127_OCTETS                             0xD4
#define CREG_TX_PKTS_128TO255_OCTETS                            0xD8
#define CREG_TX_PKTS_256TO511_OCTETS                            0xDC
#define CREG_TX_PKTS_512TO1023_OCTETS                           0xE0
#define CREG_TX_PKTS_1024TOMAX_OCTETS                           0xE4

/****************************************************************************
  Page 30h: PAGE_QOS, QoS Queue Monitor Control Registers
****************************************************************************/

#define CREG_QOS_GLOBAL_CTRL                                    0x00
	#define CREG_QOS_GLOBAL_CTRL_SIZE                           1

	#define CREG_QOS_GLOBAL_CTRL_P8_AGGREGATION_MODE_MASK       0x80
	#define CREG_QOS_GLOBAL_CTRL_P8_AGGREGATION_MODE_SHIFT      7

	#define CREG_QOS_GLOBAL_CTRL_P5_AGGREGATION_MODE_MASK       0x10
	#define CREG_QOS_GLOBAL_CTRL_P5_AGGREGATION_MODE_SHIFT      4

#define CREG_QOS_1P_EN                                          0x04
	#define CREG_QOS_1P_EN_SIZE                                 2

#define CREG_TC_SEL_TABLE_P0                                    0x50
#define CREG_TC_SEL_TABLE_P1                                    0x52
#define CREG_TC_SEL_TABLE_P2                                    0x54
#define CREG_TC_SEL_TABLE_P3                                    0x56
#define CREG_TC_SEL_TABLE_P4                                    0x58
#define CREG_TC_SEL_TABLE_P5                                    0x5A
#define CREG_TC_SEL_TABLE_P7                                    0x5E
#define CREG_TC_SEL_TABLE_IMP                                   0x60

#define CREG_TC_SEL_TABLE                                       CREG_TC_SEL_TABLE_P0
	#define CREG_TC_SEL_TABLE_SIZE                              2
	#define CREG_TC_SEL_TABLE_STEP                              2

	#define CREG_TC_SEL_TABLE_TC_SEL_7_MASK                     0xc000
	#define CREG_TC_SEL_TABLE_TC_SEL_7_SHIFT                    14

	#define CREG_TC_SEL_TABLE_TC_SEL_6_MASK                     0x3000
	#define CREG_TC_SEL_TABLE_TC_SEL_6_SHIFT                    12

	#define CREG_TC_SEL_TABLE_TC_SEL_5_MASK                     0x0c00
	#define CREG_TC_SEL_TABLE_TC_SEL_5_SHIFT                    10

	#define CREG_TC_SEL_TABLE_TC_SEL_4_MASK                     0x0300
	#define CREG_TC_SEL_TABLE_TC_SEL_4_SHIFT                    8

	#define CREG_TC_SEL_TABLE_TC_SEL_3_MASK                     0x00c0
	#define CREG_TC_SEL_TABLE_TC_SEL_3_SHIFT                    6

	#define CREG_TC_SEL_TABLE_TC_SEL_2_MASK                     0x0030
	#define CREG_TC_SEL_TABLE_TC_SEL_2_SHIFT                    4

	#define CREG_TC_SEL_TABLE_TC_SEL_1_MASK                     0x000c
	#define CREG_TC_SEL_TABLE_TC_SEL_1_SHIFT                    2

	#define CREG_TC_SEL_TABLE_TC_SEL_0_MASK                     0x0003
	#define CREG_TC_SEL_TABLE_TC_SEL_0_SHIFT                    0

#define CREG_TC2COS_MAP_P0                                      0x70
#define CREG_TC2COS_MAP_P1                                      0x74
#define CREG_TC2COS_MAP_P2                                      0x78
#define CREG_TC2COS_MAP_P3                                      0x7C
#define CREG_TC2COS_MAP_P4                                      0x80
#define CREG_TC2COS_MAP_P5                                      0x84
#define CREG_TC2COS_MAP_P7                                      0x8C
#define CREG_TC2COS_MAP_IMP                                     0x90

#define CREG_TC2COS_MAP                                         CREG_TC2COS_MAP_P0
	#define CREG_TC2COS_MAP_SIZE                                4
	#define CREG_TC2COS_MAP_STEP                                4

	#define CREG_TC2COS_MAP_BCAST_DLF_DROP_TC_MASK              0xff000000
	#define CREG_TC2COS_MAP_BCAST_DLF_DROP_TC_SHIFT             24

	#define CREG_TC2COS_MAP_PRT111_TO_QID_MASK                  0x00e00000
	#define CREG_TC2COS_MAP_PRT111_TO_QID_SHIFT                 21

	#define CREG_TC2COS_MAP_PRT110_TO_QID_MASK                  0x001c0000
	#define CREG_TC2COS_MAP_PRT110_TO_QID_SHIFT                 18

	#define CREG_TC2COS_MAP_PRT101_TO_QID_MASK                  0x00038000
	#define CREG_TC2COS_MAP_PRT101_TO_QID_SHIFT                 15

	#define CREG_TC2COS_MAP_PRT100_TO_QID_MASK                  0x00007000
	#define CREG_TC2COS_MAP_PRT100_TO_QID_SHIFT                 12

	#define CREG_TC2COS_MAP_PRT011_TO_QID_MASK                  0x00000e00
	#define CREG_TC2COS_MAP_PRT011_TO_QID_SHIFT                 9

	#define CREG_TC2COS_MAP_PRT010_TO_QID_MASK                  0x000001c0
	#define CREG_TC2COS_MAP_PRT010_TO_QID_SHIFT                 6

	#define CREG_TC2COS_MAP_PRT001_TO_QID_MASK                  0x00000038
	#define CREG_TC2COS_MAP_PRT001_TO_QID_SHIFT                 3

	#define CREG_TC2COS_MAP_PRT000_TO_QID_MASK                  0x00000007
	#define CREG_TC2COS_MAP_PRT000_TO_QID_SHIFT                 0

/****************************************************************************
  Page 31h: PAGE_VLAN, Port-Based VLAN Registers
****************************************************************************/

#define CREG_PORT_VLAN_CTL_P0                                   0x00
#define CREG_PORT_VLAN_CTL_P1                                   0x02
#define CREG_PORT_VLAN_CTL_P2                                   0x04
#define CREG_PORT_VLAN_CTL_P3                                   0x06
#define CREG_PORT_VLAN_CTL_P4                                   0x08
#define CREG_PORT_VLAN_CTL_P5                                   0x0A
#define CREG_PORT_VLAN_CTL_P7                                   0x0E
#define CREG_PORT_VLAN_CTL_IMP                                  0x10

#define CREG_VLAN_P0											0
#define CREG_VLAN_P1											1
#define CREG_VLAN_P2											2
#define CREG_VLAN_P3											3
#define CREG_VLAN_P4											4
#define CREG_VLAN_P5											5
#define CREG_VLAN_P7											7
#define CREG_VLAN_IMP											8

#define CREG_PORT_VLAN_CTL                                      CREG_PORT_VLAN_CTL_P0
	#define CREG_PORT_VLAN_CTL_SIZE                             2
	#define CREG_PORT_VLAN_CTL_STEP                             2

	#define CREG_PORT_VLAN_CTL_PORT_EGRESS_EN_MASK              0x01ff
	#define CREG_PORT_VLAN_CTL_PORT_EGRESS_EN_SHIFT             0

/****************************************************************************
  Page 32h: PAGE_TRUNK, MAC-Based Trunking Registers
****************************************************************************/

#define CREG_MAC_TRUNK_CTL                                      0x00
	#define CREG_MAC_TRUNK_CTL_SIZE                             1

	#define CREG_MAC_TRUNK_CTL_EN_TRUNK_LOCAL_MASK              0x08
	#define CREG_MAC_TRUNK_CTL_EN_TRUNK_LOCAL_SHIFT             3

	#define CREG_MAC_TRUNK_CTL_HASH_SEL_MASK                    0x03
	#define CREG_MAC_TRUNK_CTL_HASH_SEL_SHIFT                   0

#define CREG_IMP0_GRP_CTL                                       0x02
	#define CREG_IMP0_GRP_CTL_SIZE                              2
	#define CREG_IMP0_GRP_CTL_STEP                              2

#define CREG_TRUNK_GRP_CTL_P0                                   0x10
#define CREG_TRUNK_GRP_CTL_P1                                   0x12

#define CREG_TRUNK_GRP_CTL                                      CREG_TRUNK_GRP_CTL_P0
	#define CREG_TRUNK_GRP_CTL_SIZE                             2
	#define CREG_TRUNK_GRP_CTL_STEP                             2

	#define CREG_TRUNK_GRP_CTL_EN_TRUNK_GRP_MASK                0x01ff
	#define CREG_TRUNK_GRP_CTL_EN_TRUNK_GRP_SHIFT               0

/****************************************************************************
  Page 34h: PAGE_BCM8021Q, 802.1Q VLAN Registers
****************************************************************************/

#define CREG_VLAN_CTRL0                                         0x00
	#define CREG_VLAN_CTRL0_SIZE                                1

	#define CREG_VLAN_CTRL0_VLAN_EN_MASK                        0x80
	#define CREG_VLAN_CTRL0_VLAN_EN_SHIFT                       7

	#define CREG_VLAN_CTRL0_VLAN_LEARN_MODE_MASK                0x60
	#define CREG_VLAN_CTRL0_VLAN_LEARN_MODE_SHIFT               5

	#define CREG_VLAN_CTRL0_CHANGE_1Q_VID_MASK                  0x08
	#define CREG_VLAN_CTRL0_CHANGE_1Q_VID_SHIFT                 3

	#define CREG_VLAN_CTRL0_CHANGE_1P_VID_OUTER_MASK            0x02
	#define CREG_VLAN_CTRL0_CHANGE_1P_VID_OUTER_SHIFT           1

	#define CREG_VLAN_CTRL0_CHANGE_1P_VID_INNER_MASK            0x01
	#define CREG_VLAN_CTRL0_CHANGE_1P_VID_INNER_SHIFT           0

#define CREG_VLAN_CTRL1                                         0x01
	#define CREG_VLAN_CTRL1_SIZE                                1

	#define CREG_VLAN_CTRL1_EN_IPMC_BYPASS_UNTAG_MASK           0x40
	#define CREG_VLAN_CTRL1_EN_IPMC_BYPASS_UNTAG_SHIFT          6

	#define CREG_VLAN_CTRL1_EN_IPMC_BYPASS_FWDMAP_MASK          0x20
	#define CREG_VLAN_CTRL1_EN_IPMC_BYPASS_FWDMAP_SHIFT         5

	#define CREG_VLAN_CTRL1_EN_RSV_MCAST_UNTAG_MASK             0x08
	#define CREG_VLAN_CTRL1_EN_RSV_MCAST_UNTAG_SHIFT            3

	#define CREG_VLAN_CTRL1_EN_RSV_MCAST_FWDMAP_MASK            0x04
	#define CREG_VLAN_CTRL1_EN_RSV_MCAST_FWDMAP_SHIFT           2

#define CREG_VLAN_CTRL2                                         0x02
	#define CREG_VLAN_CTRL2_SIZE                                1

	#define CREG_VLAN_CTRL2_EN_GMRP_GVRP_UNTAG_MAP_MASK         0x40
	#define CREG_VLAN_CTRL2_EN_GMRP_GVRP_UNTAG_MAP_SHIFT        6

	#define CREG_VLAN_CTRL2_EN_GMRP_GVRP_V_FWDMAP_MASK          0x20
	#define CREG_VLAN_CTRL2_EN_GMRP_GVRP_V_FWDMAP_SHIFT         5

	#define CREG_VLAN_CTRL2_EN_MIIM_BYPASS_V_FWDMAP_MASK        0x04
	#define CREG_VLAN_CTRL2_EN_MIIM_BYPASS_V_FWDMAP_SHIFT       2

#define CREG_VLAN_CTRL3                                         0x03
	#define CREG_VLAN_CTRL3_SIZE                                2

	#define CREG_VLAN_CTRL3_EN_DROP_NON1Q_MASK                  0x01ff
	#define CREG_VLAN_CTRL3_EN_DROP_NON1Q_SHIFT                 0

#define CREG_VLAN_CTRL4                                         0x05
	#define CREG_VLAN_CTRL4_SIZE                                1

	#define CREG_VLAN_CTRL4_INGR_VID_CHK_MASK                   0xc0
	#define CREG_VLAN_CTRL4_INGR_VID_CHK_SHIFT                  6

	#define CREG_VLAN_CTRL4_EN_MGE_REV_GVRP_MASK                0x20
	#define CREG_VLAN_CTRL4_EN_MGE_REV_GVRP_SHIFT               5

	#define CREG_VLAN_CTRL4_EN_MGE_REV_GMRP_MASK                0x10
	#define CREG_VLAN_CTRL4_EN_MGE_REV_GMRP_SHIFT               4

	#define CREG_VLAN_CTRL4_EN_DOUBLE_TAG_MASK                  0x0c
	#define CREG_VLAN_CTRL4_EN_DOUBLE_TAG_SHIFT                 2

	#define CREG_VLAN_CTRL4_RESV_MCAST_FLOOD_MASK               0x02
	#define CREG_VLAN_CTRL4_RESV_MCAST_FLOOD_SHIFT              1

#define CREG_VLAN_CTRL5                                         0x06
	#define CREG_VLAN_CTRL5_SIZE                                1

	#define CREG_VLAN_CTRL5_PRESV_NON1Q_MASK                    0x40
	#define CREG_VLAN_CTRL5_PRESV_NON1Q_SHIFT                   6

	#define CREG_VLAN_CTRL5_EGRESS_DIR_FRM_BYPASS_TRUNK_EN_MASK  0x10
	#define CREG_VLAN_CTRL5_EGRESS_DIR_FRM_BYPASS_TRUNK_EN_SHIFT 4

	#define CREG_VLAN_CTRL5_DROP_VTABLE_MISS_MASK               0x08
	#define CREG_VLAN_CTRL5_DROP_VTABLE_MISS_SHIFT              3

	#define CREG_VLAN_CTRL5_EN_VID_FFF_FWD_MASK                 0x04
	#define CREG_VLAN_CTRL5_EN_VID_FFF_FWD_SHIFT                2

	#define CREG_VLAN_CTRL5_EN_CPU_RX_BYP_INNER_CRCCHK_MASK     0x01
	#define CREG_VLAN_CTRL5_EN_CPU_RX_BYP_INNER_CRCCHK_SHIFT    0

#define CREG_VLAN_CTRL6                                         0x07
	#define CREG_VLAN_CTRL6_SIZE                                1

	#define CREG_VLAN_CTRL6_DIS_ARL_BUST_LMT_MASK               0x10
	#define CREG_VLAN_CTRL6_DIS_ARL_BUST_LMT_SHIFT              4

	#define CREG_VLAN_CTRL6_STRICT_SFD_DETECT_MASK              0x01
	#define CREG_VLAN_CTRL6_STRICT_SFD_DETECT_SHIFT             0

#define CREG_VLAN_MULTI_PORT_ADDR_CTL                           0x0A
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_SIZE                  2

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT5_UTG_MAP_MASK    0x0800
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT5_UTG_MAP_SHIFT   11

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT5_V_FWD_MAP_MASK  0x0400
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT5_V_FWD_MAP_SHIFT 10

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT4_UTG_MAP_MASK    0x0200
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT4_UTG_MAP_SHIFT   9

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT4_V_FWD_MAP_MASK  0x0100
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT4_V_FWD_MAP_SHIFT 8

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT3_UTG_MAP_MASK    0x0080
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT3_UTG_MAP_SHIFT   7

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT3_V_FWD_MAP_MASK  0x0040
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT3_V_FWD_MAP_SHIFT 6

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT2_UTG_MAP_MASK    0x0020
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT2_UTG_MAP_SHIFT   5

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT2_V_FWD_MAP_MASK  0x0010
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT2_V_FWD_MAP_SHIFT 4

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT1_UTG_MAP_MASK    0x0008
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT1_UTG_MAP_SHIFT   3

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT1_V_FWD_MAP_MASK  0x0004
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT1_V_FWD_MAP_SHIFT 2

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_UTG_MAP_MASK    0x0002
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_UTG_MAP_SHIFT   1

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_V_FWD_MAP_MASK  0x0001
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_V_FWD_MAP_SHIFT 0

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT_UTG_MAP_MASK     CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_UTG_MAP_MASK
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT_UTG_MAP_SHIFT    CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_UTG_MAP_SHIFT
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT_UTG_MAP_BSTEP    2

	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT_V_FWD_MAP_MASK   CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_V_FWD_MAP_MASK
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT_V_FWD_MAP_SHIFT  CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT0_V_FWD_MAP_SHIFT
	#define CREG_VLAN_MULTI_PORT_ADDR_CTL_EN_MPORT_V_FWD_MAP_BSTEP  2

#define CREG_DEFAULT_1Q_TAG_P0                                  0x10
#define CREG_DEFAULT_1Q_TAG_P1                                  0x12
#define CREG_DEFAULT_1Q_TAG_P2                                  0x14
#define CREG_DEFAULT_1Q_TAG_P3                                  0x16
#define CREG_DEFAULT_1Q_TAG_P4                                  0x18
#define CREG_DEFAULT_1Q_TAG_P5                                  0x1A
#define CREG_DEFAULT_1Q_TAG_P7                                  0x1E
#define CREG_DEFAULT_1Q_TAG_IMP                                 0x20

#define CREG_DEFAULT_1Q_TAG                                     CREG_DEFAULT_1Q_TAG_P0
	#define CREG_DEFAULT_1Q_TAG_SIZE                            2
	#define CREG_DEFAULT_1Q_TAG_STEP                            2

	#define CREG_DEFAULT_1Q_TAG_PRI_MASK                        0xe000
	#define CREG_DEFAULT_1Q_TAG_PRI_SHIFT                       13

	#define CREG_DEFAULT_1Q_TAG_CFI_MASK                        0x1000
	#define CREG_DEFAULT_1Q_TAG_CFI_SHIFT                       12

	#define CREG_DEFAULT_1Q_TAG_VID_MASK                        0x0fff
	#define CREG_DEFAULT_1Q_TAG_VID_SHIFT                       0

/****************************************************************************
  Page 36h: PAGE_DOS, DoS Attack Prevent Registers
****************************************************************************/

/****************************************************************************
  Page 40h: PAGE_JUMBO_CTRL, Jumbo Frame Control Registers
****************************************************************************/
#define CREG_MIB_GD_FM_MAX_SIZE 0x5
#define CREG_MIB_GD_FM_MAX_SIZE_SIZE 2

/****************************************************************************
  Page 41h: PAGE_BC_SUPPRESS, Broadcast Storm Suppression Registers
****************************************************************************/

/****************************************************************************
  Page 42h: PAGE_IEEE8021X, EAP Registers
****************************************************************************/

/****************************************************************************
  Page 43h: PAGE_IEEE8021S, MSPT Registers
****************************************************************************/

/****************************************************************************
  Page 45h: PAGE_MAC_LIMIT, MAC Limit Registers
****************************************************************************/

/****************************************************************************
  Page 46h: PAGE_SCHEDULER, Scheduler Registers
****************************************************************************/

/****************************************************************************
  Page 47h: PAGE_EGRESS_SHAPER_CTRREG, Egress Shaper Control Registers
****************************************************************************/

/****************************************************************************
  Page 48-4Fh: PAGE_EGRESS_SHAPER_QN_CONFIG, Egress Shaper QN Cfg Registers
****************************************************************************/

/****************************************************************************
  Page 70h: PAGE_MIB_SNAPSHOT, MIB Snapshot Control Registers
****************************************************************************/

#define CREG_MIB_SNAPSHOT_CTL                                   0x00
	#define CREG_MIB_SNAPSHOT_CTL_SIZE                          1

	#define CREG_MIB_SNAPSHOT_CTL_SNAPSHOT_STDONE_MASK          0x80
	#define CREG_MIB_SNAPSHOT_CTL_SNAPSHOT_STDONE_SHIFT         7

	#define CREG_MIB_SNAPSHOT_CTL_SNAPSHOT_MIRROR_MASK          0x40
	#define CREG_MIB_SNAPSHOT_CTL_SNAPSHOT_MIRROR_SHIFT         6

	#define CREG_MIB_SNAPSHOT_CTL_RST_MIB_SNAPSHOT_CNT_EN_MASK  0x10
	#define CREG_MIB_SNAPSHOT_CTL_RST_MIB_SNAPSHOT_CNT_EN_SHIFT 4

	#define CREG_MIB_SNAPSHOT_CTL_SNAPSHOT_PORT_MASK            0x0F
	#define CREG_MIB_SNAPSHOT_CTL_SNAPSHOT_PORT_SHIFT           0

/****************************************************************************
  Page 71h: PAGE_MIB_SNAPSHOT_PORT, Port Snapshot MIB Registers
****************************************************************************/

/****************************************************************************
  Page 85h: PAGE_PORT5_EXT, Port 5 PHY MII Registers
****************************************************************************/

/****************************************************************************
  Page 88h: PAGE_MII_PORT_EXT, Port 8 PHY MII Registers
****************************************************************************/

/****************************************************************************
  Page 90h: PAGE_AVB, AVB Registers
****************************************************************************/

/****************************************************************************
  Page 91h: PAGE_TRREG, Traffic Remarking Registers
****************************************************************************/

/****************************************************************************
  Page 92h: PAGE_EEE_CTL, EEE Control Registers
****************************************************************************/

#define CREG_EEE_EN_CTRL                                        0x00
	#define CREG_EEE_EN_CTRL_SIZE                               2

#define CREG_EEE_LPI_ASSERT                                     0x02
	#define CREG_EEE_LPI_ASSERT_SIZE                            2

#define CREG_EEE_LPI_INDICATE                                   0x04
	#define CREG_EEE_LPI_INDICATE_SIZE                          2

#define CREG_EEE_SLEEP_TIMER_G_P0                               0x10
#define CREG_EEE_SLEEP_TIMER_G_P1                               0x14
#define CREG_EEE_SLEEP_TIMER_G_P2                               0x18
#define CREG_EEE_SLEEP_TIMER_G_P3                               0x1C
#define CREG_EEE_SLEEP_TIMER_G_P4                               0x20
#define CREG_EEE_SLEEP_TIMER_G_P5                               0x24
#define CREG_EEE_SLEEP_TIMER_G_P7                               0x2C
#define CREG_EEE_SLEEP_TIMER_G_IMP                              0x30

#define CREG_EEE_SLEEP_TIMER_G                                  CREG_EEE_SLEEP_TIMER_G_P0
	#define CREG_EEE_SLEEP_TIMER_G_SIZE                         4
	#define CREG_EEE_SLEEP_TIMER_G_STEP                         4
	#define CREG_EEE_SLEEP_TIMER_G_DFLT                         0x00000190

#define CREG_EEE_SLEEP_TIMER_H_P0                               0x34
#define CREG_EEE_SLEEP_TIMER_H_P1                               0x38
#define CREG_EEE_SLEEP_TIMER_H_P2                               0x3C
#define CREG_EEE_SLEEP_TIMER_H_P3                               0x40
#define CREG_EEE_SLEEP_TIMER_H_P4                               0x44
#define CREG_EEE_SLEEP_TIMER_H_P5                               0x48
#define CREG_EEE_SLEEP_TIMER_H_P7                               0x50
#define CREG_EEE_SLEEP_TIMER_H_IMP                              0x54

#define CREG_EEE_SLEEP_TIMER_H                                  CREG_EEE_SLEEP_TIMER_H_P0
	#define CREG_EEE_SLEEP_TIMER_H_SIZE                         4
	#define CREG_EEE_SLEEP_TIMER_H_STEP                         4
	#define CREG_EEE_SLEEP_TIMER_H_DFLT                         0x00000FA0

#define CREG_EEE_MIN_LP_TIMER_G_P0                              0x58
#define CREG_EEE_MIN_LP_TIMER_G_P1                              0x5C
#define CREG_EEE_MIN_LP_TIMER_G_P2                              0x60
#define CREG_EEE_MIN_LP_TIMER_G_P3                              0x64
#define CREG_EEE_MIN_LP_TIMER_G_P4                              0x68
#define CREG_EEE_MIN_LP_TIMER_G_P5                              0x6C
#define CREG_EEE_MIN_LP_TIMER_G_P7                              0x74
#define CREG_EEE_MIN_LP_TIMER_G_IMP                             0x78

#define CREG_EEE_MIN_LP_TIMER_G                                 CREG_EEE_MIN_LP_TIMER_G_P0
	#define CREG_EEE_MIN_LP_TIMER_G_SIZE                        4
	#define CREG_EEE_MIN_LP_TIMER_G_STEP                        4
	#define CREG_EEE_MIN_LP_TIMER_G_DFLT                        0x00000032

#define CREG_EEE_MIN_LP_TIMER_H_P0                              0x7C
#define CREG_EEE_MIN_LP_TIMER_H_P1                              0x80
#define CREG_EEE_MIN_LP_TIMER_H_P2                              0x84
#define CREG_EEE_MIN_LP_TIMER_H_P3                              0x88
#define CREG_EEE_MIN_LP_TIMER_H_P4                              0x8C
#define CREG_EEE_MIN_LP_TIMER_H_P5                              0x90
#define CREG_EEE_MIN_LP_TIMER_H_P7                              0x98
#define CREG_EEE_MIN_LP_TIMER_H_IMP                             0x9C

#define CREG_EEE_MIN_LP_TIMER_H                                 CREG_EEE_MIN_LP_TIMER_H_P0
	#define CREG_EEE_MIN_LP_TIMER_H_SIZE                        4
	#define CREG_EEE_MIN_LP_TIMER_H_STEP                        4
	#define CREG_EEE_MIN_LP_TIMER_H_DFLT                        0x000001F4

#define CREG_EEE_WAKE_TIMER_G_P0                                0xA0
#define CREG_EEE_WAKE_TIMER_G_P1                                0xA2
#define CREG_EEE_WAKE_TIMER_G_P2                                0xA4
#define CREG_EEE_WAKE_TIMER_G_P3                                0xA6
#define CREG_EEE_WAKE_TIMER_G_P4                                0xA8
#define CREG_EEE_WAKE_TIMER_G_P5                                0xAA
#define CREG_EEE_WAKE_TIMER_G_P7                                0xAE
#define CREG_EEE_WAKE_TIMER_G_IMP                               0xB0

#define CREG_EEE_WAKE_TIMER_G                                   CREG_EEE_WAKE_TIMER_G_P0
	#define CREG_EEE_WAKE_TIMER_G_SIZE                          2
	#define CREG_EEE_WAKE_TIMER_G_STEP                          2
	#define CREG_EEE_WAKE_TIMER_G_DFLT                          0x0011

#define CREG_EEE_WAKE_TIMER_H_P0                                0xB2
#define CREG_EEE_WAKE_TIMER_H_P1                                0xB4
#define CREG_EEE_WAKE_TIMER_H_P2                                0xB6
#define CREG_EEE_WAKE_TIMER_H_P3                                0xB8
#define CREG_EEE_WAKE_TIMER_H_P4                                0xBA
#define CREG_EEE_WAKE_TIMER_H_P5                                0xBC
#define CREG_EEE_WAKE_TIMER_H_P7                                0xC0
#define CREG_EEE_WAKE_TIMER_H_IMP                               0xC2

#define CREG_EEE_WAKE_TIMER_H                                   CREG_EEE_WAKE_TIMER_H_P0
	#define CREG_EEE_WAKE_TIMER_H_SIZE                          2
	#define CREG_EEE_WAKE_TIMER_H_STEP                          2
	#define CREG_EEE_WAKE_TIMER_H_DFLT                          0x0024

/****************************************************************************
  Page 93h: PAGE_IEEE_1588v2_PAGE0, IEEE 1588v2 Page 0 Registers
****************************************************************************/

/****************************************************************************
  Page 94h: PAGE_IEEE_1588v2_PAGE1, IEEE 1588v2 Page 1 Registers
****************************************************************************/

/****************************************************************************
  Page 95h: PAGE_WRED, Weighted Random Early Drop Registers
****************************************************************************/

/****************************************************************************
  Page A0h: PAGE_CFP, CFP TCAM Registers
****************************************************************************/

/****************************************************************************
  Page A1h: PAGE_CFP_CTL, CFG Configuration Registers
****************************************************************************/

#ifdef __KERNEL__
/* ethsw core control block */
struct ethsw_core {
	/* core register access lock */
	spinlock_t creg_lock;

	/* MIB snapshot lock */
	spinlock_t mib_snapshot_lock;

	/* core states/status */
	bool managed;
	bool cert;
	bool ethwan;
	int  ethwan_port;
    bool altwan_enble;
    int  altwan_impport;
    int  altwan_lanport;
};
#endif

#endif /* _ETHSW_CORE_H_ */
