 /****************************************************************************
  *
  * Broadcom Proprietary and Confidential. (c) 2016 Broadcom.
  * All rights reserved.
  * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
  *
  * Unless you and Broadcom execute a separate written software license
  * agreement governing use of this software, this software is licensed to
  * you under the terms of the GNU General Public License version 2 (the
  * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
  * the following added to such license:
  *
  * As a special exception, the copyright holders of this software give you
  * permission to link this software with independent modules, and to copy
  * and distribute the resulting executable under terms of your choice,
  * provided that you also meet, for each linked independent module, the
  * terms and conditions of the license of that module. An independent
  * module is a module which is not derived from this software. The special
  * exception does not apply to any modifications of the software.
  *
  * Notwithstanding the above, under no circumstances may you combine this
  * software in any way with any other Broadcom software provided under a
  * license other than the GPL, without Broadcom's express prior written
  * consent.
  *
  ****************************************************************************/
#include <linux/types.h>
#include <linux/ipv6.h>
#include <linux/in6.h>
#include <linux/netfilter.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <linux/icmp.h>
#include <linux/sysctl.h>
#include <net/ipv6.h>
#include <net/inet_frag.h>
#include <linux/version.h>

#include <linux/netfilter_ipv6.h>
#include <linux/netfilter_bridge.h>
#if IS_ENABLED(CONFIG_NF_CONNTRACK)
#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <net/netfilter/nf_conntrack_l4proto.h>
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/ipv6/nf_conntrack_ipv6.h>
#endif
#include <net/netfilter/nf_conntrack_zones.h>
#include <net/netfilter/ipv6/nf_defrag_ipv6.h>

#if LINUX_VERSION_CODE > KERNEL_VERSION(3, 17, 0)
static unsigned int ipv6_defrag_notrack(void *priv,
				struct sk_buff *skb,
				const struct nf_hook_state *state)
#else
static unsigned int ipv6_defrag_notrack(const struct nf_hook_ops *ops,
				const struct net_device *in,
				const struct net_device *out,
				int (*okfn)(struct sk_buff *))
#endif
{
	u8 nexthdr = ipv6_hdr(skb)->nexthdr;

#if IS_ENABLED(CONFIG_NF_CONNTRACK)
	/* Previously seen (loopback)?	*/
	if (skb_nfct(skb) && !nf_ct_is_template((struct nf_conn *)skb_nfct(skb)))
		return NF_ACCEPT;
#endif

	if (nexthdr != NEXTHDR_FRAGMENT)
	{
		return NF_ACCEPT;
	}
	else
	{
		return NF_STOP;
	}

	return NF_STOLEN;
}

static struct nf_hook_ops ipv6_defrag_notrack_ops[] = {
	{
		.hook		= ipv6_defrag_notrack,
		.pf		= NFPROTO_IPV6,
		.hooknum	= NF_INET_PRE_ROUTING,
		.priority	= (NF_IP6_PRI_CONNTRACK_DEFRAG - 100),
	},
};

static int __init nf_defrag_notrack_init(void)
{
	int ret = 0;

	ret = nf_register_net_hooks(&init_net, ipv6_defrag_notrack_ops,
				    ARRAY_SIZE(ipv6_defrag_notrack_ops));
	if (ret < 0) {
		pr_err("nf_defrag_ipv6_notrack: can't register hooks\n");
		goto cleanup_frag6;
	}
	pr_info("nf_defrag_ipv6_notrack Init\n");
	return ret;

cleanup_frag6:

	return ret;

}

static void __exit nf_defrag_notrack_fini(void)
{
	nf_unregister_net_hooks(&init_net, ipv6_defrag_notrack_ops,
				ARRAY_SIZE(ipv6_defrag_notrack_ops));
	pr_info("nf_defrag_ipv6_notrack Exit\n");
}



module_init(nf_defrag_notrack_init);
module_exit(nf_defrag_notrack_fini);

MODULE_LICENSE("GPL");
