/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2018 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tim.ross@broadcom.com>
 * Author: Venky Selvaraj <venky.selvaraj@broadcom.com>
 *****************************************************************************/
#ifndef _VFBIO_H_
#define _VFBIO_H_

#include <linux/hdreg.h>
#include <linux/blkdev.h>
#include <linux/blk-mq.h>
#include <linux/platform_device.h>
#include <linux/bcm_media_gw/itc_rpc/itc_rpc.h>
#include <vfbio_rpc.h>
#include <linux/bcm_media_gw/vfbio/vfbio.h>

#define MODULE_NAME	"brcm-vfbio"
#define ANSI_BLACK	"\e[30;1m"
#define ANSI_RED	"\e[31;1m"
#define ANSI_GREEN	"\e[32;1m"
#define ANSI_YELLOW	"\e[33;1m"
#define ANSI_BLUE	"\e[34;1m"
#define ANSI_MAGENTA	"\e[35;1m"
#define ANSI_CYAN	"\e[36;1m"
#define ANSI_WHITE	"\e[37;1m"
#define ANSI_RESET	"\e[0m"
#define BLK(str)	ANSI_BLK str ANSI_RESET
#define RED(str)	ANSI_RED str ANSI_RESET
#define GRN(str)	ANSI_GREEN str ANSI_RESET
#define YLW(str)	ANSI_YELLOW str ANSI_RESET
#define BLU(str)	ANSI_BLUE str ANSI_RESET
#define MAG(str)	ANSI_MAGENTA str ANSI_RESET
#define CYN(str)	ANSI_CYAN str ANSI_RESET
#define WHT(str)	ANSI_WHITE str ANSI_RESET

struct vfbio_device {
	struct list_head	list;
	int			tunnel;
	char			*name;
	u32			blk_sz;
	u32			blk_sz_shift;
	u32			n_blks;
	u8			lun;

	struct gendisk		*disk;
	struct hd_geometry	geo;

	struct blk_mq_tag_set	tset;

	struct request_queue	*q;

	atomic_t		pending_ops;
	bool			waiting_on_sync;

	struct platform_device	*pdev;
};

extern struct list_head vfdevs_list;
#endif
