 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential. (c) 2019 Broadcom.  All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/
#ifndef __FLOWMGR_IOCTL_H
#define __FLOWMGR_IOCTL_H

#include <linux/ioctl.h>
#include <linux/netfilter.h>

struct flow_tuple {
	u8  l3_prot;
	u8  ip_prot;
	union nf_inet_addr src_ip;
	union nf_inet_addr dst_ip;
	__be16 src_port;
	__be16 dst_port;
};

struct flow_tunnel_config {
	u32 ifindex;
	union nf_inet_addr remote_ip;
	u16 vlan_tag;
};

struct flow_config {
	struct flow_tuple tuple;

	/* flow_ipv4_type/flow_ipv6_type enum */
	u8 flow_type;

	/* Replace Fields */
	__be32 replacement_ip; /* not required for ipv6 */
	__be16 replacement_port; /* not required for ipv6 */
	__u8  replacement_mac_src[6];
	__u8  replacement_mac_dst[6];

	/* Rx/Tx params */
	u32 rx_ifindex;
	u32 tx_ifindex;
	u8 tx_dscp;

	struct flow_tunnel_config tunnel;
};

#define FLOWMGR_IOC_CODE 'F'

#define FLOWMGR_IOCTL_FLOW_ADD		_IOW(FLOWMGR_IOC_CODE, 0, struct flow_config)
#define FLOWMGR_IOCTL_FLOW_DEL		_IOW(FLOWMGR_IOC_CODE,	1, int)
#define FLOWMGR_IOCTL_FLOW_PROMOTE	_IOW(FLOWMGR_IOC_CODE, 2, struct flow_tuple)
#define FLOWMGR_IOCTL_FLOW_DEMOTE	_IOW(FLOWMGR_IOC_CODE, 3, struct flow_tuple)

#endif
