/****************************************************************************
 *
 * Copyright (c) 2010-2012 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or
 * its licensors, and may only be used, duplicated, modified or distributed
 * pursuant to the terms and conditions of a separate, written license
 * agreement executed between you and Broadcom (an "Authorized License").
 * Except as set forth in an Authorized License, Broadcom grants no license
 * (express or implied), right to use, or waiver of any kind with respect to
 * the Software, and Broadcom expressly reserves all rights in and to the
 * Software and all intellectual property rights therein.  IF YOU HAVE NO
 * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
 * AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
 * SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization,
 * constitutes the valuable trade secrets of Broadcom, and you shall use all
 * reasonable efforts to protect the confidentiality thereof, and to use this
 * information only in connection with your use of Broadcom integrated circuit
 * products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
 * "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
 * OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
 * RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
 * IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
 * A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
 * ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
 * THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
 * OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
 * INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
 * RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
 * EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
 * WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
 * FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
 *
 *******************************************************************************
 *
 * itc_msg_defs.h
 * Oct. 23 2012
 * Peter Sulc
 *
 *******************************************************************************/
#ifndef _ITC_MSG_DEFS_H_
#define _ITC_MSG_DEFS_H_

typedef struct {
	uint32_t header;
	uint32_t data[3];
} rpc_msg;
typedef struct {
	int	tunnel;
	rpc_msg	msg;
	int	timeout; /* seconds */
} rpc_msg_user;

#define RPC_MAX_FUNCTIONS	256

/*
 * Message header encoding in first 32bit word
 * |   6   |   1   |   1   |   8   |   8    |   8   |
 *  Version Request  Reply  Service Function Counter
 */

static inline uint8_t rpc_msg_version(rpc_msg *msg)
{
	return ((msg->header >> 26) & 0x3f);
}
static inline uint8_t rpc_msg_request(rpc_msg *msg)
{
	return ((msg->header >> 25) & 0x01);
}
static inline uint8_t rpc_msg_reply(rpc_msg *msg)
{
	return ((msg->header >> 24) & 0x01);
}
static inline uint8_t rpc_msg_service(rpc_msg *msg)
{
	return ((msg->header >> 16) & 0xff);
}
static inline uint8_t rpc_msg_function(rpc_msg *msg)
{
	return ((msg->header >>  8) & 0xff);
}
static inline uint8_t rpc_msg_counter(rpc_msg *msg)
{
	return ((msg->header >>  0) & 0xff);
}

/* xid = all except request and reply bits */
static inline uint32_t rpc_msg_xid(rpc_msg *msg)
{
	return (msg->header & ~(0xff << 24));
}

static inline void rpc_msg_set_version(rpc_msg *msg, uint8_t v)
{
	(msg->header = (msg->header & ~(0x3f << 26)) | (v << 26));
}
static inline void rpc_msg_set_request(rpc_msg *msg, uint8_t v)
{
	(msg->header = (msg->header & ~(0x01 << 25)) | (v << 25));
}
static inline void rpc_msg_set_reply(rpc_msg *msg, uint8_t v)
{
	(msg->header = (msg->header & ~(0x01 << 24)) | (v << 24));
}
static inline void rpc_msg_set_service(rpc_msg *msg, uint8_t v)
{
	(msg->header = (msg->header & ~(0xff << 16)) | (v << 16));
}
static inline void rpc_msg_set_function(rpc_msg *msg, uint8_t v)
{
	(msg->header = (msg->header & ~(0xff <<  8)) | (v <<  8));
}
static inline void rpc_msg_set_counter(rpc_msg *msg, uint8_t v)
{
	(msg->header = (msg->header & ~(0xff <<  0)) | (v <<  0));
}

#define RPC_MSG_MAKE_HEADER(version, req, rep, serv, func, reqcnt)( \
		(version << 26) |	\
		(req << 25) |	\
		(rep << 24) |	\
		(serv << 16) |	\
		(func << 8) |	\
		(reqcnt) )

#define RPC_MSG_INIT_CODE0		0xbeef0000
#define RPC_MSG_INIT_CODE1		0xbeef0001
#define RPC_MSG_INIT_CODE2		0xbeef0002

#endif
