/****************************************************************************
*
* Broadcom Proprietary and Confidential. (c) 2022 Broadcom.  All rights reserved.
* The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
*
* This program is the proprietary software of Broadcom and/or
* its licensors, and may only be used, duplicated, modified or distributed
* pursuant to the terms and conditions of a separate, written license
* agreement executed between you and Broadcom (an "Authorized License").
* Except as set forth in an Authorized License, Broadcom grants no license
* (express or implied), right to use, or waiver of any kind with respect to
* the Software, and Broadcom expressly reserves all rights in and to the
* Software and all intellectual property rights therein. IF YOU HAVE NO
* AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
* AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
* SOFTWARE.
*
* Except as expressly set forth in the Authorized License,
*
* 1. This program, including its structure, sequence and organization,
* constitutes the valuable trade secrets of Broadcom, and you shall use all
* reasonable efforts to protect the confidentiality thereof, and to use this
* information only in connection with your use of Broadcom integrated circuit
* products.
*
* 2. TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
* "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
* OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
* RESPECT TO THE SOFTWARE. BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
* IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
* A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
* ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
* THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
*
* 3. TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
* OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
* INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
* RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
* HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
* EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
* WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
* FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
*
* Author: Jayesh Patel <jayesh.patel@broadcom.com>
*
*/

#ifndef __MSO_FEAT__
#define __MSO_FEAT__

/* MSO Feature ID */
enum mso_feat_id {
	mf_invalid,
	mf_mapt,
	mf_ethiso,
	mf_bspeed2_0,
	mf_dslite,
	mf_langre,
	mf_wangredscp,
	mf_max,
};

/* MSO Feature Operation for mapt */
struct mso_feat_mapt_ops {
	int (*ops0)(void);
	int (*ops1)(void *, int, void *, int);
	int (*ops2)(void *, void *, int, int, void *,
		    const char **, int *, int *, int *);
};

/* MSO Feature Operation for ethsw port isolation */
struct mso_feat_ethiso_ops {
	int (*ops0)(void);
	int (*ops1)(void);
	int (*ops2)(void);
	int (*ops3)(int, int, unsigned int, void *);
	int (*ops4)(int, int, unsigned int, void *);
};

/* MSO Feature Operation for bspeed 2.0 mode */
struct mso_feat_bspeed2_0_ops {
	int (*ops0)(void);
};

/* MSO Feature Operation for dslite */
struct mso_feat_dslite_ops {
	int (*ops0)(void);
	int (*ops1)(void *, void *);
	int (*ops2)(void *, void *);
	int (*ops3)(void *, int, void *, int, int);
};

/* MSO Feature Operation for gre */
struct mso_feat_gre_ops {
	int (*ops0)(int);
	int (*ops1)(void *, int, void *, int, int);
};

/* MSO Feature Context */
struct mso_feat {
	enum mso_feat_id id;
	const char *name;
	int enable;
	union {
		const struct mso_feat_mapt_ops *mapt;
		const struct mso_feat_ethiso_ops *ethiso;
		const struct mso_feat_bspeed2_0_ops *bspeed2_0;
		const struct mso_feat_dslite_ops *dslite;
		const struct mso_feat_gre_ops *gre;
	};
};

/* MSO Feature Call Forward Context */
struct mso_feat_cf {
	const char *var0;
	const int  *var1;
	const char *var2;
	const char *var3;
	const void *var4;
	void (*ops0)(void);
	struct mso_feat *(*ops1)(enum mso_feat_id);
};

/* MSO Feature Call Back Context */
struct mso_feat_cb {
	unsigned int *var0;
	void (*ops0)(const struct mso_feat_cf *);
	int (*ops1)(void *, void *, int);
	ssize_t (*ops2)(void *, char *, size_t, loff_t *);
	ssize_t (*ops3)(char *, const char *, size_t);
};

typedef struct mso_feat *(*get_mso_feat_fptr)(enum mso_feat_id id);

#define get_mso_feat_symbol() __symbol_get("get_mso_feat")
#define put_mso_feat_symbol() __symbol_put("get_mso_feat")

#endif
