 /****************************************************************************
 *
 * Copyright (c) Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/
#ifndef __BCMFLOW_H
#define __BCMFLOW_H

struct flow_net_config {
	__be32 local_network;
	__be32 local_network_mask;
	u8  wan_mac_address[6];
	u8  lan_mac_address[6];
};

enum flow_type {
	ft_none		= 0,
	ft_ipv4		= 1,  /* Ipv4 Flow      */
	ft_ipv6		= 2,  /* Ipv6 Flow      */
	ft_mac_bridge	= 3,  /* Bridging Flow  */
	ft_multicast	= 4,  /* Multicast Flow */
	ft_ignore = 5,
	ft_max
};

enum flow_dir {
	flow_lanlan	= 0,  /* Lan to Lan           */
	flow_wanlan	= 1,  /* Downstream Direction */
	flow_lanwan	= 2,  /* Upstream direction   */
	flow_expected   = 3,  /* Expected flow to host*/
};

struct flow_rx_control {
	u8  vlan_untag;
};

struct flow_tx_control {
	u16 vlan_tci;  /* VLAN TCI */
	u8  vlan_idx;  /* VLAN Rule Index */
	u8  priority;  /* 3-bit field specifying the tx frames Priority */
	u8  dscp_mark; /* Overide the tx frame dscp with the value specified
			  in dscp_val */
	u8  dscp_val;  /* DSCP marking value */
	u8  lag;       /* LAG port */
};

struct flow_tx_params {
	u32 interface;
	u32 subif;
	struct flow_tx_control control;
};

struct flow_rx_params {
	u32 interface;
	u32 subif;
	struct flow_rx_control control;
};

struct flow_vlan_control {
	__be16  tpid;
	u8      tag;        /* If Set: Include tag based on parameter specfied
			       in vlan params */
	u8      use_tx_pri; /* If Set: Use 3-bit PCP for Tx priority */
	u8      untag;      /* If Set: Untag before final Tx */
	u8      is_tagged;  /* If Set: Check VID against Rx frame. */
			    /* If not matched Exception to Host CPU  */
	__be16  vid;        /* VID of Ingress Frame */
};

struct flow_vlan_params {
	u8      pcp;  /* 3 bit PCP */
	u8      dei;  /* 1 bit dei */
	__be16  vid;  /* 12bit VLAN Id */
};

struct flow_vlan_rule_params {
	struct flow_vlan_control s_control; /* Service TAG Control */
	struct flow_vlan_control c_control; /* Customer TAG Control */
	struct flow_vlan_params  s_params;
	struct flow_vlan_params  c_params;
};

struct flow_dslite_tunnel_params {
	__be16 tunnel_id; /* keep word alighment */
	__u8  remote_mac[6];
	__u8  local_mac[6];
	__be32 remote_ip[4];
	__be32 local_ip[4];
};

struct flow_gre_tunnel_params {
	__be16 tunnel_id; /* keep word alighment */
	__be16 type;
	__u8  remote_mac[6];
	__u8  local_mac[6];
	__be32 remote_ip[4];
	__be32 local_ip[4];
	__u8  tos;
	__u8  ttl;
	__be16 id;
	__be16 frag_off;
	__be16 check;
	__be16 tot_len;
	__be16 encap_mtu;
	__be16 vlan_tag;
	__be32 mpls_hdr;
};

struct flow_wifi_params {
	u32 flowring;
	u8  pri;
	u8  skb_pri;
};

enum flow_ipv4_type {
	ft_ipv4_discard      = 0,  /* Discard packets that match this flow */
	ft_ipv4_bridge       = 1,  /* Ipv4 Bridged Flow */
	ft_ipv4_nat_dst      = 2,  /* Nat Mod Dst (Wan->Lan) */
	ft_ipv4_nat_src      = 3,  /* Nat Mod Src (Lan->Wan) */
	ft_ipv4_dslite_decap = 4,  /* Ds-Lite Decapsulate Ipv6 Header */
	ft_ipv4_dslite_encap = 5,  /* Ds-Lite Encapsulate with Ipv6 Header */
	ft_ipv4_gre_decap    = 6,  /* GRE Decapsulate Ipv4 Header no NAT */
	ft_ipv4_gre_encap    = 7,  /* GRE Encapsulate with Ipv4 Header no NAT */
	ft_ipv4_routed_src   = 8,  /* IPv4 Routed Wan->Lan */
	ft_ipv4_routed_dst   = 9,  /* IPv4 Routed Lan->WAN */
	ft_ipv4_bridge_ds    = 10, /* Ipv4 Downstream Bridged Flow */
	ft_ipv4_expected     = 11, /* Ipv4 Expected Flow */
	ft_ipv4_mapt_map     = 12, /* Ipv4 MAP-T MAP to IPv6 */
	ft_ipv4_gre_decap_nat_dst = 13,  /* GRE Decapsulate Ipv4 Header WANGRE->LAN */
	ft_ipv4_gre_encap_nat_src = 14,  /* GRE Encapsulate with Ipv4 Header LAN->WANGRE */
	ft_ipv4_gre_decap_nat_src = 15,  /* GRE Decapsulate Ipv4 Header LANGRE->WAN */
	ft_ipv4_gre_encap_nat_dst = 16,  /* GRE Encapsulate with Ipv4 Header WAN->LANGRE*/
	ft_ipv4_gre2dslite = 17,   /* GRE Decap -> DS-Lite Encap */
	ft_ipv4_dslite2gre = 18,   /* DS-Lite Decap -> GRE Encap */
	ft_ipv4_mapt_gre2map = 19, /* GRE Decap -> Ipv4 MAP-T MAP to IPv6 */
};

struct flow_mapt_ipv4_params {
	__be16 domain_index;
	// needs the mapped IPv6 addresses for TCP/UDP HCS fixup
	__be32 ipv6_src_ip[4];
	__be32 ipv6_dst_ip[4];
};

struct flow_ipv4_params {
	enum flow_ipv4_type type;

	/* Match Fields */
	u8  ip_prot;
	__be32 src_ip;
	__be32 dst_ip;
	__be16 src_port;
	__be16 dst_port;

	/* Replace Fields */
	__be32 replacement_ip;
	__be16 replacement_port;
	__u8  replacement_mac_src[6];
	__u8  replacement_mac_dst[6];

	// MAP-T support
	struct flow_mapt_ipv4_params mapt;
};

enum flow_ipv6_type {
	ft_ipv6_discard      = 0,  /* Discard packets that match this flow */
	ft_ipv6_bridge       = 1,  /* Ipv6 Bridged Flow */
	ft_ipv6_routed       = 2,  /* Ipv6 Routed Flow */
	ft_ipv6_bridge_ds    = 3,  /* Ipv6 Downstream Bridged Flow */
	ft_ipv6_expected     = 4,  /* Ipv6 Expected Flow */
	ft_ipv6_mapt_unmap   = 5,  /* Ipv6 MAP-T unmap to IPv4 */
	ft_ipv6_gre_decap    = 6,  /* GRE Decapsulate Ipv6 Header no NAT */
	ft_ipv6_gre_encap    = 7,  /* GRE Encapsulate with Ipv6 Header no NAT */
	ft_ipv6_mapt_unmap2gre = 8, /* Ipv6 MAP-T unmap to IPv4 -> GRE Encap */
};


struct flow_mapt_ipv6_params {
	__be16 domain_index;
	__be32 src_ip;
	__be32 dst_ip;
	__be16 dst_port;
};

struct flow_ipv6_params {
	enum flow_ipv6_type type;

	/* Match Fields */
	u8  ip_prot;
	__be32 src_ip[4];
	__be32 dst_ip[4];
	__be16 src_port;
	__be16 dst_port;

	/* Replace Fields */
	u8  replacement_mac_src[6];
	u8  replacement_mac_dst[6];

	// MAP-T support
	struct flow_mapt_ipv6_params mapt;
};

enum flow_mb_type {
	ft_mb_discard      = 0,    /* Discard packets that match this flow */
	ft_mb_bridge       = 1,
};
struct flow_mac_bridge_params {
	enum flow_mb_type type;
	__u8  mac_src[6];
	__u8  mac_dst[6];
	__be16 ether_type;
	u32 rx_interface;
	u32 rx_subif;
};

struct flow_mc2uc_params {
	__u8  mac_dst[6];
	u32 interface;
};

enum flow_mcast_type {
	ft_mcast_discard      = 0, /* Discard packets that match this flow */
	ft_mcast_single       = 1, /* Multicast single output stream */
	ft_mcast_single_ucast = 2, /* Multicast single output stream with */
				   /* Unicast Conversion */
	ft_mcast_multi        = 3, /* Multicast multi output stream */
};

#define NUM_MC2UC 4
#define NUM_MCTX  32

struct flow_mc_params {
	enum flow_mcast_type type;
	__be32 group_id[4];        /* 32 Bits for IPv4 Multicast  */
				   /* 112 Bits for IPv6 Multicast */
	u32 rx_interface;
	u8 tx_interface_mask[NUM_MCTX];
	struct flow_mc2uc_params mc2uc[NUM_MC2UC];
};

struct flow_vlan_rule {
	bool used;
	struct flow_vlan_rule_params params;
};

struct flow_tunnel_params {
	int type;
	union {
		struct flow_dslite_tunnel_params dslite;
		struct flow_gre_tunnel_params gre;
	};
};

struct flow_ipsec_params {
	u32 spi;
};

struct flow_mapt_params {
        __be16 domain_index;
        __be32 br_prefix[2];
        __be16 br_prefix_length;
        __be32 ipv6_prefix[2];
        __be16 ipv6_prefix_length;
        __be32 map_ipv6_address[4];
        __be16 psid_offset;
        __be16 psid_length;
        __be16 psid;
	__be16 ea_len;
	__be32 ipv4_prefix;
	__be16 ipv4_prefix_length;
};

struct flow_map_params {
	int type;
	union {
		struct flow_mapt_params mapt;
	};
};

struct flow_params {
	enum flow_type type;
	struct flow_tx_params tx;
	struct flow_rx_params rx;
	union {
		struct flow_ipv4_params		ipv4;
		struct flow_ipv6_params		ipv6;
		struct flow_mac_bridge_params	mac_bridge;
		struct flow_mc_params		multicast;
	};
	struct flow_tunnel_params encap_tun;
	struct flow_tunnel_params decap_tun;
	struct flow_ipsec_params ipsec;
	struct flow_wifi_params wifi;
	struct flow_map_params map;
	int debug;
	void *data;
};

enum flow_feature {
	FLOW_F_TCP4_BIT,
	FLOW_F_UDP4_BIT,
	FLOW_F_ESP4_BIT,
	FLOW_F_AH4_BIT,
	FLOW_F_TCP6_BIT,
	FLOW_F_UDP6_BIT,
	FLOW_F_ESP6_BIT,
	FLOW_F_AH6_BIT,
	FLOW_F_GRETAP4WAN_BIT,
	FLOW_F_GRETAP6WAN_BIT,
	FLOW_F_GRETAP4LAN_BIT,
	FLOW_F_GRETAP6LAN_BIT,
	FLOW_F_GRETAP4ETHWAN_BIT,
	FLOW_F_GRETAP6ETHWAN_BIT,
	FLOW_F_DSLITE_BIT,
	FLOW_F_MAPT_BIT,
	FLOW_F_MACBR_BIT,
	FLOW_F_MCAST_BIT,
	FLOW_F_DSLITE_GRETAP4_BIT,
	FLOW_F_DSLITE_GRETAP6_BIT,
	FLOW_F_GRETAP4_DSLITE_BIT,
	FLOW_F_GRETAP6_DSLITE_BIT,
	FLOW_F_MAPT_GRETAP4_BIT,
	FLOW_F_MAPT_GRETAP6_BIT,
	FLOW_F_GRETAP4_MAPT_BIT,
	FLOW_F_GRETAP6_MAPT_BIT,
};

#define __FLOW_F_BIT(bit)	(1 << (bit))
#define __FLOW_F(name)		__FLOW_F_BIT(FLOW_F_##name##_BIT)
#define FLOW_F_TCP4		__FLOW_F(TCP4)
#define FLOW_F_UDP4		__FLOW_F(UDP4)
#define FLOW_F_ESP4		__FLOW_F(ESP4)
#define FLOW_F_AH4		__FLOW_F(AH4)
#define FLOW_F_TCP6		__FLOW_F(TCP6)
#define FLOW_F_UDP6		__FLOW_F(UDP6)
#define FLOW_F_ESP6		__FLOW_F(ESP6)
#define FLOW_F_AH6		__FLOW_F(AH6)
#define FLOW_F_GRETAP4WAN	__FLOW_F(GRETAP4WAN)
#define FLOW_F_GRETAP6WAN	__FLOW_F(GRETAP6WAN)
#define FLOW_F_GRETAP4LAN	__FLOW_F(GRETAP4LAN)
#define FLOW_F_GRETAP6LAN	__FLOW_F(GRETAP6LAN)
#define FLOW_F_GRETAP4ETHWAN	__FLOW_F(GRETAP4ETHWAN)
#define FLOW_F_GRETAP6ETHWAN	__FLOW_F(GRETAP6ETHWAN)
#define FLOW_F_DSLITE		__FLOW_F(DSLITE)
#define FLOW_F_MAPT		__FLOW_F(MAPT)
#define FLOW_F_MACBR		__FLOW_F(MACBR)
#define FLOW_F_MCAST		__FLOW_F(MCAST)
#define FLOW_F_DSLITE_GRETAP4	__FLOW_F(DSLITE_GRETAP4)
#define FLOW_F_DSLITE_GRETAP6	__FLOW_F(DSLITE_GRETAP6)
#define FLOW_F_GRETAP4_DSLITE	__FLOW_F(GRETAP4_DSLITE)
#define FLOW_F_GRETAP6_DSLITE	__FLOW_F(GRETAP6_DSLITE)
#define FLOW_F_MAPT_GRETAP4	__FLOW_F(MAPT_GRETAP4)
#define FLOW_F_MAPT_GRETAP6	__FLOW_F(MAPT_GRETAP6)
#define FLOW_F_GRETAP4_MAPT	__FLOW_F(GRETAP4_MAPT)
#define FLOW_F_GRETAP6_MAPT	__FLOW_F(GRETAP6_MAPT)

#define FLOW_F_DSLITE_GRE	(FLOW_F_DSLITE_GRETAP4 |\
				 FLOW_F_DSLITE_GRETAP6 | \
				 FLOW_F_GRETAP4_DSLITE | \
				 FLOW_F_GRETAP6_DSLITE)

#define FLOW_F_MAPT_GRE	(FLOW_F_MAPT_GRETAP4 |\
				 FLOW_F_MAPT_GRETAP6 | \
				 FLOW_F_GRETAP4_MAPT | \
				 FLOW_F_GRETAP6_MAPT)

#define FLOW_F_GRE_ALL		(FLOW_F_GRETAP4WAN | \
				 FLOW_F_GRETAP6WAN | \
				 FLOW_F_GRETAP4LAN | \
				 FLOW_F_GRETAP6LAN | \
				 FLOW_F_GRETAP4ETHWAN | \
				 FLOW_F_GRETAP6ETHWAN)

#define FLOW_F_TUNNEL_ALL	(FLOW_F_GRE_ALL | \
				 FLOW_F_DSLITE | \
				 FLOW_F_MAPT |\
				 FLOW_F_MAPT_GRE |\
				 FLOW_F_DSLITE_GRE)

#define FLOW_F_L4_ALL		(FLOW_F_TCP4 | \
				 FLOW_F_UDP4 | \
				 FLOW_F_ESP4 | \
				 FLOW_F_AH4 | \
				 FLOW_F_TCP6 | \
				 FLOW_F_UDP6 | \
				 FLOW_F_ESP6 | \
				 FLOW_F_AH6)

#endif
