/****************************************************************************
*
* Broadcom Proprietary and Confidential. (c) 2016 Broadcom.
* All rights reserved.
*
* Unless you and Broadcom execute a separate written software license
* agreement governing use of this software, this software is licensed to
* you under the terms of the GNU General Public License version 2 (the
* "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
* the following added to such license:
*
* As a special exception, the copyright holders of this software give you
* permission to link this software with independent modules, and to copy
* and distribute the resulting executable under terms of your choice,
* provided that you also meet, for each linked independent module, the
* terms and conditions of the license of that module. An independent
* module is a module which is not derived from this software. The special
* exception does not apply to any modifications of the software.
*
* Notwithstanding the above, under no circumstances may you combine this
* software in any way with any other Broadcom software provided under a
* license other than the GPL, without Broadcom's express prior written
* consent.
*
****************************************************************************/

/****************************************************************************
*
*	Filename:       bcmmbdma.h
*	Author:         Mark Newcomer/Charles Eyles
*	Creation Date:  5/6/2013
*	PURPOSE: 	  Header for common functions for the Unimac MBDMA driver
*
*****************************************************************************/

#ifndef BCMMBNDMA_H
#define BCMMBNDMA_H

#include <uapi/linux/if_link.h>
#include "bcmunimac_priv.h"

#define MBDMA_MAX_MTU_SIZE		1536
#define MBDMA_ALLOC_LIMIT		6	/* 126=Maxmium token cache size */
#define MBDMA_ALLOC_BURST		2	/* 16=3380 UBUS max */

/* When this threshold is hit we will reload the token cache from the FPM */
#define MBDMA_ALLOC_THRESH      (MBDMA_ALLOC_LIMIT - MBDMA_ALLOC_BURST)

/* Define the buffer size */
#define MBDMA_BUFF_SIZE_256		0	/* 256 byte minimum buffers */
#define MBDMA_BUFF_SIZE_512		1	/* 512 byte minimum buffers */

#define MBDMA_FREE_BURST		16	/* 3380 UBUS max */

/* When this threshold is hit we will send the local cache to FPM to be freed */
#define MBDMA_FREE_THRESH		MBDMA_FREE_BURST

/* SCB Bus channel Enable Bits */
#define RX0_SCB_ENABLE			(1<<0)
#define TX0_SCB_ENABLE			(1<<1)
#define TX1_SCB_ENABLE			(1<<2)

#define LANRX_MSG			0
#define LANTX_MSG			1
#define LANRXO_MAC_ID_ETH0		0
#define LANTXO_MAC_ID_ETH0		0

#define MBDMA_TX_ID_3WORD		49
#define MBDMA_TX_ID_2WORD		34
#define MBDMA_ALLOC_KEEP_ENABLE	1
#define MBDMA_TOP_ARB_CTL		3
#define MBDMA_TX_ARB_CTL		1

#define MBDMA_RX_ID			LANRXO_MAC_ID_ETH0
#define MBDMA_TX_ID			LANTXO_MAC_ID_ETH0

#define MAX_UBUS_BURST			(128)
#define MAX_SCB_BURST			(256)

#define TX_MAX_REQ			4
#define TOKEN_FLUSH			0x3

#define MBDMA_STATUS				0x00
#define MBDMA_STATUS_TX_MSGQ_OVERFLOW_MASK	0x00008000
#define MBDMA_STATUS_TX_MSGQ_OVERFLOW_SHIFT	15
#define MBDMA_STATUS_INVALID_TX_MSG_INTR_MASK	0x00004000
#define MBDMA_STATUS_INVALID_TX_MSG_INTR_SHIFT	14
#define MBDMA_STATUS_UBUS_ERROR_MASK		0x00001000
#define MBDMA_STATUS_UBUS_ERROR_SHIFT		12
#define MBDMA_STATUS_TOKEN_RD_ERROR_MASK	0x00000800
#define MBDMA_STATUS_TOKEN_RD_ERROR_SHIFT	11
#define MBDMA_STATUS_INVALID_TOKEN_MASK		0x00000400
#define MBDMA_STATUS_INVALID_TOKEN_SHIFT	10
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_2K_MASK	0x00000200
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_2K_SHIFT	9
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_1K_MASK	0x00000080
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_1K_SHIFT	7
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_512_MASK	0x00000020
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_512_SHIFT	5
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_256_MASK	0x00000008
#define MBDMA_STATUS_ALLOC_FIFO_EMPTY_256_SHIFT	3
#define MBDMA_STATUS_FREE_FIFO_FULL_MASK	0x00000001
#define MBDMA_STATUS_FREE_FIFO_FULL_SHIFT	0

#define MBDMA_TOKCACHECTL			0x04
#define MBDMA_TOKCACHECTL_BUFF_SIZE_MASK	0x00010000
#define MBDMA_TOKCACHECTL_BUFF_SIZE_SHIFT	16
#define MBDMA_TOKCACHECTL_FREE_ENABLE_MASK	0x00008000
#define MBDMA_TOKCACHECTL_FREE_ENABLE_SHIFT	15
#define MBDMA_TOKCACHECTL_FREE_MAX_BURST_MASK	0x00001f00
#define MBDMA_TOKCACHECTL_FREE_MAX_BURST_SHIFT	8
#define MBDMA_TOKCACHECTL_FREE_THRESH_MASK	0x000000ff
#define MBDMA_TOKCACHECTL_FREE_THRESH_SHIFT	0

#define MBDMA_TOKENADDRFREE			0x08
#define MBDMA_BUFFBASE0				0x10
#define MBDMA_BUFFBASE1				0x84

#define MBDMA_GLOBALCTL				0x0c
#define MBDMA_GLOBALCTL_FLUSH_CACHE_MASK	0x00800000
#define MBDMA_GLOBALCTL_FLUSH_CACHE_SHIFT	23
#define MBDMA_GLOBALCTL_LAN_TX_MSG_ID_3W_MASK	0x00000fc0
#define MBDMA_GLOBALCTL_LAN_TX_MSG_ID_3W_SHIFT	6
#define MBDMA_GLOBALCTL_LAN_TX_MSG_ID_2W_MASK	0x0000003f
#define MBDMA_GLOBALCTL_LAN_TX_MSG_ID_2W_SHIFT	0

#define MBDMA_TOKCACHECTL2			0x44
#define MBDMA_TOKCACHECTL2_BURST2K_MASK		0xff000000
#define MBDMA_TOKCACHECTL2_BURST2K_SHIFT	24
#define MBDMA_TOKCACHECTL2_BURST1K_MASK		0x00ff0000
#define MBDMA_TOKCACHECTL2_BURST1K_SHIFT	16
#define MBDMA_TOKCACHECTL2_BURST512_MASK	0x0000ff00
#define MBDMA_TOKCACHECTL2_BURST512_SHIFT	8
#define MBDMA_TOKCACHECTL2_BURST256_MASK	0x000000ff
#define MBDMA_TOKCACHECTL2_BURST256_SHIFT	0

#define MBDMA_TOKCACHECTL3			0x48
#define MBDMA_TOKENADDR256			0x4c
#define MBDMA_TOKENADDR512			0x50
#define MBDMA_TOKENADDR1K			0x54
#define MBDMA_TOKENADDR2K			0x58

#define MBDMA_SCBCNTL				0x68
#define MBDMA_SCBCNTL_USE_WR_REPLY_MASK		0x00400000
#define MBDMA_SCBCNTL_USE_WR_REPLY_SHIFT	22
#define MBDMA_SCBCNTL_FORCE_SINGLE_QUEUE_MASK	0x00200000
#define MBDMA_SCBCNTL_FORCE_SINGLE_QUEUE_SHIFT	21
#define MBDMA_SCBCNTL_CLIENT_INIT_MASK		0x00100000
#define MBDMA_SCBCNTL_CLIENT_INIT_SHIFT		20
#define MBDMA_SCBCNTL_COHERENT_MASK		0x00020000
#define MBDMA_SCBCNTL_COHERENT_SHIFT		17
#define MBDMA_SCBCNTL_ENABLE_MASK		0x00000007
#define MBDMA_SCBCNTL_ENABLE_SHIFT		0

#define MBDMA_SCBADDRLO_0			0x70
#define MBDMA_SCBADDRLO_0_ADDR_MASK		0xffffffff
#define MBDMA_SCBADDRLO_0_ADDR_SHIFT		0

#define MBDMA_SCBADDRHI_0			0x74
#define MBDMA_SCBADDRHI_0_ADDR_MASK		0x000000ff
#define MBDMA_SCBADDRHI_0_ADDR_SHIFT		0

#define MBDMA_SCBADDRLO_1			0x88
#define MBDMA_SCBADDRLO_1_ADDR_MASK		0xffffffff
#define MBDMA_SCBADDRLO_1_ADDR_SHIFT		0

#define MBDMA_SCBADDRHI_1			0x8c
#define MBDMA_SCBADDRHI_1_ADDR_MASK		0x000000ff
#define MBDMA_SCBADDRHI_1_ADDR_SHIFT		0

#define MBDMA_CHANCTRL00			0x100
#define MBDMA_CHANCTRL00_START_STOP_FLUSH_MASK	0xc0000000
#define MBDMA_CHANCTRL00_START_STOP_FLUSH_SHIFT	30
#define MBDMA_CHANCTRL00_MAX_BURST_MASK		0x1ff00000
#define MBDMA_CHANCTRL00_MAX_BURST_SHIFT	20

#define MBDMA_RXOFF				0x108
#define MBDMA_RXOFF_BUF_OFF_MASK		0x000001ff
#define MBDMA_RXOFF_BUF_OFF_SHIFT		0

#define MBDMA_CHANCTRL01_2			0x128
#define MBDMA_CHANCTRL01_2_TX_MSGQ_OVR_MASK	0x00010000
#define MBDMA_CHANCTRL01_2_TX_MSGQ_OVR_SHIFT	16

#define MBDMA_CHANCTRL01			0x120
#define MBDMA_CHANCTRL01_START_STOP_FLUSH_MASK	0xc0000000
#define MBDMA_CHANCTRL01_START_STOP_FLUSH_SHIFT	30
#define MBDMA_CHANCTRL01_MAX_BURST_MASK		0x1ff00000
#define MBDMA_CHANCTRL01_MAX_BURST_SHIFT	20
#define MBDMA_CHANCTRL01_MAX_REQS_MASK		0x0000000f
#define MBDMA_CHANCTRL01_MAX_REQS_SHIFT		0

#define MBDMA_CHANCTRL02			0x140
#define MBDMA_CHANCTRL02_START_STOP_FLUSH_MASK	0xc0000000
#define MBDMA_CHANCTRL02_START_STOP_FLUSH_SHIFT	30
#define MBDMA_CHANCTRL02_MAX_BURST_MASK		0x1ff00000
#define MBDMA_CHANCTRL02_MAX_BURST_SHIFT	20
#define MBDMA_CHANCTRL02_MAX_REQS_MASK		0x0000000f
#define MBDMA_CHANCTRL02_MAX_REQS_SHIFT		0

#define MBDMA_CHANCTRL02_2			0x148
#define MBDMA_CHANCTRL02_2_TX_MSGQ_OVR_MASK	0x00010000
#define MBDMA_CHANCTRL02_2_TX_MSGQ_OVR_SHIFT	16

enum
{
	fpm_four_buffers = 0,
	fpm_three_buffers,
	fpm_two_buffers,
	fpm_one_buffer
};

void	bcmunimac_hardware_init(struct unimac_device *qdev);
void	mbdma_init(void *unimac_device);
void	mbdma_dump_status(void *unimac_device);
int		bcmunimac_set_link_hw(struct unimac_device *udev, int link, int speed,
			int duplex, int pause);
int		bcmunimac_get_stats_hw(struct unimac_device *udev,
			struct rtnl_link_stats64 *stats);

#endif
