/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef _DQNET_SWITCH_H_
#define _DQNET_SWITCH_H_

struct dqnet_switch_stats {
	u64	tx_bytes;
	u32	tx_drop_pkts;
	u32	tx_broadcast_pkts;
	u32	tx_multicast_pkts;
	u32	tx_unicast_pkts;
	u32	tx_pause_pkts;
	u32	tx_collisions;
	u32	tx_single_collision;
	u32	tx_multiple_collision;
	u32	tx_late_collision;
	u32	tx_excessive_collision;
	u32	tx_deferred_transmit;
	u32	tx_frame_in_disc;
	u32	tx_q0_pkt;
	u32	tx_q1_pkt;
	u32	tx_q2_pkt;
	u32	tx_q3_pkt;
	u32	tx_q4_pkt;
	u32	tx_q5_pkt;
	u32	tx_q6_pkt;
	u32	tx_q7_pkt;
	u32	tx_pkts_64_bytes;
	u32	tx_pkts_65to127_bytes;
	u32	tx_pkts_128to255_bytes;
	u32	tx_pkts_256to511_bytes;
	u32	tx_pkts_512to1023_bytes;
	u32	tx_pkts_1024tomax_bytes;
	u64	rx_bytes;
	u64	rx_good_bytes;
	u32	rx_drop_pkts;
	u32	rx_broadcast_pkts;
	u32	rx_multicast_pkts;
	u32	rx_unicast_pkts;
	u32	rx_pause_pkts;
	u32	rx_sa_changes;
	u32	rx_undersize_pkts;
	u32	rx_pkts_64_bytes;
	u32	rx_pkts_65to127_bytes;
	u32	rx_pkts_128to255_bytes;
	u32	rx_pkts_256to511_bytes;
	u32	rx_pkts_512to1023_bytes;
	u32	rx_pkts_1024tomax_bytes;
	u32	rx_oversize_pkts;
	u32	rx_jumbo_pkts;
	u32	rx_fragments;
	u32	rx_jabbers;
	u32	rx_discard;
	u32	rx_alignment_errors;
	u32	rx_fcs_errors;
	u32	rx_symbol_errors;
	u32	rx_in_range_errors;
	u32	rx_out_of_range_errors;
	u32	eee_lpi_event;
	u32	eee_lpi_duration;
};

struct dqnet_port_pwr {
	/* control/status */
	bool	auto_pwr_down;
	u32	eee_advertised;
	bool	eee_enabled;
	bool	eee_tx_lpi_enabled;
	u32	eee_tx_lpi_timer;

	/* status */
	bool	power_on;
	bool	eee_active;
	u32	eee_supported;
	u32	eee_lp_advertised;
};

struct dqnet_switch_ops {
	int	(*get_max_ports)(void);
	int	(*demux_arl)(struct dqnet_channel *chan,
			     struct fpm_buff *fb);
	struct rtnl_link_stats64 *(*link_stats)(struct net_device *dev,
			     struct rtnl_link_stats64 *stats);
	int	(*vlan_rx_add_vid)(struct net_device *dev,
				   __be16 proto, u16 vid);
	int 	(*vlan_rx_kill_vid)(struct net_device *dev,
				    __be16 proto, u16 vid);
	int 	(*get_port_pwr)(struct net_device *dev,
				struct dqnet_port_pwr *pwr);
	int 	(*set_port_pwr)(struct net_device *dev,
				struct dqnet_port_pwr *pwr);
	int 	(*enable_port)(struct net_device *dev);
	int 	(*disable_port)(struct net_device *dev);
	int 	(*connect_port)(struct net_device *dev);
	int 	(*disconnect_port)(struct net_device *dev);
	int	(*get_port_config)(struct net_device *dev);
	int	(*set_port_config)(struct net_device *dev);
	int	(*get_mib_counters)(struct net_device *dev,
				    struct dqnet_switch_stats *stats);
	int	(*set_port_stp_state)(struct net_device *dev,
				      int port, unsigned int state);
	bool (*vlan_enabled)(void);
	bool (*switch_ipv6_mc_flood_disabled)(void);
	bool (*switch_drop_brcst_mult)(int port, int start_port);
	int	(*set_mtu) (unsigned int mtu);
};

#if defined(CONFIG_BCM_ETHSW) || defined(CONFIG_BCM_ETHSW_MODULE)
extern struct dqnet_switch_ops ethsw;
#define SWITCH	(&ethsw)
#else
extern struct dqnet_switch_ops noswitch;
#define SWITCH	(&noswitch)
#endif

#endif
