 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

/* IPSEC constants and structs */
#ifndef _NF_CONNTRACK_IPSEC_H
#define _NF_CONNTRACK_IPSEC_H

#include <linux/netfilter/nf_conntrack_common.h>

/* conntrack private data */
struct nf_ct_ipsec_master {
	__be32 initcookie;	/* initcookie of ISAKMP */
	__be32 lan_ip;		/* LAN IP */
};

struct nf_nat_ipsec {
	__be32 lan_ip;		/* LAN IP */
};

#ifdef __KERNEL__

#define IPSEC_PORT		500
#define MAX_VPN_CONNECTION	32

struct isakmp_pkt_hdr {
	__be32 initcookie;
};


/* crap needed for nf_conntrack_compat.h */
struct nf_conn;
struct nf_conntrack_expect;

extern int
(*nf_nat_ipsec_hook_outbound)(struct sk_buff *skb,
			      struct nf_conn *ct,
			      enum ip_conntrack_info ctinfo);

extern int
(*nf_nat_ipsec_hook_inbound)(struct sk_buff *skb,
			     struct nf_conn *ct,
			     enum ip_conntrack_info ctinfo,
			     __be32 lan_ip);

#endif /* __KERNEL__ */
#endif /* _NF_CONNTRACK_IPSEC_H */
