 /****************************************************************************
  *
  * Broadcom Proprietary and Confidential. (c) 2016 Broadcom.
  * All rights reserved.
  * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
  *
  * Unless you and Broadcom execute a separate written software license
  * agreement governing use of this software, this software is licensed to
  * you under the terms of the GNU General Public License version 2 (the
  * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
  * the following added to such license:
  *
  * As a special exception, the copyright holders of this software give you
  * permission to link this software with independent modules, and to copy
  * and distribute the resulting executable under terms of your choice,
  * provided that you also meet, for each linked independent module, the
  * terms and conditions of the license of that module. An independent
  * module is a module which is not derived from this software. The special
  * exception does not apply to any modifications of the software.
  *
  * Notwithstanding the above, under no circumstances may you combine this
  * software in any way with any other Broadcom software provided under a
  * license other than the GPL, without Broadcom's express prior written
  * consent.
  *
  ****************************************************************************/
#include <linux/types.h>
#include <linux/ip.h>
#include <linux/netfilter.h>
#include <linux/module.h>
#include <linux/skbuff.h>
#include <net/route.h>
#include <net/ip.h>
#include <linux/version.h>

#include <linux/netfilter_bridge.h>
#include <linux/netfilter_ipv4.h>
#include <net/netfilter/ipv4/nf_defrag_ipv4.h>
#if defined(CONFIG_NF_CONNTRACK) || defined(CONFIG_NF_CONNTRACK_MODULE)
#include <net/netfilter/nf_conntrack.h>
#endif
#include <net/netfilter/nf_conntrack_zones.h>

#define WAN_IF_NAME	"wanbridge"
struct net_device *wan_dev = NULL;


#if LINUX_VERSION_CODE > KERNEL_VERSION(3, 17, 0)
static unsigned int ipv4_frag_drop_for_wan(void *priv,
					  struct sk_buff *skb,
					  const struct nf_hook_state *state)
#else
static unsigned int ipv4_frag_drop_for_wan(const struct nf_hook_ops *ops,
					  const struct net_device *in,
					  const struct net_device *out,
					  int (*okfn)(struct sk_buff *))
#endif
{
	struct sock *sk = skb->sk;
	struct inet_sock *inet = inet_sk(skb->sk);

	if (sk && (sk->sk_family == PF_INET) &&
	    inet->nodefrag)
		return NF_ACCEPT;

#if defined(CONFIG_NF_CONNTRACK) || defined(CONFIG_NF_CONNTRACK_MODULE)
#if !defined(CONFIG_NF_NAT) && !defined(CONFIG_NF_NAT_MODULE)
	/* Previously seen (loopback)?  Ignore.  Do this before
	   fragment check. */
	if (skb->nfct && !nf_ct_is_template((struct nf_conn *)skb->nfct))
		return NF_ACCEPT;
#endif
#endif

	if (!wan_dev){
		return NF_ACCEPT;
	}else{
		if(wan_dev == skb->dev && ip_is_fragment(ip_hdr(skb)))
			return NF_DROP;
		else
			return NF_ACCEPT;
	}
}


static struct nf_hook_ops ipv4_frag_drop_for_wan_ops[] = {
	{
		.hook		= ipv4_frag_drop_for_wan,
		.pf		= NFPROTO_IPV4,
		.hooknum	= NF_INET_PRE_ROUTING,
		.priority	= (NF_IP_PRI_CONNTRACK_DEFRAG - 100),
	},
};

static int __init nf_ipv4_frag_drop_for_wan_init(void)
{
	int ret = 0;
	wan_dev = dev_get_by_name(&init_net, WAN_IF_NAME);

	ret = nf_register_net_hooks(&init_net, ipv4_frag_drop_for_wan_ops,
				    ARRAY_SIZE(ipv4_frag_drop_for_wan_ops));
	if (ret < 0) {
		pr_err("ipv4_frag_drop_for_wan: can't register hooks\n");
		goto cleanup_frag6;
	}
	pr_info("ipv4_frag_drop_for_wan Init\n");
	return ret;

cleanup_frag6:

	return ret;

}

static void __exit nf_ipv4_frag_drop_for_wan_fini(void)
{
	dev_put(wan_dev);
	nf_unregister_net_hooks(&init_net, ipv4_frag_drop_for_wan_ops,
				ARRAY_SIZE(ipv4_frag_drop_for_wan_ops));
	pr_info("ipv4_frag_drop_for_wan Exit\n");
}



module_init(nf_ipv4_frag_drop_for_wan_init);
module_exit(nf_ipv4_frag_drop_for_wan_fini);

MODULE_LICENSE("GPL");
