/* valacastexpression.c generated by valac, the Vala compiler
 * generated from valacastexpression.vala, do not modify */

/* valacastexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaCastExpressionPrivate {
	gboolean _is_silent_cast;
	gboolean _is_non_null_cast;
	ValaExpression* _inner;
	ValaDataType* _data_type;
};

static gint ValaCastExpression_private_offset;
static gpointer vala_cast_expression_parent_class = NULL;

static void vala_cast_expression_set_inner (ValaCastExpression* self,
                                     ValaExpression* value);
static void vala_cast_expression_set_type_reference (ValaCastExpression* self,
                                              ValaDataType* value);
static void vala_cast_expression_set_is_silent_cast (ValaCastExpression* self,
                                              gboolean value);
static void vala_cast_expression_set_is_non_null_cast (ValaCastExpression* self,
                                                gboolean value);
static void vala_cast_expression_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_cast_expression_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gchar* vala_cast_expression_real_to_string (ValaCodeNode* base);
static void vala_cast_expression_real_replace_expression (ValaCodeNode* base,
                                                   ValaExpression* old_node,
                                                   ValaExpression* new_node);
static gboolean vala_cast_expression_real_is_pure (ValaExpression* base);
static gboolean vala_cast_expression_real_is_accessible (ValaExpression* base,
                                                  ValaSymbol* sym);
static void vala_cast_expression_real_replace_type (ValaCodeNode* base,
                                             ValaDataType* old_type,
                                             ValaDataType* new_type);
static gboolean vala_cast_expression_real_is_non_null (ValaExpression* base);
static void vala_cast_expression_real_get_error_types (ValaCodeNode* base,
                                                ValaCollection* collection,
                                                ValaSourceReference* source_reference);
static gboolean vala_cast_expression_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static gboolean vala_cast_expression_is_gvariant (ValaCastExpression* self,
                                           ValaCodeContext* context,
                                           ValaDataType* type);
static gboolean vala_cast_expression_is_gvalue (ValaCastExpression* self,
                                         ValaCodeContext* context,
                                         ValaDataType* type);
static void vala_cast_expression_real_emit (ValaCodeNode* base,
                                     ValaCodeGenerator* codegen);
static void vala_cast_expression_real_get_defined_variables (ValaCodeNode* base,
                                                      ValaCollection* collection);
static void vala_cast_expression_real_get_used_variables (ValaCodeNode* base,
                                                   ValaCollection* collection);
static gboolean vala_cast_expression_real_is_constant (ValaExpression* base);
static void vala_cast_expression_finalize (ValaCodeNode * obj);
static GType vala_cast_expression_get_type_once (void);

static inline gpointer
vala_cast_expression_get_instance_private (ValaCastExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCastExpression_private_offset);
}

ValaExpression*
vala_cast_expression_get_inner (ValaCastExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_cast_expression_set_inner (ValaCastExpression* self,
                                ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaDataType*
vala_cast_expression_get_type_reference (ValaCastExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static void
vala_cast_expression_set_type_reference (ValaCastExpression* self,
                                         ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_cast_expression_get_is_silent_cast (ValaCastExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_silent_cast;
	return result;
}

static void
vala_cast_expression_set_is_silent_cast (ValaCastExpression* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_silent_cast = value;
}

gboolean
vala_cast_expression_get_is_non_null_cast (ValaCastExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_non_null_cast;
	return result;
}

static void
vala_cast_expression_set_is_non_null_cast (ValaCastExpression* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_non_null_cast = value;
}

/**
 * Creates a new cast expression.
 *
 * @param inner           expression to be cast
 * @param type_reference  target type
 * @return                newly created cast expression
 */
ValaCastExpression*
vala_cast_expression_construct (GType object_type,
                                ValaExpression* inner,
                                ValaDataType* type_reference,
                                ValaSourceReference* source_reference)
{
	ValaCastExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (type_reference != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	vala_cast_expression_set_type_reference (self, type_reference);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_cast_expression_set_is_silent_cast (self, FALSE);
	vala_cast_expression_set_is_non_null_cast (self, FALSE);
	vala_cast_expression_set_inner (self, inner);
	return self;
}

ValaCastExpression*
vala_cast_expression_new (ValaExpression* inner,
                          ValaDataType* type_reference,
                          ValaSourceReference* source_reference)
{
	return vala_cast_expression_construct (VALA_TYPE_CAST_EXPRESSION, inner, type_reference, source_reference);
}

ValaCastExpression*
vala_cast_expression_construct_silent (GType object_type,
                                       ValaExpression* inner,
                                       ValaDataType* type_reference,
                                       ValaSourceReference* source_reference)
{
	ValaCastExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (type_reference != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	vala_cast_expression_set_type_reference (self, type_reference);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_cast_expression_set_is_silent_cast (self, TRUE);
	vala_cast_expression_set_is_non_null_cast (self, FALSE);
	vala_cast_expression_set_inner (self, inner);
	return self;
}

ValaCastExpression*
vala_cast_expression_new_silent (ValaExpression* inner,
                                 ValaDataType* type_reference,
                                 ValaSourceReference* source_reference)
{
	return vala_cast_expression_construct_silent (VALA_TYPE_CAST_EXPRESSION, inner, type_reference, source_reference);
}

ValaCastExpression*
vala_cast_expression_construct_non_null (GType object_type,
                                         ValaExpression* inner,
                                         ValaSourceReference* source_reference)
{
	ValaCastExpression* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	self = (ValaCastExpression*) vala_expression_construct (object_type);
	vala_cast_expression_set_inner (self, inner);
	vala_cast_expression_set_is_non_null_cast (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaCastExpression*
vala_cast_expression_new_non_null (ValaExpression* inner,
                                   ValaSourceReference* source_reference)
{
	return vala_cast_expression_construct_non_null (VALA_TYPE_CAST_EXPRESSION, inner, source_reference);
}

static void
vala_cast_expression_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCastExpression * self;
	self = (ValaCastExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_cast_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_cast_expression_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = self->priv->_is_non_null_cast;
	if (!_tmp2_) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		_tmp3_ = vala_cast_expression_get_type_reference (self);
		_tmp4_ = _tmp3_;
		vala_code_node_accept ((ValaCodeNode*) _tmp4_, visitor);
	}
}

static gchar*
vala_cast_expression_real_to_string (ValaCodeNode* base)
{
	ValaCastExpression * self;
	gboolean _tmp0_;
	gchar* result;
	self = (ValaCastExpression*) base;
	_tmp0_ = self->priv->_is_non_null_cast;
	if (_tmp0_) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp1_ = vala_cast_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_code_node_to_string ((ValaCodeNode*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("(!) %s", _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		result = _tmp6_;
		return result;
	} else {
		gboolean _tmp7_;
		_tmp7_ = self->priv->_is_silent_cast;
		if (_tmp7_) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp8_ = vala_cast_expression_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_cast_expression_get_type_reference (self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%s as %s", _tmp11_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp11_);
			result = _tmp17_;
			return result;
		} else {
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			ValaExpression* _tmp22_;
			ValaExpression* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp18_ = vala_cast_expression_get_type_reference (self);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_cast_expression_get_inner (self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_node_to_string ((ValaCodeNode*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("(%s) %s", _tmp21_, _tmp25_);
			_tmp27_ = _tmp26_;
			_g_free0 (_tmp25_);
			_g_free0 (_tmp21_);
			result = _tmp27_;
			return result;
		}
	}
}

static void
vala_cast_expression_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_cast_expression_set_inner (self, new_node);
	}
}

static gboolean
vala_cast_expression_real_is_pure (ValaExpression* base)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result;
	self = (ValaCastExpression*) base;
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_pure (_tmp1_);
	return result;
}

static gboolean
vala_cast_expression_real_is_accessible (ValaExpression* base,
                                         ValaSymbol* sym)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result;
	self = (ValaCastExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}

static void
vala_cast_expression_real_replace_type (ValaCodeNode* base,
                                        ValaDataType* old_type,
                                        ValaDataType* new_type)
{
	ValaCastExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_cast_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_cast_expression_set_type_reference (self, new_type);
	}
}

static gboolean
vala_cast_expression_real_is_non_null (ValaExpression* base)
{
	ValaCastExpression * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	self = (ValaCastExpression*) base;
	_tmp1_ = self->priv->_is_non_null_cast;
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = self->priv->_is_silent_cast;
		if (!_tmp3_) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			_tmp4_ = vala_cast_expression_get_inner (self);
			_tmp5_ = _tmp4_;
			_tmp2_ = vala_expression_is_non_null (_tmp5_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static void
vala_cast_expression_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
}

static gboolean
vala_cast_expression_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCastExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp12_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gboolean _tmp27_ = FALSE;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	gboolean _tmp64_ = FALSE;
	ValaDataType* _tmp65_;
	ValaDataType* _tmp66_;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_;
	ValaDataType* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	ValaDataType* _tmp140_;
	ValaExpression* _tmp141_;
	ValaExpression* _tmp142_;
	ValaDataType* _tmp143_;
	ValaDataType* _tmp144_;
	gboolean _tmp145_;
	gboolean _tmp146_;
	ValaDataType* _tmp147_;
	ValaDataType* _tmp148_;
	ValaExpression* _tmp149_;
	ValaExpression* _tmp150_;
	ValaDataType* _tmp151_;
	ValaDataType* _tmp152_;
	gboolean _tmp153_;
	gboolean _tmp154_;
	gboolean _tmp155_;
	gboolean _tmp158_ = FALSE;
	gboolean _tmp159_ = FALSE;
	ValaProfile _tmp160_;
	ValaProfile _tmp161_;
	gboolean _tmp181_ = FALSE;
	gboolean _tmp182_ = FALSE;
	ValaProfile _tmp183_;
	ValaProfile _tmp184_;
	ValaExpression* _tmp213_;
	ValaExpression* _tmp214_;
	ValaExpression* _tmp215_;
	ValaExpression* _tmp216_;
	ValaDataType* _tmp217_;
	ValaDataType* _tmp218_;
	ValaDataType* _tmp219_;
	ValaDataType* _tmp220_;
	gboolean _tmp221_;
	gboolean _tmp222_;
	gboolean result;
	self = (ValaCastExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_cast_expression_get_inner (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_cast_expression_get_inner (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp11_, "Invalid cast expression");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->_is_non_null_cast;
	if (_tmp12_) {
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = vala_cast_expression_get_inner (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_expression_get_value_type (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_data_type_copy (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_cast_expression_set_type_reference (self, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp19_ = vala_cast_expression_get_type_reference (self);
		_tmp20_ = _tmp19_;
		vala_data_type_set_nullable (_tmp20_, FALSE);
	}
	_tmp21_ = vala_cast_expression_get_type_reference (self);
	_tmp22_ = _tmp21_;
	vala_code_node_check ((ValaCodeNode*) _tmp22_, context);
	_tmp23_ = vala_cast_expression_get_type_reference (self);
	_tmp24_ = _tmp23_;
	if (VALA_IS_VOID_TYPE (_tmp24_)) {
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		vala_report_error (_tmp26_, "Casting to `void' is not allowed");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp28_ = vala_cast_expression_get_type_reference (self);
	_tmp29_ = _tmp28_;
	if (VALA_IS_ARRAY_TYPE (_tmp29_)) {
		_tmp27_ = TRUE;
	} else {
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		_tmp30_ = vala_cast_expression_get_type_reference (self);
		_tmp31_ = _tmp30_;
		_tmp27_ = VALA_IS_POINTER_TYPE (_tmp31_);
	}
	if (!_tmp27_) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp34_ = vala_cast_expression_get_type_reference (self);
		_tmp35_ = _tmp34_;
		if (!vala_data_type_is_real_struct_type (_tmp35_)) {
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			ValaDataType* _tmp38_;
			ValaDataType* _tmp39_;
			_tmp36_ = vala_cast_expression_get_inner (self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_expression_get_value_type (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp33_ = vala_data_type_is_real_struct_type (_tmp39_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			gboolean _tmp40_ = FALSE;
			ValaProfile _tmp41_;
			ValaProfile _tmp42_;
			_tmp41_ = vala_code_context_get_profile (context);
			_tmp42_ = _tmp41_;
			if (_tmp42_ != VALA_PROFILE_GOBJECT) {
				_tmp40_ = TRUE;
			} else {
				gboolean _tmp43_ = FALSE;
				ValaExpression* _tmp44_;
				ValaExpression* _tmp45_;
				ValaDataType* _tmp46_;
				ValaDataType* _tmp47_;
				_tmp44_ = vala_cast_expression_get_inner (self);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_expression_get_value_type (_tmp45_);
				_tmp47_ = _tmp46_;
				if (vala_cast_expression_is_gvariant (self, context, _tmp47_)) {
					_tmp43_ = TRUE;
				} else {
					ValaExpression* _tmp48_;
					ValaExpression* _tmp49_;
					ValaDataType* _tmp50_;
					ValaDataType* _tmp51_;
					_tmp48_ = vala_cast_expression_get_inner (self);
					_tmp49_ = _tmp48_;
					_tmp50_ = vala_expression_get_value_type (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp43_ = vala_cast_expression_is_gvalue (self, context, _tmp51_);
				}
				_tmp40_ = !_tmp43_;
			}
			_tmp32_ = _tmp40_;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaExpression* _tmp54_;
			ValaExpression* _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaDataType* _tmp60_;
			ValaDataType* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_cast_expression_get_inner (self);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_expression_get_value_type (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_data_type_to_qualified_string (_tmp57_, NULL);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_cast_expression_get_type_reference (self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_data_type_to_qualified_string (_tmp61_, NULL);
			_tmp63_ = _tmp62_;
			vala_report_error (_tmp53_, "Casting of struct `%s' to `%s' is not allowed", _tmp59_, _tmp63_);
			_g_free0 (_tmp63_);
			_g_free0 (_tmp59_);
		}
	}
	_tmp65_ = vala_cast_expression_get_type_reference (self);
	_tmp66_ = _tmp65_;
	if (VALA_IS_DELEGATE_TYPE (_tmp66_)) {
		ValaExpression* _tmp67_;
		ValaExpression* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		_tmp67_ = vala_cast_expression_get_inner (self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_expression_get_value_type (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp64_ = VALA_IS_METHOD_TYPE (_tmp70_);
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		_tmp71_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp72_ = _tmp71_;
		if (_tmp72_ != NULL) {
			ValaExpression* _tmp73_;
			ValaExpression* _tmp74_;
			ValaDataType* _tmp75_;
			ValaDataType* _tmp76_;
			ValaDataType* _tmp77_;
			ValaDataType* _tmp78_;
			gboolean _tmp79_;
			gboolean _tmp80_;
			_tmp73_ = vala_cast_expression_get_inner (self);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_expression_get_value_type (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp77_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp78_ = _tmp77_;
			_tmp79_ = vala_data_type_get_value_owned (_tmp78_);
			_tmp80_ = _tmp79_;
			vala_data_type_set_value_owned (_tmp76_, _tmp80_);
		} else {
			ValaExpression* _tmp81_;
			ValaExpression* _tmp82_;
			ValaDataType* _tmp83_;
			ValaDataType* _tmp84_;
			_tmp81_ = vala_cast_expression_get_inner (self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_expression_get_value_type (_tmp82_);
			_tmp84_ = _tmp83_;
			vala_data_type_set_value_owned (_tmp84_, TRUE);
		}
	}
	_tmp88_ = self->priv->_is_silent_cast;
	if (_tmp88_) {
		_tmp87_ = TRUE;
	} else {
		gboolean _tmp89_;
		_tmp89_ = self->priv->_is_non_null_cast;
		_tmp87_ = _tmp89_;
	}
	if (!_tmp87_) {
		gboolean _tmp90_ = FALSE;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		_tmp91_ = vala_cast_expression_get_type_reference (self);
		_tmp92_ = _tmp91_;
		if (VALA_IS_VALUE_TYPE (_tmp92_)) {
			ValaDataType* _tmp93_;
			ValaDataType* _tmp94_;
			gboolean _tmp95_;
			gboolean _tmp96_;
			_tmp93_ = vala_cast_expression_get_type_reference (self);
			_tmp94_ = _tmp93_;
			_tmp95_ = vala_data_type_get_nullable (_tmp94_);
			_tmp96_ = _tmp95_;
			_tmp90_ = _tmp96_;
		} else {
			_tmp90_ = FALSE;
		}
		_tmp86_ = _tmp90_;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaDataType* _tmp99_;
		ValaDataType* _tmp100_;
		_tmp97_ = vala_cast_expression_get_inner (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_expression_get_value_type (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp85_ = vala_data_type_is_non_null_simple_type (_tmp100_);
	} else {
		_tmp85_ = FALSE;
	}
	if (_tmp85_) {
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp101_;
		ValaDataType* _tmp102_;
		gchar* _tmp103_;
		gchar* _tmp104_;
		ValaExpression* _tmp105_;
		ValaExpression* _tmp106_;
		ValaSourceReference* _tmp107_;
		ValaSourceReference* _tmp108_;
		ValaLocalVariable* _tmp109_;
		ValaLocalVariable* _tmp110_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp111_;
		ValaSourceReference* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaDeclarationStatement* _tmp114_;
		ValaSemanticAnalyzer* _tmp115_;
		ValaSemanticAnalyzer* _tmp116_;
		ValaBlock* _tmp117_;
		ValaDeclarationStatement* _tmp118_;
		ValaExpression* temp_access = NULL;
		ValaLocalVariable* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaExpression* _tmp122_;
		ValaExpression* _tmp123_;
		ValaDataType* _tmp124_;
		ValaDataType* _tmp125_;
		ValaLocalVariable* _tmp126_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaDeclarationStatement* _tmp129_;
		ValaSemanticAnalyzer* _tmp130_;
		ValaSemanticAnalyzer* _tmp131_;
		ValaList* _tmp132_;
		ValaCodeNode* _tmp133_;
		ValaCodeNode* _tmp134_;
		ValaExpression* _tmp135_;
		ValaExpression* _tmp136_;
		_tmp101_ = vala_cast_expression_get_type_reference (self);
		_tmp102_ = _tmp101_;
		_tmp103_ = vala_code_node_get_temp_name ();
		_tmp104_ = _tmp103_;
		_tmp105_ = vala_cast_expression_get_inner (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = vala_local_variable_new (_tmp102_, _tmp104_, NULL, _tmp108_);
		_tmp110_ = _tmp109_;
		_g_free0 (_tmp104_);
		local = _tmp110_;
		_tmp111_ = local;
		_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_declaration_statement_new ((ValaSymbol*) _tmp111_, _tmp113_);
		decl = _tmp114_;
		_tmp115_ = vala_code_context_get_analyzer (context);
		_tmp116_ = _tmp115_;
		_tmp117_ = _tmp116_->insert_block;
		_tmp118_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp117_, (ValaStatement*) _tmp118_);
		_tmp119_ = local;
		_tmp120_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_semantic_analyzer_create_temp_access (_tmp119_, _tmp121_);
		temp_access = _tmp122_;
		_tmp123_ = temp_access;
		_tmp124_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp125_ = _tmp124_;
		vala_expression_set_formal_target_type (_tmp123_, _tmp125_);
		_tmp126_ = local;
		_tmp127_ = vala_cast_expression_get_inner (self);
		_tmp128_ = _tmp127_;
		vala_variable_set_initializer ((ValaVariable*) _tmp126_, _tmp128_);
		_tmp129_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp129_, context);
		_tmp130_ = vala_code_context_get_analyzer (context);
		_tmp131_ = _tmp130_;
		_tmp132_ = _tmp131_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp132_, (ValaCodeNode*) self);
		_tmp133_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp134_ = _tmp133_;
		_tmp135_ = temp_access;
		vala_code_node_replace_expression (_tmp134_, (ValaExpression*) self, _tmp135_);
		_tmp136_ = temp_access;
		result = vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
		_vala_code_node_unref0 (temp_access);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp137_ = vala_cast_expression_get_type_reference (self);
	_tmp138_ = _tmp137_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp138_);
	_tmp139_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp140_ = _tmp139_;
	_tmp141_ = vala_cast_expression_get_inner (self);
	_tmp142_ = _tmp141_;
	_tmp143_ = vala_expression_get_value_type (_tmp142_);
	_tmp144_ = _tmp143_;
	_tmp145_ = vala_data_type_get_value_owned (_tmp144_);
	_tmp146_ = _tmp145_;
	vala_data_type_set_value_owned (_tmp140_, _tmp146_);
	_tmp147_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp148_ = _tmp147_;
	_tmp149_ = vala_cast_expression_get_inner (self);
	_tmp150_ = _tmp149_;
	_tmp151_ = vala_expression_get_value_type (_tmp150_);
	_tmp152_ = _tmp151_;
	_tmp153_ = vala_data_type_get_floating_reference (_tmp152_);
	_tmp154_ = _tmp153_;
	vala_data_type_set_floating_reference (_tmp148_, _tmp154_);
	_tmp155_ = self->priv->_is_silent_cast;
	if (_tmp155_) {
		ValaDataType* _tmp156_;
		ValaDataType* _tmp157_;
		_tmp156_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp157_ = _tmp156_;
		vala_data_type_set_nullable (_tmp157_, TRUE);
	}
	_tmp160_ = vala_code_context_get_profile (context);
	_tmp161_ = _tmp160_;
	if (_tmp161_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp162_;
		ValaExpression* _tmp163_;
		ValaDataType* _tmp164_;
		ValaDataType* _tmp165_;
		_tmp162_ = vala_cast_expression_get_inner (self);
		_tmp163_ = _tmp162_;
		_tmp164_ = vala_expression_get_value_type (_tmp163_);
		_tmp165_ = _tmp164_;
		_tmp159_ = vala_cast_expression_is_gvariant (self, context, _tmp165_);
	} else {
		_tmp159_ = FALSE;
	}
	if (_tmp159_) {
		ValaDataType* _tmp166_;
		ValaDataType* _tmp167_;
		_tmp166_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp167_ = _tmp166_;
		_tmp158_ = !vala_cast_expression_is_gvariant (self, context, _tmp167_);
	} else {
		_tmp158_ = FALSE;
	}
	if (_tmp158_) {
		ValaDataType* _tmp168_;
		ValaDataType* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		gchar* _tmp172_;
		gchar* _tmp173_;
		gboolean _tmp174_;
		_tmp168_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp169_ = _tmp168_;
		vala_data_type_set_value_owned (_tmp169_, TRUE);
		_tmp170_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp171_ = _tmp170_;
		_tmp172_ = vala_data_type_get_type_signature (_tmp171_, NULL);
		_tmp173_ = _tmp172_;
		_tmp174_ = _tmp173_ == NULL;
		_g_free0 (_tmp173_);
		if (_tmp174_) {
			ValaSourceReference* _tmp175_;
			ValaSourceReference* _tmp176_;
			ValaDataType* _tmp177_;
			ValaDataType* _tmp178_;
			gchar* _tmp179_;
			gchar* _tmp180_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp178_ = _tmp177_;
			_tmp179_ = vala_data_type_to_qualified_string (_tmp178_, NULL);
			_tmp180_ = _tmp179_;
			vala_report_error (_tmp176_, "Casting of `GLib.Variant' to `%s' is not supported", _tmp180_);
			_g_free0 (_tmp180_);
		}
	}
	_tmp183_ = vala_code_context_get_profile (context);
	_tmp184_ = _tmp183_;
	if (_tmp184_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp185_;
		ValaExpression* _tmp186_;
		ValaDataType* _tmp187_;
		ValaDataType* _tmp188_;
		_tmp185_ = vala_cast_expression_get_inner (self);
		_tmp186_ = _tmp185_;
		_tmp187_ = vala_expression_get_value_type (_tmp186_);
		_tmp188_ = _tmp187_;
		_tmp182_ = vala_cast_expression_is_gvalue (self, context, _tmp188_);
	} else {
		_tmp182_ = FALSE;
	}
	if (_tmp182_) {
		ValaDataType* _tmp189_;
		ValaDataType* _tmp190_;
		_tmp189_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp190_ = _tmp189_;
		_tmp181_ = !vala_cast_expression_is_gvalue (self, context, _tmp190_);
	} else {
		_tmp181_ = FALSE;
	}
	if (_tmp181_) {
		ValaDataType* _tmp191_;
		ValaDataType* _tmp192_;
		gboolean _tmp193_ = FALSE;
		gboolean _tmp194_ = FALSE;
		ValaDataType* _tmp195_;
		ValaDataType* _tmp196_;
		gboolean _tmp197_;
		gboolean _tmp198_;
		_tmp191_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp192_ = _tmp191_;
		vala_data_type_set_value_owned (_tmp192_, FALSE);
		_tmp195_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp196_ = _tmp195_;
		_tmp197_ = vala_data_type_get_nullable (_tmp196_);
		_tmp198_ = _tmp197_;
		if (_tmp198_) {
			ValaDataType* _tmp199_;
			ValaDataType* _tmp200_;
			ValaTypeSymbol* _tmp201_;
			ValaTypeSymbol* _tmp202_;
			_tmp199_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp200_ = _tmp199_;
			_tmp201_ = vala_data_type_get_type_symbol (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp194_ = _tmp202_ != NULL;
		} else {
			_tmp194_ = FALSE;
		}
		if (_tmp194_) {
			ValaDataType* _tmp203_;
			ValaDataType* _tmp204_;
			ValaTypeSymbol* _tmp205_;
			ValaTypeSymbol* _tmp206_;
			_tmp203_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_data_type_get_type_symbol (_tmp204_);
			_tmp206_ = _tmp205_;
			_tmp193_ = !vala_typesymbol_is_reference_type (_tmp206_);
		} else {
			_tmp193_ = FALSE;
		}
		if (_tmp193_) {
			ValaSourceReference* _tmp207_;
			ValaSourceReference* _tmp208_;
			ValaDataType* _tmp209_;
			ValaDataType* _tmp210_;
			gchar* _tmp211_;
			gchar* _tmp212_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_data_type_to_qualified_string (_tmp210_, NULL);
			_tmp212_ = _tmp211_;
			vala_report_error (_tmp208_, "Casting of `GLib.Value' to `%s' is not supported", _tmp212_);
			_g_free0 (_tmp212_);
		}
	}
	_tmp213_ = vala_cast_expression_get_inner (self);
	_tmp214_ = _tmp213_;
	_tmp215_ = vala_cast_expression_get_inner (self);
	_tmp216_ = _tmp215_;
	_tmp217_ = vala_expression_get_value_type (_tmp216_);
	_tmp218_ = _tmp217_;
	_tmp219_ = vala_data_type_copy (_tmp218_);
	_tmp220_ = _tmp219_;
	vala_expression_set_target_type (_tmp214_, _tmp220_);
	_vala_code_node_unref0 (_tmp220_);
	_tmp221_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp222_ = _tmp221_;
	result = !_tmp222_;
	return result;
}

static gboolean
vala_cast_expression_is_gvariant (ValaCastExpression* self,
                                  ValaCodeContext* context,
                                  ValaDataType* type)
{
	gboolean _tmp0_ = FALSE;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_type_symbol (type);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaSemanticAnalyzer* _tmp6_;
		ValaObjectType* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp3_ = vala_data_type_get_type_symbol (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_analyzer (context);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->gvariant_type;
		_tmp8_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = vala_typesymbol_is_subtype_of (_tmp4_, _tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_cast_expression_is_gvalue (ValaCastExpression* self,
                                ValaCodeContext* context,
                                ValaDataType* type)
{
	gboolean _tmp0_ = FALSE;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp1_ = vala_data_type_get_type_symbol (type);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaSemanticAnalyzer* _tmp6_;
		ValaStructValueType* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		_tmp3_ = vala_data_type_get_type_symbol (type);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_context_get_analyzer (context);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->gvalue_type;
		_tmp8_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = vala_typesymbol_is_subtype_of (_tmp4_, _tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_cast_expression_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_cast_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_cast_expression_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_cast_expression_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCastExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
}

static gboolean
vala_cast_expression_real_is_constant (ValaExpression* base)
{
	ValaCastExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean result;
	self = (ValaCastExpression*) base;
	_tmp0_ = vala_cast_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_constant (_tmp1_);
	return result;
}

static void
vala_cast_expression_class_init (ValaCastExpressionClass * klass,
                                 gpointer klass_data)
{
	vala_cast_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_cast_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCastExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_cast_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_cast_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_cast_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_cast_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_cast_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_cast_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_cast_expression_real_replace_type;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_cast_expression_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_cast_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_cast_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_cast_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_cast_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_cast_expression_real_get_used_variables;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_cast_expression_real_is_constant;
}

static void
vala_cast_expression_instance_init (ValaCastExpression * self,
                                    gpointer klass)
{
	self->priv = vala_cast_expression_get_instance_private (self);
}

static void
vala_cast_expression_finalize (ValaCodeNode * obj)
{
	ValaCastExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_cast_expression_parent_class)->finalize (obj);
}

/**
 * Represents a type cast in the source code.
 */
static GType
vala_cast_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCastExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_cast_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCastExpression), 0, (GInstanceInitFunc) vala_cast_expression_instance_init, NULL };
	GType vala_cast_expression_type_id;
	vala_cast_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaCastExpression", &g_define_type_info, 0);
	ValaCastExpression_private_offset = g_type_add_instance_private (vala_cast_expression_type_id, sizeof (ValaCastExpressionPrivate));
	return vala_cast_expression_type_id;
}

GType
vala_cast_expression_get_type (void)
{
	static volatile gsize vala_cast_expression_type_id__once = 0;
	if (g_once_init_enter (&vala_cast_expression_type_id__once)) {
		GType vala_cast_expression_type_id;
		vala_cast_expression_type_id = vala_cast_expression_get_type_once ();
		g_once_init_leave (&vala_cast_expression_type_id__once, vala_cast_expression_type_id);
	}
	return vala_cast_expression_type_id__once;
}

