 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include "dqnet.h"
#include "dqnet_priv.h"
#include "dqnet_dbg.h"
#include "dqnet_switch.h"

static int dqnet_get_max_ports_noswitch(void)
{
	return 0;
}

static int dqnet_demux_arl_noswitch(struct dqnet_channel *chan,
				    struct fpm_buff *fb)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static struct rtnl_link_stats64 *dqnet_link_stats_noswitch(struct net_device *dev,
		struct rtnl_link_stats64 *stats)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return stats;
}

static int dqnet_get_port_pwr_noswitch(struct net_device *dev,
					      struct dqnet_port_pwr *pwr)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_set_port_pwr_noswitch(struct net_device *dev,
					      struct dqnet_port_pwr *pwr)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_enable_port_noswitch(struct net_device *dev)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_disable_port_noswitch(struct net_device *dev)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_connect_port_noswitch(struct net_device *dev)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_disconnect_port_noswitch(struct net_device *dev)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_get_port_config_noswitch(struct net_device *dev)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_set_port_config_noswitch(struct net_device *dev)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_get_mib_counters_noswitch(struct net_device *dev,
					   struct dqnet_switch_stats *stats)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}

static int dqnet_set_port_stp_state_noswitch(struct net_device *dev,
					     int port, unsigned int state)
{
	pr_err("No switch configured, yet switch function %s called!\n", __func__);
	return -EINVAL;
}


struct dqnet_switch_ops noswitch = {
	.get_max_ports		= dqnet_get_max_ports_noswitch,
	.demux_arl		= dqnet_demux_arl_noswitch,
	.link_stats		= dqnet_link_stats_noswitch,
	.vlan_rx_add_vid	= NULL,
	.vlan_rx_kill_vid	= NULL,
	.get_port_pwr		= dqnet_get_port_pwr_noswitch,
	.set_port_pwr		= dqnet_set_port_pwr_noswitch,
	.enable_port		= dqnet_enable_port_noswitch,
	.disable_port		= dqnet_disable_port_noswitch,
	.connect_port		= dqnet_connect_port_noswitch,
	.disconnect_port	= dqnet_disconnect_port_noswitch,
	.get_port_config	= dqnet_get_port_config_noswitch,
	.set_port_config	= dqnet_set_port_config_noswitch,
	.get_mib_counters	= dqnet_get_mib_counters_noswitch,
	.set_port_stp_state	= dqnet_set_port_stp_state_noswitch
};
