 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef BRCM_BA_PRIV_H
#define BRCM_BA_PRIV_H

#include "brcm_ba_reg_3390a0.h"

#define DEBUG_FS_DIR "brcm_ba" /* Where to put debugfs files */

#define BA_MBOX_REQ_ERROR 0xFFFFFFFF /* Indicate invalid image request to CM */

#if defined(CONFIG_BCM7145)
#define BA_MIN_KVERSION 0x00010005
#define BA_MAX_KVERSION BA_KVERSION
#else
#define BA_MIN_KVERSION 0x00020001
#define BA_MAX_KVERSION BA_KVERSION
#endif

#ifdef CONFIG_BCM_BA_DEBUG
#define MSG_TRACE(level, format, ...) pr_debug(level format, ##__VA_ARGS__)
#define ERR_TRACE(level, format, ...) pr_err(level format, ##__VA_ARGS__)
#define FUNC_TRACE(x) \
	pr_debug(MSG_LEVEL_FUNC_TRACE "%s %s\n", x ? "->" : "<-", __func__)
#define FUNC_TRACEF(x, format, ...) \
	pr_debug(MSG_LEVEL_FUNC_TRACE "%s %s " format, x ? "->" : "<-", \
		__func__, __VA_ARGS__);
#define MSG_TRACEN(...) MSG_TRACE(MSG_LEVEL_NOISE, __VA_ARGS__)
#define MSG_TRACEI(...) MSG_TRACE(MSG_LEVEL_INFO, __VA_ARGS__)
#define MSG_TRACEE(...) ERR_TRACE(MSG_LEVEL_ERROR, __VA_ARGS__)

#define MSG_LEVEL_FUNC_TRACE "[ba:f]"
#define MSG_LEVEL_NOISE "[ba:n]"
#define MSG_LEVEL_INFO "[ba:i]"
#define MSG_LEVEL_ERROR "[ba:e]"
#else   /* #ifdef CONFIG_BCM_BA_DEBUG */
#define ERR_TRACE(format, ...) pr_err(format, ##__VA_ARGS__)
#define FUNC_TRACE(x)
#define FUNC_TRACEF(x, format, ...)
#define MSG_TRACEN(...)
#define MSG_TRACEI(...)
#define MSG_TRACEE(...) ERR_TRACE(__VA_ARGS__)
#endif /* #ifdef CONFIG_BCM_BA_DEBUG */

/**
* enum ba_map_status - Internal flag status
* @MAP_VALID: ARC/ATW has been programmed to registers
* @MAP_PROGRAMMED: Mapping is set via OF
*/
enum ba_map_status {
	MAP_VALID = 1<<0, /**< Map file is valid */
	MAP_PROGRAMMED = 1<<1,  /**< ARC/ATW has been programmed */
};

/**
* enum irq_status - Internal irq status
* @IRQ_IMG_REQ: CM has made a MBOX image request
* @IRQ_STATE_CHANGE: CM, RG, or BMU state has changed
*/
enum irq_status {
	IRQ_IMG_REQ = 1<<0,
	IRQ_STATE_CHANGE = 1<<1,
};

/**
* enum ba_io_idx - Index to device tree register IO memory
* Really only for legacy < v2.1 DT support
*/
enum ba_io_idx {
	IO_MEM_MEMBLOCK,
	IO_MEM_COMM,
	IO_MEM_ATW,
	IO_MEM_RG_TOP,
	IO_MEM_CM_TOP,
	IO_MEM_AON,
	IO_MEM_MEMC0,
	IO_MEM_HIF,
	IO_MEM_OTP,
	IO_MEM_LEAP,
    IO_MEM_LEDS
};

/**
* struct ba_dev_info - Device info
* @pdev: platform device
* @request: CM has made a MBOX request
* @memc_irq: Interrupt #'s for MEMC (ARC usage)
* @arc_enabled: Usage count for ARC's
* @flags: internal state flags
* @irq_stat: IRQ state
* @ba_dev: Device
* @ba_class: Class
* @ba_cdev: Char device
* @map: Memory mapping information (from hard coded, OF, or user)
* @blk: MBOX block xfer information (size, count) (from hard coded, OF, or user)
* @allow_user_map: Allow user specified mapping (yes if not hard coded)
* @status_16: system boot info
* @rg_top: RG TOP registers
* @cm_top: CM TOP registers
* @aon: AON registers
* @memc0: MEMC0 registers
* @memc1: MEMC1 registers
*/
struct ba_dev_info {
	struct platform_device *pdev;
	bool request;
	int memc_irq[MAX_ARC_MEMC];
	u8 arc_enabled[MAX_ARC_MEMC];
	enum ba_map_status flags;
	enum irq_status irq_stat;
	dev_t ba_dev;
	struct class *ba_class;
	struct cdev ba_cdev;
	struct ba_map *map;
	bool allow_user_map;
	u32 otp_regs[2];
	void __iomem *rg_top;
	void __iomem *cm_top;
	void __iomem *aon;
	void __iomem *memc0;
#if MAX_ARC_MEMC > 1
	void __iomem *memc1;
#endif
	void __iomem *leds;
};

#ifdef CONFIG_BCM_BA_PERF

#define MAX_IOCTL_METRIC 200

struct ba_met_ioctl {
	unsigned long jiff;
	unsigned int ioctl;
};

struct ba_metric {
	unsigned long start_jiff;
	struct ba_met_ioctl ioctl[MAX_IOCTL_METRIC];
};

#define METRIC_START do {metrics.start_jiff = jiffies; } while (0)
#define METRIC_IOCTL(x) do {\
	if (ioctlcnt >= MAX_IOCTL_METRIC) \
		continue; \
	metrics.ioctl[ioctlcnt].jiff = jiffies; \
	metrics.ioctl[ioctlcnt].ioctl = x; \
	ioctlcnt++; \
	} while (0)
#else
#define METRIC_START
#define METRIC_IOCTL(x)
#endif

#ifdef CONFIG_BCM_BA_VERBOSE_REG
#define R32(var, reg) do { var = readl_relaxed(reg); \
		pr_debug("%s: 0x%08x\n", #reg, (unsigned int)var);\
		} while (0)
#define W32(reg, val) do { writel_relaxed(val, reg); \
	pr_debug("%s: 0x%08x vs. 0x%08x\n", \
	#reg, (unsigned int)val, (unsigned int)__raw_readl(reg)); } while (0)
#else
#define R32(var, reg) var = readl_relaxed(reg)
#define W32(reg, val) writel_relaxed(val, reg)
#endif
#define RF32(reg, fld) ((readl_relaxed(reg)>>fld##_SHIFT)&fld##_MASK)
#define SRF32(reg, fld) ((reg>>fld##_SHIFT)&fld##_MASK)
#define WF32(reg, fld, val) do { \
	u32 tmp; \
	R32(tmp, reg);  \
	tmp = ((tmp&~(fld##_MASK<<fld##_SHIFT)) | \
	((val&fld##_MASK)<<fld##_SHIFT)); \
	W32(reg, tmp); \
	} while (0)
#define SWF32(reg, fld, val) do { reg = \
	((reg&~(fld##_MASK<<fld##_SHIFT)) | \
	((val&fld##_MASK)<<fld##_SHIFT)); \
	} while (0)

/* TBD... LEAP is ALWAYS HARD CODED to be at the "top" of CM memory */
#define LEAP_BASE(x) (((uintptr_t)x->map->docsis.cm.cm_atw.source + \
		       x->map->docsis.cm.cm_atw.size) - \
		       x->map->docsis.leap.size)

#define BOOT_ROM_BYPASS(x) (x->otp_regs[0] & 0x2)

#define MBOX_LOCK_OWNER_STB 0x42
#define MBOX_LOCK_OWNER_RG 0x41

#endif
