 /****************************************************************************
 *
 * Copyright (c) 2016 Broadcom Ltd.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 *	Authors:Ignatius Cheng <ignatius.cheng@broadcom.com>
 *
 *  Feburary, 2016
 *
 ****************************************************************************/
#include <linux/module.h>
#include <linux/netfilter/x_tables.h>
#include <linux/netfilter/xt_l2ogre_mt.h>
#include <linux/netfilter/xt_l2ogre_tg.h>

MODULE_DESCRIPTION("Xtables: L2oGRE implementation");
MODULE_LICENSE("GPL");
#if IS_ENABLED(CONFIG_IP6_NF_IPTABLES)
MODULE_ALIAS("ip6t_l2ogre");
MODULE_ALIAS("ip6t_L2OGRE");
#endif
MODULE_ALIAS("ipt_l2ogre");
MODULE_ALIAS("ipt_L2OGRE");

static int __init xt_l2ogre_init(void)
{
	int ret;
	ret = xt_l2ogre_mt_init();
	if (ret < 0)
		return ret;
	ret = xt_l2ogre_tg_init();
	if (ret < 0) {
		xt_l2ogre_mt_finish();
		return ret;
	}
	return ret;
}

static void __exit xt_l2ogre_finish(void)
{
	xt_l2ogre_mt_finish();
	xt_l2ogre_tg_finish();
}

module_init(xt_l2ogre_init);
module_exit(xt_l2ogre_finish);
