 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2015-2016 Broadcom. All rights reserved.
 * The term Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef _SFAP_H
#define _SFAP_H

#include <linux/version.h>
#include <linux/skbuff.h>
#include <linux/netdevice.h>
#include "bcmport.h"
#include "sfap_api.h"
#include "bcmnethooks.h"

enum sfap_inf_type {
	sfap_inf_type_lan = 1,
	sfap_inf_type_wan,
};

struct sfap_stats {
	u32 packets;
	u32 bytes;
};

struct sfap_inf {
	int                 type;
	int                 index;
	int                 flags;
	struct net_device   *dev;
	struct sfap_stats  tx_stats;
	struct sfap_stats  rx_stats;
};

#define MAX_LAN_INTERFACES	16
#define MAX_WAN_INTERFACES	2
#define MAX_INTERFACES		(MAX_LAN_INTERFACES + MAX_WAN_INTERFACES)

int sfap_inf_add(int type, char *name);
int sfap_process_packet(struct sk_buff *skb, int len, struct net_device *dev);
int sfap_process_packet_fpm(struct fpm_buff *fpmb, struct net_device *dev);
int sfap_inf_num(void);
void sfap_inf_show(void);
void sfap_inf_stats_clear(struct sfap_inf *inf);
struct sfap_inf *sfap_inf_get_by_index(int idx);
struct sfap_inf *sfap_inf_get_by_dev(struct net_device *dev);
struct sfap_inf *sfap_inf_get_by_dev_ifindex(int ifindex);
struct sfap_inf *sfap_inf_get_by_name(char *name);

struct sfap_flow {
	struct hlist_node   hlist;          /* List node      */
	struct rcu_head     rcu;
	int                 index;          /* Flow ID        */
	int                 hash;           /* Hash Index     */
	struct timespec64   ctime;          /* Create time    */
	struct timespec64   utime;          /* Last Use time  */
	struct flow_params  params;
	struct sfap_stats   stats;
};

long sfap_flow_match_get_mac_cnt(void);
long sfap_flow_match_get_ipv4_cnt(void);
long sfap_flow_match_get_ipv6_cnt(void);
int sfap_flow_get_total(void);
int sfap_flow_get_active(void);
int sfap_flow_get_active_max(void);
void sfap_flow_stats_clear(void);
int sfap_flow_init(int num_flows);
void sfap_flow_exit(void);
struct sfap_flow *sfap_flow_get_by_index(int index);
struct sfap_flow *sfap_flow_free_get_by_index(int index);
int sfap_flow_create(enum flow_type type, int hash);
void sfap_flow_delete(int index);
void sfap_flow_delete_all(void);
void sfap_flow_mainp_pkt_enable(bool enable);
int sfap_flow_mainp_pkt(unsigned char *, int len, struct net_device *dev);

struct sfap_flow *sfap_flow_create_ipv4(__be32 src_ip, __be32 dst_ip,
					  __be16 src_port, __be16 dst_port);
struct sfap_flow *sfap_flow_find_ipv4(u8 ip_prot,
					__be32 src_ip, __be32 dst_ip,
					__be16 src_port, __be16 dst_port);

struct sfap_flow  *sfap_flow_find_ipv6(u8 ip_prot,
					 __be32 *src_ip, __be32 *dst_ip,
					 __be16 src_port, __be16 dst_port);
struct sfap_flow *sfap_flow_create_ipv6(__be32 *src_ip, __be32 *dst_ip,
					  __be16 src_port, __be16 dst_port);

struct sfap_flow *sfap_flow_create_mac_bridge(u8 *src_mac,
					      u8 *dst_mac,
					      int rx_interface);
struct sfap_flow *sfap_flow_find_mac_bridge(u8 *src_mac,
					    u8 *dst_mac,
					    int rx_interface);

int sfap_inf_register_netdevice(char *name);
int sfap_inf_unregister_netdevice(char *name);
void sfap_procfs_init(void);
void sfap_procfs_exit(void);

#endif
