/****************************************************************************
*
* Broadcom Proprietary and Confidential. (c) 2017 Broadcom.  All rights reserved.
* The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
*
* Unless you and Broadcom execute a separate written software license
* agreement governing use of this software, this software is licensed to
* you under the terms of the GNU General Public License version 2 (the
* "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
* the following added to such license:
*
* As a special exception, the copyright holders of this software give you
* permission to link this software with independent modules, and to copy
* and distribute the resulting executable under terms of your choice,
* provided that you also meet, for each linked independent module, the
* terms and conditions of the license of that module. An independent
* module is a module which is not derived from this software. The special
* exception does not apply to any modifications of the software.
*
* Notwithstanding the above, under no circumstances may you combine this
* software in any way with any other Broadcom software provided under a
* license other than the GPL, without Broadcom's express prior written
* consent.
*
****************************************************************************
*
* Filename: sgmiiplus2.h
*
****************************************************************************
* Description: 28nm SGMIIPLUS2 Multi-rate Serdes/PHY core header
* Author: Ravi Patel <ravi.patel@broadcom.com>
****************************************************************************/

#ifndef _SGMIIPLUS2_H
#define _SGMIIPLUS2_H

#include <linux/brcmxcvr.h>

/* Single Serdes Status Register */
#define SGMII0_UNI3_SINGLE_SERDES_STAT	0x00
#define PLL_LOCK_SHIFT					(9)
#define PLL_LOCK_MASK					(1 << PLL_LOCK_SHIFT)
#define SPEED_10M_STATUS_SHIFT			(4)
#define SPEED_10M_STATUS_MASK			(1 << SPEED_10M_STATUS_SHIFT)
#define SPEED_100M_STATUS_SHIFT			(3)
#define SPEED_100M_STATUS_MASK			(1 << SPEED_100M_STATUS_SHIFT)
#define SPEED_1G_STATUS_SHIFT			(2)
#define SPEED_1G_STATUS_MASK			(1 << SPEED_1G_STATUS_SHIFT)
#define SPEED_2P5G_STATUS_SHIFT			(1)
#define SPEED_2P5G_STATUS_MASK			(1 << SPEED_2P5G_STATUS_SHIFT)
#define SPEED_STATUS_MASK				(SPEED_10M_STATUS_MASK | \
										SPEED_100M_STATUS_MASK | \
										SPEED_1G_STATUS_MASK | \
										SPEED_2P5G_STATUS_MASK)

/* Single Serdes Control Register offset and bitfields */
#define SGMII0_UNI3_SINGLE_SERDES_CNTRL	0x04
#define MDIO_ST_SHIFT					(31)
#define MDIO_ST_MASK					(1 << MDIO_ST_SHIFT)
#define SERDES_PRTAD_SHIFT				(21)
#define SERDES_PRTAD_MASK				(0x1F << SERDES_PRTAD_SHIFT)
#define PWRDWN_SHIFT					(14)
#define PWRDWN_MASK						(1 << PWRDWN_SHIFT)
#define IDDQ_SHIFT						(13)
#define IDDQ_MASK						(1 << IDDQ_SHIFT)
#define SGMII_MDIO_EN_SHIFT				(12)
#define SGMII_MDIO_EN_MASK				(1 << SGMII_MDIO_EN_SHIFT)
#define PORT_7_SOURCE_SHIFT				(11)
#define PORT_7_SOURCE_MASK				(1 << PORT_7_SOURCE_SHIFT)
#define RESET_MDIOREGS_SHIFT			(2)
#define RESET_MDIOREGS_MASK				(1 << RESET_MDIOREGS_SHIFT)
#define RESET_PLL_SHIFT					(1)
#define RESET_PLL_MASK					(1 << RESET_PLL_SHIFT)
#define SERDES_RESET_SHIFT				(0)
#define SERDES_RESET_MASK				(1 << SERDES_RESET_SHIFT)

/* sgmiiplus2 device control block */
struct sgmiiplus2 {
	struct brcmphy_core phycore;
	volatile void __iomem *addr;
	struct platform_device *pdev;
	struct device *dev;
	struct device_node *node;
	struct platform_device *mux_pdev;
	const char *mux_select;
	const char *mux_values[2];
	int phyaddr;
	int powerup;
	int extoffset;
};
#endif /* _SGMIIPLUS2_H */
