/*
 * Broadcom oops capture and display (boops)
 *
 * Copyright (C) 2017 Broadcom
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef BOOPS_HEADER_H
#define BOOPS_HEADER_H

#define BOOPS_SIGNATURE                  "BOOPS-DUMP-v1.0"
#define BOOPS_UUID_SIZE                  16
#define BOOPS_UUID_SEGMENT_SIZE          4
#define BOOPS_DATE_SIZE                  20
#define BOOPS_MAX_BUILD_VERSION_LENGTH   64
#define BOOPS_STORAGE_TYPE_LENGTH        16
#define BOOPS_MAX_REASON_LENGTH          16

#define BOOPS_PROC_DIR                   "boops"
#define BOOPS_PROC_UUID                  "current_boot_uuid"
#define BOOPS_PROC_FORCE                 "force_oops"
#define BOOPS_PROC_TEST                  "test_capture"
#define BOOPS_PROC_SEND_LOG              "send_oops_log"
#define BOOPS_PROC_MAX_LOG_LINE_SIZE     1024

#define BOOPS_DATE_SET_YEAR(year)        ((0x1F & ((year) - 2020))  << 26)
#define BOOPS_DATE_SET_MONTH(month)      ((0xF  & (month)) << 22)
#define BOOPS_DATE_SET_DAY(day)          ((0x1F &   (day)) << 17)
#define BOOPS_DATE_SET_HOUR(hour)        ((0x1F &  (hour)) << 12)
#define BOOPS_DATE_SET_MIN(min)          ((0x3F &   (min)) << 6)
#define BOOPS_DATE_SET_SEC(sec)          ((0x3F &   (sec)) << 0)

#define BOOPS_DATE_GET_YEAR(date)       ((0x1F & ((date) >> 26)) + 2020)
#define BOOPS_DATE_GET_MONTH(date)       (0xF  & ((date) >> 22))
#define BOOPS_DATE_GET_DAY(date)         (0x1F & ((date) >> 17))
#define BOOPS_DATE_GET_HOUR(date)        (0x1F & ((date) >> 12))
#define BOOPS_DATE_GET_MIN(date)         (0x3F & ((date) >> 6))
#define BOOPS_DATE_GET_SEC(date)         (0x3F & ((date) >> 0))

struct boops_segment_header_t {
    uint8_t signature[sizeof(BOOPS_SIGNATURE)];                         /* Marker to indicate this an bOoops dump */
    uint8_t uuid[BOOPS_UUID_SEGMENT_SIZE];                              /* Partial UUID to confirm sections are from the same dump  */

    struct {
        uint32_t header;                                                /* The size in bytes of the payload header for this segment */
        uint32_t data;                                                  /* The size in bytes of the payload data for this segment */
        uint32_t total;                                                 /* Total bytes until the start of the next segment */
    } bytes;
};

struct boops_extended_header_t {
    uint8_t uuid[BOOPS_UUID_SIZE];                                      /* UUID of the boot associated with the oops */
    uint8_t build_version[BOOPS_MAX_BUILD_VERSION_LENGTH];              /* Version of software running when the oops happened */
    uint8_t reason[BOOPS_MAX_REASON_LENGTH];                            /* The reason for the dump */
    uint32_t oops_date;                                                 /* Date the opps occurred */
};

struct boops_primary_header_t {
    struct boops_segment_header_t segment_header;
    struct boops_extended_header_t extended_header;
};

#endif //BOOPS_HEADER_H
