/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayesh.patel@broadcom.com>
 ***************************************************************************/

#ifndef _MDQM_DEV_H
#define _MDQM_DEV_H

#include <linux/netdevice.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <proc_cmd.h>
#include "dqm.h"
#include "mdqm.h"

#define MDQM_MODULE_NAME "MDQM"
#define MDQM_MAX_Q  2
#define MDQM_MAX_USER  24
#define MDQM_DEV_NAME  32
#define def_napi_weight 32

enum mdqm_dev_type {
	MDEV_TYPE_NONE = 0,
	MDEV_TYPE_TX,
	MDEV_TYPE_RX_KTHREAD,
	MDEV_TYPE_RX_NAPI,
	MDEV_TYPE_MAX
};

struct mdqm_q_info {
	u8 priority;
	u32 num;
	void *handle;
	u32 count;
	u8 tok_size;
	struct mdqm_dev *mdev;
};

struct mdqm_dev {
	int id;
	int type;
	char name[MDQM_DEV_NAME];
	struct hlist_node	name_hlist;
	struct hlist_node	index_hlist;
	struct list_head	dev_list;
	struct platform_device *pdev;
	struct proc_dir_entry  *proc_dir;
	struct proc_cmd_table  *cmd_tbl;
	struct net_device      napi_dev;
	struct napi_struct     napi;
	spinlock_t             lock;
	wait_queue_head_t      wq;
	struct task_struct     *task;
	atomic_t               pkt_avail;
	int stop_thread;
	struct tasklet_struct  tasklet;
	char dqm_dev[MDQM_DEV_NAME];
	int q_count;
	struct mdqm_q_info q[MDQM_MAX_Q];
	int refcnt;
	struct mdqm_cb cb[MDQM_MAX_USER];
	atomic_t enable;
	int int_mask;
	u32 msgdata[def_napi_weight * DQM_MAX_MSGSZ];
};

int mdqm_parse_dt_node(struct platform_device *pdev);
int mdqm_procfs_init(struct mdqm_dev *mdev);
void mdqm_procfs_exit(struct mdqm_dev *mdev);

#endif
