/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2022 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Broadcom Power Domain RPC interface.
 *
 * Author: Venky Selvaraj <venky.selvaraj@broadcom.com>
 *****************************************************************************/
#ifndef _BRCM_PWR_RPC_H_
#define _BRCM_PWR_RPC_H_


#ifdef __KERNEL__	/* Linux kernel */
#include <linux/bcm_media_gw/itc_rpc/itc_rpc.h>
#include <linux/bcm_media_gw/rpc_services/power_services.h>
#endif

#define PWR_DOMAINS_MAX 256
#define BATT_STATE_SHIFT	2
#define BATT_STATE_MASK		(0x03 << BATT_STATE_SHIFT)
#define BATT_STATE(x) (((x)&BATT_STATE_MASK)>>BATT_STATE_SHIFT) /* Get Battery state from u32 */
#define BATT_STATE_AC	(BS_AC << BATT_STATE_SHIFT)
#define DT_BOOT_STATE_BATTERY_STR "battery"
enum {
	PWR_GET_DOMAIN_ID,
	PWR_GET_DOMAIN_NAME,
	PWR_GET_DOMAIN_STATE,
	PWR_SET_DOMAIN_STATE,
	PWR_ASYNC_GET_DOMAIN_STATE,
	PWR_ASYNC_SET_DOMAIN_STATE,
	PWR_ASYNC_COMPLETE,
	MAX_PWR_FUNC,
};

/* Notify state change on mbox to other register driver */
enum brcm_pwr_mbox_event {
	PWR_MBOX_CHANGE_EVENT,
	PWR_MAX_MBOX_EVENTS
};

/* Defines for understanding which MBOX is which */
enum brcm_pwr_rpc_mbox_id {
	PWR_MBOX_BS = 0,
	PWR_MBOX_MAX
};

/* Power state as reported by the SMC. As defined by spec */
enum brcm_pwr_rpc_battery_state {
	BS_UNKNOWN,
	BS_AC,
	BS_BATTERY,
};

/* MBOX/Run states of various parts of the system */
struct brcm_pwr_rpc_mbox_info {
	__u32 mbox[PWR_MBOX_MAX]; /* MBOX data */
	__u16 mask; /* Which MBOX's are "new" */
	bool delay_battery_mode;
};

/*
 * Pwr Domain service
 * W1: | 31..24 | 23..18 | 17..16 | 15..8  |  7..0  |
 *     |   RC   |  RSVD  |  RESET | State  | DOM ID |
 *
 * W2: | 31..0 |
 *     |  RSVD |
 *
 * W3: | 31..0 |
 *     |  RSVD |
 *
 * RSVD:	Reserved
 * RESET:	0: Deasserted, 1: Asserted
 * State:	Domain's power state
 * DOM ID:	Power Domain ID
 */

static inline u8 pwr_msg_get_retcode(rpc_msg *msg)
{
	return ((msg->data[0] >> 24) & 0xff);
}
static inline void pwr_msg_set_retcode(rpc_msg *msg, u8 v)
{
	msg->data[0] = (msg->data[0] & ~(0xff << 24)) | (v << 24);
}
static inline u8 pwr_msg_get_domain_id(rpc_msg *msg)
{
	return ((msg->data[0]) & 0xff);
}
static inline u8 pwr_msg_get_domain_state(rpc_msg *msg)
{
	return ((msg->data[0]>>8) & 0xff);
}
static inline u8 pwr_msg_get_domain_reset(rpc_msg *msg)
{
	return (msg->data[0]>>16) & 0x3;
}
static inline void pwr_msg_set_domain_state(rpc_msg *msg, u8 v)
{
	msg->data[0] = (msg->data[0] & ~(0xff << 8)) | (v << 8);
}
static inline void pwr_msg_set_domain_reset(rpc_msg *msg, u8 v)
{
	msg->data[0] = (msg->data[0] & ~(0x3 << 16)) | ((v & 0x3) << 16);
}
static inline void pwr_msg_set_domain_id(rpc_msg *msg, u8 v)
{
	msg->data[0] = (msg->data[0] & ~(0xff)) | (v);
}

static inline char *pwr_mbox_to_string(int mbox)
{
	switch (mbox) {
	case PWR_MBOX_BS:
		return "BS state";
	default:
		break;
	}
	return "Unknown/Invalid";
}

static inline char *pwr_battery_state_to_string(enum brcm_pwr_rpc_battery_state state)
{
	switch (state) {
	case BS_UNKNOWN:
		return "Unknown";
	case BS_AC:
		return "AC Power";
	case BS_BATTERY:
		return "Battery";
	default:
		break;
	}
	return "Invalid";
}
void brcm_pwr_rpc_get_boot_state(const char **str);
void brcm_pwr_rpc_get_delay_batt_mode(bool *state);

int brcm_pwr_rpc_mbox_register_notifier(struct notifier_block *nb);
int brcm_pwr_rpc_mbox_unregister_notifier(struct notifier_block *nb);
int brcm_pwr_rpc_mbox_get_state(struct brcm_pwr_rpc_mbox_info *state);

int brcm_pwr_rpc_register_domain(char *name);
void brcm_pwr_rpc_unregister_domain(int id);
int brcm_pwr_rpc_set_domain_state(char *name, int state, int reset);
int brcm_pwr_rpc_get_domain_state(char *name, int *state, int *reset);
typedef void (*pwr_rpc_cb_func)(int, void *, void *);
int brcm_pwr_rpc_get_domain_state_atomic(int dom_id, pwr_rpc_cb_func cb_func);
int brcm_pwr_rpc_set_domain_state_atomic(int dom_id, int state, int reset,
		pwr_rpc_cb_func cb_func);
bool brcm_pwr_rpc_is_registered_domain_turned_off(int id);
#endif //_BRCM_PWR_RPC_H_
