 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2015-2016 Broadcom. All rights reserved.
 * The term Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include "sfap.h"

static
int sfap_flow_add_ipv4(struct flow_ipv4_params *params,
		       struct flow_tx_params *tx_params, int *flow_id)
{
	struct sfap_flow  *flow;
	struct sfap_inf *inf;
	flow = sfap_flow_find_ipv4(params->ip_prot,
				   params->src_ip,
				   params->dst_ip,
				   params->src_port,
				   params->dst_port);
	if (flow) {
		/* Flow exist */
		*flow_id = flow->index+1;
		return 0;
	}
	/* Flow does not exist */
	inf = sfap_inf_get_by_dev_ifindex(tx_params->interface);
	if (!inf)
		return -2;
	flow = sfap_flow_create_ipv4(params->src_ip,
				     params->dst_ip,
				     params->src_port,
				     params->dst_port);
	if (!flow)
		return -1;
	/* New flow created */
	flow->params.ipv4 = *params;
	flow->params.tx = *tx_params;
	flow->params.tx.interface = inf->index;
	*flow_id = flow->index+1;
	return 0;
}

static
int sfap_flow_add_ipv6(struct flow_ipv6_params *params,
		       struct flow_tx_params *tx_params, int *flow_id)
{
	struct sfap_flow  *flow;
	struct sfap_inf *inf;
	flow = sfap_flow_find_ipv6(params->ip_prot,
				   params->src_ip,
				   params->dst_ip,
				   params->src_port,
				   params->dst_port);
	if (flow) {
		/* Flow exist */
		*flow_id = flow->index+1;
		return 0;
	}
	/* Flow does not exist */
	inf = sfap_inf_get_by_dev_ifindex(tx_params->interface);
	if (!inf)
		return -2;
	flow = sfap_flow_create_ipv6(params->src_ip,
				     params->dst_ip,
				     params->src_port,
				     params->dst_port);
	if (!flow)
		return -1;
	/* New flow created */
	flow->params.ipv6 = *params;
	flow->params.tx = *tx_params;
	flow->params.tx.interface = inf->index;
	*flow_id = flow->index+1;
	return 0;
}

static
int sfap_flow_add_mc(struct flow_mc_params *params,
		     struct flow_tx_params *tx_params, int *flow_id)
{
	return 0;
}

static
int sfap_flow_add_br(struct flow_mac_bridge_params *params,
		     struct flow_tx_params *tx_params, int *flow_id)
{
	struct sfap_flow  *flow;
	struct sfap_inf *inf;
	inf = sfap_inf_get_by_dev_ifindex(params->rx_interface);
	if (inf == NULL)
		return -1;
	flow = sfap_flow_find_mac_bridge(params->mac_src,
					 params->mac_dst,
					 params->rx_interface);
	if (flow) {
		/* Flow exist */
		*flow_id = flow->index+1;
		return 0;
	}
	/* Flow does not exist */
	inf = sfap_inf_get_by_dev_ifindex(tx_params->interface);
	if (!inf)
		return -2;
	flow = sfap_flow_create_mac_bridge(params->mac_src,
					   params->mac_dst,
					   params->rx_interface);
	if (!flow)
		return -1;
	/* New flow created */
	flow->params.mac_bridge = *params;
	flow->params.tx = *tx_params;
	flow->params.tx.interface = inf->index;
	*flow_id = flow->index+1;
	return 0;
}

int sfap_flow_add(void *ptr, int *flow_id)
{
	int ret = 0;
	struct flow_params *params;
	params = (struct flow_params *)ptr;
	switch (params->type) {
	case ft_ipv4:
		ret = sfap_flow_add_ipv4(&params->ipv4,
					 &params->tx,
					 flow_id);
		break;
	case ft_ipv6:
		ret = sfap_flow_add_ipv6(&params->ipv6,
					 &params->tx,
					 flow_id);
		break;
	case ft_mac_bridge:
		ret = sfap_flow_add_br(&params->mac_bridge,
				       &params->tx,
				       flow_id);
		break;
	case ft_multicast:
		ret = sfap_flow_add_mc(&params->multicast,
				       &params->tx,
				       flow_id);
		break;
	default:
		break;
	}
	return ret;
}
EXPORT_SYMBOL(sfap_flow_add);

int sfap_flow_remove(int flow_id)
{
	sfap_flow_delete(flow_id-1);
	return 0;
}
EXPORT_SYMBOL(sfap_flow_remove);

int sfap_flow_get_counter(int flow_id, u32 *packets, u32 *bytes, bool reset)
{
	struct sfap_flow *flow = sfap_flow_get_by_index(flow_id-1);
	if (flow) {
		*packets = flow->stats.packets;
		*bytes = flow->stats.bytes;
		if (reset) {
			flow->stats.packets = 0;
			flow->stats.bytes = 0;
		}
		return 0;
	}
	return -1;
}
EXPORT_SYMBOL(sfap_flow_get_counter);
int sfap_config(struct flow_net_config *pri_params,
		struct flow_net_config *sec_params)
{
	return 0;
}
EXPORT_SYMBOL(sfap_config);
extern int sfap_master_enable;
int sfap_enable(bool enable)
{
	sfap_flow_mainp_pkt_enable(enable);
	sfap_master_enable = enable;
	return 0;
}
EXPORT_SYMBOL(sfap_enable);
