#!/bin/sh
enable=0
AA_DEFAULT=/etc/apparmor/apparmor_defaults
AAR_ENTRY_CNT=/tmp/aar_marker.txt
AAR_MESG_LOG=/tmp/aar_msg.txt
ACTIVE_PROFILES=`cat /sys/kernel/security/apparmor/profiles`
loop_time=3600
source /etc/utopia/service.d/log_env_var.sh
if [ ! -z "$ACTIVE_PROFILES" ]; then
     enable=1
fi
while [ $enable -eq 1 ]
do
   nice -n 19 journalctl -k --since "${loop_time} sec ago" > ${AAR_MESG_LOG}
   while read line; do
         profile=`echo $line | cut -d : -f1`
         count=`cat $AAR_MESG_LOG | grep profile | grep $profile | wc -l`;
         if [ "$profile" = "global" ]; then
               line=:$count
         else
               line=,$count
         fi
         echo -n $line >> $AAR_ENTRY_CNT
   done  < $AA_DEFAULT
   echo -n -e "`date "+%Y-%m-%dT%T.%3NZ"` APPARMOR_ENTRY_COUNT`cat $AAR_ENTRY_CNT`\n" >> ${DMESG_FILE}
   rm -f ${AAR_MESG_LOG}
   rm -f ${AAR_ENTRY_CNT}
   sleep $loop_time
done
