#!/bin/sh
#
# Copyright 2020 Comcast Cable Communications Management, LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# SPDX-License-Identifier: Apache-2.0
#

if [[ "${MODEL_NUM}" == "TG3482G" || "${MODEL_NUM}" == "CGM4140COM" || "${MODEL_NUM}" == "CGM4331COM" || "${MODEL_NUM}" == "CGM4981COM" ||  "$MODEL_NUM" == "CGM601TCOM" || "$MODEL_NUM" == "SG417DBCT" || "${MODEL_NUM}" == "TG4482A" || "${MODEL_NUM}" == "CGA4332COM" || "${MODEL_NUM}" == "SCER11BEL" || "${MODEL_NUM}" == "VTER11QEL" ]]; then
    SYSCFG_DB_FILE="/nvram/secure/data/syscfg.db"
    SYSCFG_DB_OVS="mesh_ovs_enable"
else
    echo "ERROR: Unknown model number ${MODEL_NUM}"
    exit 1
fi

if [[ "${MODEL_NUM}" == "TG3482G" || "${MODEL_NUM}" == "TG4482A" ]]; then
    echo "Enabled rng-tools for AXB6/CMXB7. Starting rng-tools on ${MODEL_NUM}..."
    /usr/sbin/rngd -b -o /dev/random
    echo "rng-tools started"
    exit 0
fi

if [ ! -f ${SYSCFG_DB_FILE} ]; then
    echo "ERROR: ${SYSCFG_DB_FILE} does not exist on ${MODEL_NUM}"
    exit 1
elif [ "`cat ${SYSCFG_DB_FILE} | grep -i ${SYSCFG_DB_OVS} | cut -d"=" -f2`" != "true" ] &&
     [ "$OneWiFiEnabled" != "true" ] && [ ! -f /etc/WFO_enabled ]; then
    echo "${SYSCFG_DB_OVS} is disabled. Disabling rng-tools on ${MODEL_NUM}..."
    exit 0
else
    echo "${SYSCFG_DB_OVS} is enabled. Starting rng-tools on ${MODEL_NUM}..."
    /usr/sbin/rngd -b -o /dev/random
    echo "rng-tools started"
fi
