/****************************************************************************
 *
 * Copyright (c) 2015-2018 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ***************************************************************************/

#ifndef __FLOWMGR_FAP_H
#define __FLOWMGR_FAP_H
#include <net/netfilter/nf_conntrack_core.h>
#include <net/netfilter/nf_conntrack_offload.h>
#include <linux/fs.h>
#include "bcmflow.h"

int flowmgr_promote(int dir, int prot, int pri,
		    struct nf_conn *ct,
		    struct nf_bridge_info *nf_bridge,
		    struct nf_conntrack_tuple *tuple_match,
		    struct nf_conntrack_tuple *tuple_replacement,
		    bool tuple_replacement_use_dst,
		    struct offload_info *ct_offload_info);

int flowmgr_flow_add(struct flow_params *params,
		     int *flow_id,
		     struct offload_info *ct_offload_info);
int flowmgr_flow_remove(struct offload_info *ct_offload_info, int flow_id);

int flowmgr_promote_mcast(struct flowmgr_mdb_entry *mdb,
			  int oif);
int flowmgr_demote_mcast(struct flowmgr_mdb_entry *mdb,
			 int oif);
int flowmgr_expected_promote(int dir, int prot,
			     struct nf_conn *ct,
			     struct nf_conntrack_tuple *tuple_match,
			     int ctdir,
			     struct offload_info *ct_offload_info);
void flowmgr_expected_demote(struct offload_info *ct_offload_info);
void flowmgr_demote(struct nf_conn *ct, struct nf_conn_offload *ct_offload);
void flowmgr_demote_single(struct nf_conn *ct, struct nf_conn_offload *ct_offload, int direction);
void flowmgr_update_stats(const struct nf_conn *ct);

int flowmgr_config_dslite(struct flow_dslite_tunnel_params *param, int oindex);
int flowmgr_unconfig_dslite(int id);
int flowmgr_config_gre(struct flow_gre_tunnel_params *param, int oindex);
int flowmgr_unconfig_gre(int id);
int flowmgr_config_mapt(struct flow_mapt_params *param, int oindex);
int flowmgr_unconfig_mapt(int id);
int flowmgr_config(char *pri_lan_dev_name, char *wan_dev_name,
		   char *sec_lan_dev_name);

void flowmgr_procfs_init(void);
void flowmgr_procfs_exit(void);
void flowmgr_fap_dbg_show(struct seq_file *s);
int flowmgr_fap_flows_active(void);
void flowmgr_nfct_dbg_show(struct seq_file *s);
void flowmgr_update_ct_offload(int flow_id, int flow_type, int lag,
				struct nf_conntrack_tuple *tuple_match,
				struct offload_info *ct_offload_info,
				struct nf_conn_offload *ct_offload,
				struct nf_conn_offload *ct_offload_master);
void flowmgr_dump_ipv4(char *label, int mark,
		       struct offload_info *info,
		       struct flow_ipv4_params *params);
void flowmgr_dump_ipv6(char *label, int mark,
		       struct offload_info *info,
		       struct flow_ipv6_params *params);
char *flowmgr_get_directions(int index);
int flowmgr_get_mcast_conters(struct flowmgr_mdb_entry *mdb);
#endif
