/****************************************************************************
 *
 * Copyright (c) 2010-2012 Broadcom Corporation
 *
 * This program is the proprietary software of Broadcom Corporation and/or
 * its licensors, and may only be used, duplicated, modified or distributed
 * pursuant to the terms and conditions of a separate, written license
 * agreement executed between you and Broadcom (an "Authorized License").
 * Except as set forth in an Authorized License, Broadcom grants no license
 * (express or implied), right to use, or waiver of any kind with respect to
 * the Software, and Broadcom expressly reserves all rights in and to the
 * Software and all intellectual property rights therein.  IF YOU HAVE NO
 * AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS SOFTWARE IN ANY WAY,
 * AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL USE OF THE
 * SOFTWARE.
 *
 * Except as expressly set forth in the Authorized License,
 *
 * 1.     This program, including its structure, sequence and organization,
 * constitutes the valuable trade secrets of Broadcom, and you shall use all
 * reasonable efforts to protect the confidentiality thereof, and to use this
 * information only in connection with your use of Broadcom integrated circuit
 * products.
 *
 * 2.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED
 * "AS IS" AND WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS
 * OR WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH
 * RESPECT TO THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMS ANY AND ALL
 * IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR
 * A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET
 * ENJOYMENT, QUIET POSSESSION OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME
 * THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE OF THE SOFTWARE.
 *
 * 3.     TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM
 * OR ITS LICENSORS BE LIABLE FOR (i) CONSEQUENTIAL, INCIDENTAL, SPECIAL,
 * INDIRECT, OR EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY
 * RELATING TO YOUR USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN
 * EXCESS OF THE AMOUNT ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1,
 * WHICHEVER IS GREATER. THESE LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY
 * FAILURE OF ESSENTIAL PURPOSE OF ANY LIMITED REMEDY.
 *
 *******************************************************************************
 *
 * itc_rpc.h
 * Peter Sulc
 *
 *******************************************************************************/

#ifndef _ITC_RPC_H_
#define _ITC_RPC_H_

#include <linux/bcm_media_gw/itc_rpc/itc_msg_defs.h>
#include <linux/bcm_media_gw/itc_rpc/itc_channel_defs.h>

static inline void rpc_msg_init_header(rpc_msg *msg,
				       int service,
				       int function,
				       int version)
{
	msg->header = RPC_MSG_MAKE_HEADER(version, 0, 0, service, function, 1);
}

static inline void rpc_msg_init(rpc_msg *msg,
				int service,
				int function,
				int version,
				uint32_t data0,
				uint32_t data1,
				uint32_t data2)
{
	msg->header = RPC_MSG_MAKE_HEADER(version, 0, 0, service, function, 1);
	msg->data[0] = data0;
	msg->data[1] = data1;
	msg->data[2] = data2;
}

/*
 * get an ID for a named DQM tunnel
 * multiple clients may simultaneously use the same tunnel
 * name must be NULL terminated
 * returns -1 if tunnel does not exist
 */
int rpc_get_fifo_tunnel_id(char *name);

/*
 * functions used by the service handler to handle incoming messages/requests
 * the rpc_msg * memory is owned and maintained by ItcRpc
 */

typedef int (*rpc_rx_handler)(int tunnel, rpc_msg *msg);

typedef struct {
	rpc_rx_handler func;
	int version;
} rpc_function;

/*
 * service function table that is an
 * array of function pointers that correspond to the function indexes
 * you have defined somewhere in your code.
 */

int rpc_register_functions(int service,
			   rpc_function *func_table,
			   int func_cnt);

/*
 * register a single function
 * must be done after you have rpc_register_functions()
 * this is useful when you have a function in a module
 * that will be loaded later than the rpc_register_functions()
 */
int rpc_register_function(int service,
			  int function,
			  rpc_function *func);

/*
 * unregister a previously registered service function table
 */
int rpc_unregister_functions(int service);

/*
 * unregister a previously registered service function
 */
int rpc_unregister_function(int service, int function);

/*
 * Reply to message.
 * Used by request handler.
 * If you are replying to a message from your service callback function
 * you MUST use this because this api will set the reply
 * bit so that the other side can do the right thing.
 */
int rpc_send_reply(int tunnel, rpc_msg *msg);

/*
 * functions used to send messages
 */

/* wait for response
 * rpc_send_request cannot be used in one of your callback functions
 * on the service side. There you can only use rpc_send_reply, or
 * rpc_send_message.
 * Ideally your callback funtion would only send rpc_send_reply
 * or nothing at all.
 */
int rpc_send_request(int tunnel, rpc_msg *msg);
int rpc_send_request_timeout(int tunnel, rpc_msg *msg, int sec);

/*
 * do not wait for response
 * will block if wait_for_link is true and the tunnel has not completed init
 * do not use this to reply to a message, use rpc_send_reply
 */
int rpc_send_message(int tunnel, rpc_msg *msg, bool wait_for_link);

/* convenience functions */

static inline int rpc_send_requesta(int tunnel,
				    int service,
				    int function,
				    int version,
				    uint32_t *data0,
				    uint32_t *data1,
				    uint32_t *data2)
{
	int rc;
	rpc_msg msg;
	rpc_msg_init(&msg, service, function, version, *data0, *data1, *data2);
	rc = rpc_send_request(tunnel, &msg);
	if (rc == 0)
	{
		*data0 = msg.data[0];
		*data1 = msg.data[1];
		*data2 = msg.data[2];
	}
	return rc;
}

static inline int rpc_send_messagea(int tunnel,
				    int service,
				    int function,
				    int version,
				    uint32_t data0,
				    uint32_t data1,
				    uint32_t data2)
{
	rpc_msg msg;
	rpc_msg_init(&msg, service, function, version, data0, data1, data2);
	return rpc_send_message(tunnel, &msg, true);
}

/* debug */
void rpc_dump_msg(rpc_msg *msg);

/* init everything */
int rpc_init(void);
int rpc_uninit(void);
void rpc_cleanup(void);

#endif
