/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2023 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Peter Sulc <peter.sulc@broadcom.com>
 *****************************************************************************/

#include <linux/types.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/io.h>
#include <linux/bitops.h>

#include "dqm.h"
#include "dqm_dev.h"
#include "dqm_hw.h"

#if defined(CONFIG_KASAN) || defined(CONFIG_FTRACE) || defined(CONFIG_FRAME_POINTER)

void dqm_set_rx(struct dqm *q)
{
	q->rx = dqm_generic_rx;
}

#else

/* arm32 multiword burst instructions */

#define LDM_2(addr) \
	__asm__("ldm   %0, {%1, %2}" \
		: "=r" (addr), "=r" (a0), "=r" (a1) \
		: "0" (addr))

#define LDM_3(addr) \
	__asm__("ldm   %0, {%1, %2, %3}" \
		: "=r" (addr), "=r" (a0), "=r" (a1), "=r" (a2) \
		: "0" (addr))

#define LDM_4(addr) \
	__asm__("ldm   %0, {%1, %2, %3, %4}" \
		: "=r" (addr), "=r" (a0), "=r" (a1), "=r" (a2), "=r" (a3) \
		: "0" (addr))

#define LDM_5(addr) \
	__asm__("ldm   %0, {%1, %2, %3, %4, %5}" \
		: "=r" (addr), \
		  "=r" (a0), "=r" (a1), "=r" (a2), "=r" (a3), "=r" (a4) \
		: "0" (addr))

#define LDM_6(addr) \
	__asm__("ldm   %0, {%1, %2, %3, %4, %5, %6}" \
		: "=r" (addr), \
		  "=r" (a0), "=r" (a1), "=r" (a2), "=r" (a3),	\
		  "=r" (a4), "=r" (a5) \
		: "0" (addr))

#define LDM_7(addr) \
	__asm__("ldm   %0, {%1, %2, %3, %4, %5, %6, %7}" \
		: "=r" (addr), \
		  "=r" (a0), "=r" (a1), "=r" (a2), "=r" (a3),	\
		  "=r" (a4), "=r" (a5), "=r" (a6) \
		: "0" (addr))

#define LDM_8(addr) \
	__asm__("ldm   %0, {%1, %2, %3, %4, %5, %6, %7, %8}" \
		: "=r" (addr), \
		  "=r" (a0), "=r" (a1), "=r" (a2), "=r" (a3),	\
		  "=r" (a4), "=r" (a5), "=r" (a6), "=r" (a7)	\
		: "0" (addr))

static inline void read1(u32 *reg, u32 *data)
{
	u32 val = __raw_readl(reg);

	data[0] = val;
}

static inline void read2(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	LDM_2(reg);
	data[0] = a0;
	data[1] = a1;
}

static inline void read3(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	register unsigned int a2 __asm__("r6");
	LDM_3(reg);
	data[0] = a0;
	data[1] = a1;
	data[2] = a2;
}

static inline void read4(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	register unsigned int a2 __asm__("r6");
	register unsigned int a3 __asm__("r7");
	LDM_4(reg);
	data[0] = a0;
	data[1] = a1;
	data[2] = a2;
	data[3] = a3;
}

static inline void read5(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	register unsigned int a2 __asm__("r6");
	register unsigned int a3 __asm__("r7");
	register unsigned int a4 __asm__("r8");
	LDM_5(reg);
	data[0] = a0;
	data[1] = a1;
	data[2] = a2;
	data[3] = a3;
	data[4] = a4;
}

static inline void read6(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	register unsigned int a2 __asm__("r6");
	register unsigned int a3 __asm__("r7");
	register unsigned int a4 __asm__("r8");
	register unsigned int a5 __asm__("r9");
	LDM_6(reg);
	data[0] = a0;
	data[1] = a1;
	data[2] = a2;
	data[3] = a3;
	data[4] = a4;
	data[5] = a5;
}

static inline void read7(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	register unsigned int a2 __asm__("r6");
	register unsigned int a3 __asm__("r7");
	register unsigned int a4 __asm__("r8");
	register unsigned int a5 __asm__("r9");
	register unsigned int a6 __asm__("r10");
	LDM_7(reg);
	data[0] = a0;
	data[1] = a1;
	data[2] = a2;
	data[3] = a3;
	data[4] = a4;
	data[5] = a5;
	data[6] = a6;
}

static inline void read8(u32 *reg, u32 *data)
{
	register unsigned int a0 __asm__("r4");
	register unsigned int a1 __asm__("r5");
	register unsigned int a2 __asm__("r6");
	register unsigned int a3 __asm__("r7");
	register unsigned int a4 __asm__("r8");
	register unsigned int a5 __asm__("r9");
	register unsigned int a6 __asm__("r10");
	register unsigned int a7 __asm__("r11");
	LDM_8(reg);
	data[0] = a0;
	data[1] = a1;
	data[2] = a2;
	data[3] = a3;
	data[4] = a4;
	data[5] = a5;
	data[6] = a6;
	data[7] = a7;
}

static inline int arm32_rx(u32 *reg, int messages, int msg_size, u32 *data)
{
	int left = messages;

	while (left) {
		int words = left * msg_size;
		int count = left;

		if (words > 8) {
			if (unlikely(msg_size == 3)) {
				words = 6;
				count = 2;
			} else {
				words = 8;
				/* (8 / msg_size) optimized for
				 * msg_size 1,2, or 4
				 */
				BUG_ON(msg_size > 4);
				count = 8 >> (msg_size >> 1);
			}
		}
		switch (words) {
		case 1:
			read1(reg, data);
			break;
		case 2:
			read2(reg, data);
			break;
		case 3:
			read3(reg, data);
			break;
		case 4:
			read4(reg, data);
			break;
		case 5:
			read5(reg, data);
			break;
		case 6:
			read6(reg, data);
			break;
		case 7:
			read7(reg, data);
			break;
		case 8:
			read8(reg, data);
			break;
		}
		left -= count;
		data += words;
	}
	return messages;
}

static int dqm_arm32_rx(struct dqm *q, int messages, u32 *data)
{
	return arm32_rx(q->data, messages, q->msg_size, data);
}

void dqm_set_rx(struct dqm *q)
{
	q->rx = dqm_arm32_rx;
}

#endif
