 /****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#include <linux/kernel.h>
#include <linux/proc_fs.h>
#include <linux/if_link.h>
#include <linux/netdevice.h>
#include <linux/module.h>
#include <linux/bcm_media_gw/msgfifo.h>
#include "dqnet_priv.h"
#include "dqnet_fap.h"
#include "fpm.h"

#if defined(CONFIG_BCM_RUNNER)
extern struct dqnet_fap_ops dqnet_rfap;
#else
extern struct dqnet_fap_ops dqnet_gfap;
#endif

static struct dqnet_fap_ops *fap = NULL;

void dqnet_getsym_fap_ops(void)
{
#if defined(CONFIG_BCM_RUNNER)
	fap = symbol_get(dqnet_rfap);
#else
	fap = symbol_get(dqnet_gfap);
#endif
}

void dqnet_putsym_fap_ops(void)
{
#if defined(CONFIG_BCM_RUNNER)
	symbol_put(dqnet_rfap);
#else
	symbol_put(dqnet_gfap);
#endif
}

int dqnet_fap_init_system(void)
{
	if (fap)
		return fap->init_system();
	else
		return 0;
}

int dqnet_fap_exit_system(void)
{
	if (fap && fap->exit_system)
		return fap->exit_system();
	else
		return 0;
}

int dqnet_fap_init_port(struct net_device *dev)
{
	if (fap)
		return fap->init_port(dev);
	else
		return 0;
}

int dqnet_fap_exit_port(struct net_device *dev)
{
	if (fap && fap->exit_port)
		return fap->exit_port(dev);
	else
		return 0;
}

int dqnet_fap_get_tx_prio(struct net_device *dev, int *prio)
{
	if (fap)
		return fap->get_tx_prio(dev, prio);
	else {
		*prio = 0;
		return 0;
	}
}

int dqnet_fap_get_tx_q_type(struct net_device *dev,
			    enum dqnet_q_type *q_type)
{
	if (fap)
		return fap->get_tx_q_type(dev, q_type);
	else {
		*q_type = DQNET_QUEUE_US;
		return 0;
	}
}

void dqnet_fap_get_stats(struct net_device *dev,
			 struct rtnl_link_stats64 *stats)
{
	if (fap)
		fap->link_stats(dev, stats);
	else {
		netdev_err(dev, "No FAP available, yet ");
		netdev_err(dev, "dqnet_fap_get_stats called!\n");
	}
}

void dqnet_fap_clr_stats(struct net_device *dev)
{
	if (fap)
		fap->link_stats(dev, NULL);
	else {
		netdev_err(dev, "No FAP available, yet ");
		netdev_err(dev, "dqnet_fap_clr_stats called!\n");
	}
}

struct rtnl_link_stats64 *dqnet_fap_link_stats(struct net_device *dev,
		struct rtnl_link_stats64 *stats)
{
	if (stats)
		dqnet_fap_get_stats(dev, stats);
	else
		dqnet_fap_clr_stats(dev);

	return stats;
}

int dqnet_fap_add_tag(struct net_device *dev, struct fpm_buff *fb)
{
	if (fap)
		return fap->add_tag(dev, fb);
	else
		return 0;
}
EXPORT_SYMBOL(dqnet_fap_add_tag);

int dqnet_fap_get_tag_len(struct net_device *dev)
{
	if (fap)
		return fap->get_tag_len(dev);
	else
		return 0;
}
EXPORT_SYMBOL(dqnet_fap_get_tag_len);

int dqnet_fap_set_imp_lag_port(struct net_device *dev,
			       int port, int assign)
{
	if (fap && fap->set_imp_lag_port)
		return fap->set_imp_lag_port(dev, port, assign);
	else
		return 0;
}
EXPORT_SYMBOL(dqnet_fap_set_imp_lag_port);

int dqnet_fap_set_wan(struct dqnet_netdev *ndevs,
		      char *ifname, int enable)
{
	if (fap && fap->set_wan)
		return fap->set_wan(ndevs, ifname, enable);
	else
		return 0;
}
EXPORT_SYMBOL(dqnet_fap_set_wan);

int dqnet_fap_balance_imp_lag_ports(struct dqnet_netdev *ndevs, int action,
				    int poi)
{
	if (fap && fap->balance_imp_lag_port)
		return fap->balance_imp_lag_port(ndevs, action, poi);
	else
		return 0;
}
EXPORT_SYMBOL(dqnet_fap_balance_imp_lag_ports);

int dqnet_fap_get_wifi_idx(struct dqnet_netdev *ndev)
{
	if (fap && fap->get_wifi_idx)
		return fap->get_wifi_idx(ndev);
	else
		return 0;
}
EXPORT_SYMBOL(dqnet_fap_get_wifi_idx);

int dqnet_fap_get_q_info(struct net_device *dev,
			 struct dqnet_channel *chan)
{
	if (fap && fap->get_q_info)
		return fap->get_q_info(dev, chan);
	else {
		return 0;
	}
}
EXPORT_SYMBOL(dqnet_fap_get_q_info);

int dqnet_fap_enable_rx_shaper(struct net_device *dev, int enable)
{
	if (fap && fap->enable_rx_shaper)
		return fap->enable_rx_shaper(dev, enable);
	else {
		return 0;
	}
}
EXPORT_SYMBOL(dqnet_fap_enable_rx_shaper);

int dqnet_fap_set_stp(struct net_device *dev, int state)
{
	if (fap && fap->set_stp)
		return fap->set_stp(dev, state);
	else {
		return 0;
	}
}
EXPORT_SYMBOL(dqnet_fap_set_stp);

int dqnet_fap_set_ageing(struct net_device *dev, clock_t ageing)
{
	if (fap && fap->set_ageing)
		return fap->set_ageing(dev, ageing);
	else {
		return 0;
	}
}
EXPORT_SYMBOL(dqnet_fap_set_ageing);

int dqnet_fap_fdb_add(struct net_device *dev, u16 vid, const unsigned char *addr)
{
	if (fap && fap->fdb_add)
		return fap->fdb_add(dev, vid, addr);
	else {
		return 0;
	}
}
EXPORT_SYMBOL(dqnet_fap_fdb_add);

int dqnet_fap_fdb_del(struct net_device *dev, u16 vid, const unsigned char *addr)
{
	if (fap && fap->fdb_del)
		return fap->fdb_del(dev, vid, addr);
	else {
		return 0;
	}
}
EXPORT_SYMBOL(dqnet_fap_fdb_del);

int dqnet_fap_set_isolate(struct net_device *dev,
			  int enable)
{
	if (fap && fap->set_isolate)
		return fap->set_isolate(dev, enable);
	else
		return -1;
}
EXPORT_SYMBOL(dqnet_fap_set_isolate);

int dqnet_fap_set_mtu(struct net_device *dev, int mtu)
{
	if (fap && fap->set_mtu)
		return fap->set_mtu(dev, mtu);
	else
		return -1;
}
EXPORT_SYMBOL(dqnet_fap_set_mtu);
