/****************************************************************************
 *
 * Copyright (c) 2022 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Jayesh Patel <jayeshp@broadcom.com>
 ***************************************************************************/

#ifndef __REGOPS__
#define __REGOPS__

#define ETHSW_REGOPS_TYPE   1

#define REG_WR8_OP         1
#define REG_RD_OR_WR8_OP   2
#define REG_RD_AND_WR8_OP  3
#define REG_RD_WAIT8_OP    4
#define REG_WR16_OP        5
#define REG_RD_OR_WR16_OP  6
#define REG_RD_AND_WR16_OP 7
#define REG_RD_WAIT16_OP   8
#define REG_WR32_OP        9
#define REG_RD_OR_WR32_OP  10
#define REG_RD_AND_WR32_OP 11
#define REG_RD_WAIT32_OP   12

struct regops {
	const char *name;
	unsigned int code;
	unsigned int page;
	unsigned int addr;
	unsigned int size;
	union {
		unsigned char  data8;
		unsigned short data16;
		unsigned int   data32;
	};
};

struct regops_img {
	const char *name;
	unsigned int type;
	unsigned int nops;
	unsigned int nops_alloc;
	struct regops *ops;
};
#endif
