/****************************************************************************
 *
 * Copyright (c) 2016 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef _BPCM_H_
#define _BPCM_H_

#include <linux/platform_device.h>
#include <linux/kernel.h>
#include <linux/types.h>

#define ID			(0)
#define CAPABILITY		(1)
#define CONTROL			(2)
#define STATUS			(3)
#define SOFTRESET		(8)
#define ZONE_CTRL(zone)		(16 + (zone) * 4)
#define ZONE_CFG1(zone)		(ZONE_CTRL(zone) + 1)
#define ZONE_CFG2(zone)		(ZONE_CTRL(zone) + 2)
#define ZONE_FREQ_CTRL(zone)	(ZONE_CTRL(zone) + 3)
#define MAX_REG_OFF		(1023)

#define ZONE_CTRL_RESET_STATE_MASK	BIT_MASK(31)
#define ZONE_CTRL_PWR_ON_STATE_MASK	BIT_MASK(26)
#define ZONE_CTRL_PWR_OFF_STATE_MASK	BIT_MASK(25)
#define ZONE_CTRL_BLK_RST_ASSERT_MASK	BIT_MASK(12)
#define ZONE_CTRL_MEM_PWR_CNTL_EN_MASK	BIT_MASK(11)
#define ZONE_CTRL_PWR_UP_REQ_MASK	BIT_MASK(10)
#define ZONE_CTRL_PWR_DN_REQ_MASK	BIT_MASK(9)
#define ZONE_CTRL_DPG_CNTL_EN_MASK	BIT_MASK(8)
#define ZONE_CTRL_FREQ_SCALE_USED_MASK	BIT_MASK(2)

#define ZONE_CFG1_RESET_OFF_MASK	GENMASK(3, 0)
#define ZONE_CFG1_RESET_OFF_SHIFT	0

#define ZONE_FREQ_HIGH_GEAR_DIV_MASK	GENMASK(9, 7)
#define ZONE_FREQ_HIGH_GEAR_DIV_SHIFT	7
#define ZONE_FREQ_LOW_GEAR_DIV_MASK	GENMASK(6, 4)
#define ZONE_FREQ_LOW_GEAR_DIV_SHIFT	4
#define ZONE_FREQ_USE_DYN_GEAR_SEL_MASK	BIT_MASK(2)

#define MAX_NAME_LEN	32

struct bpcm_device {
	struct list_head list;
	struct platform_device *pdev;
	u32 id;
	char name[MAX_NAME_LEN];
	struct device *pmb_dev;
	u32 zones;
	int clk_div[2];
};

int bpcm_get_device(char *name, struct bpcm_device **bpcm);
int bpcm_pwr_on(struct bpcm_device *bpcm);
int bpcm_pwr_off(struct bpcm_device *bpcm);
int bpcm_assert_soft_reset(struct bpcm_device *bpcm);
int bpcm_deassert_soft_reset(struct bpcm_device *bpcm);
int bpcm_set_clk_div(struct bpcm_device *bpcm);
int bpcm_read(struct bpcm_device *bpcm, u32 reg, u32 *val);
int bpcm_write(struct bpcm_device *bpcm, u32 reg, u32 val);

#endif
