FILESEXTRAPATHS_prepend := "${THISDIR}/files:${THISDIR}/backports:${THISDIR}/${BPN}:"

### TBD evaluate if needed for systemd250
SRC_URI += "file://systemd250-tmpfiles.patch \
            file://systemd250-forec-reboot-on-freeze.patch \
            file://0001-Added-code-to-cleanup-all-the-xisting-watches-on-pat.patch \
            file://0001-Added-decrement-of-notify-watchers-when-we-dont-need_systemd250.patch \
            file://0001-Added-Extra-information-for-NTP-Status-250.patch  \
            file://systemd250-ntp-event-trigger.patch \
            file://0001-In-our-echo-system-we-are-managing-last-known-good-t-250.patch \
            ${@bb.utils.contains('DISTRO_FEATURES', 'systimemgr', ' file://systemtimemgr_ntp.patch', '', d)} \
            file://0001_systemd250_reduce_journal_rotation_logging.patch \
            "

PACKAGECONFIG_append = " timesyncd"
#PACKAGECONFIG[timesyncd] = "--enable-timesyncd,--disable-timesyncd"


do_install_append() {
        install -d ${D}/media/tsb
	#Enable comcast ntp server in timesyncd.conf
	if [ -n "${@bb.utils.contains('PACKAGECONFIG', 'timesyncd', 'timesyncd', '', d)}" ]; then
	   sed -i -e 's/^#NTP=.*/NTP=ntp.ccp.xcal.tv/g' ${D}${sysconfdir}/systemd/timesyncd.conf
           #Patch for CISCOXI4-2785: remove ProtectSystem=full from systemd-timesyncd.service
           sed -i -e '/ProtectSystem=/a ReadWritePaths=\/tmp' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/PrivateTmp=yes/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
	   sed -i -e 's/ExecStart=\!\!\/lib\/systemd\/systemd-timesyncd/ExecStartPre=\!\!\/bin\/sh -c \/lib\/rdk\/default-time-setter.sh\n&/' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^LockPersonality=yes.*/LockPersonality=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^MemoryDenyWriteExecute=yes.*/MemoryDenyWriteExecute=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^NoNewPrivileges=yes.*/NoNewPrivileges=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^PrivateDevices=yes.*/PrivateDevices=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectProc=invisible.*/ProtectProc=default/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectControlGroups.*/ProtectControlGroups=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectHome=yes.*/ProtectHome=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectHostname=yes.*/ProtectHostname=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectKernelLogs=yes.*/ProtectKernelLogs=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectKernelModules=yes.*/ProtectKernelModules=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^ProtectKernelTunables=yes.*/ProtectKernelTunables=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^RestrictNamespaces=yes.*/RestrictNamespaces=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^RestrictRealtime=yes.*/RestrictRealtime=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e 's/^RestrictSUIDSGID=yes.*/RestrictSUIDSGID=false/g' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
	   sed -i -e 's/^#ShutdownWatchdogSec=.*$/ShutdownWatchdogSec=1min/g' ${D}${sysconfdir}/systemd/system.conf
       fi

}


do_install_append_hybrid() {
	#Enable comcast ntp server in timesyncd.conf
	if [ -n "${@bb.utils.contains('PACKAGECONFIG', 'timesyncd', 'timesyncd', '', d)}" ]; then
	   sed -i -e 's/ExecStart=\!\!\/lib\/systemd\/systemd-timesyncd/ExecStart=\!\!\/bin\/sh -c \/bin\/echo systemd-timesyncd not needed in gateways/' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/Restart=always/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/WatchdogSec=1min/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/PrivateDevices=yes/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/ProtectHome=yes/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/CapabilityBoundingSet=CAP_SYS_TIME CAP_SETUID CAP_SETGID CAP_SETPCAP CAP_CHOWN CAP_DAC_OVERRIDE CAP_FOWNER/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/Type=notify/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service
           sed -i -e '/RestartSec=0/d' ${D}${systemd_unitdir}/system/systemd-timesyncd.service

        fi
	#RDK-20332 : Further Analysis on Systemd Optimisation

        rm -rf ${D}${base_libdir}/systemd/systemd-reply-password
        rm -rf ${D}${base_libdir}/systemd/systemd-activate
}

do_install_append_broadband(){
	rm -rd ${D}/media/tsb
}

FILES_${PN}_append_client = " /media/tsb"
FILES_${PN}_append_hybrid = " /media/tsb"
