 /****************************************************************************
 *
 * Copyright (c) 2015 Broadcom Corporation
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef __LINUX_BRIDGE_EBT_DHCPSNOOP_H
#define __LINUX_BRIDGE_EBT_DHCPSNOOP_H

#define EBT_DHCPSNOOP_OPTION_MAX                3
#define EBT_DHCPSNOOP_OPTION_ACTION_REMOVE      1
#define EBT_DHCPSNOOP_OPTION_ACTION_REPLACE     2
#define EBT_DHCPSNOOP_OPTION_ACTION_INSERT      3
#define EBT_DHCPSNOOP_OPTION_ACTION_MATCH       4
#define EBT_DHCPSNOOP_OPTION_ACTION_MAX         4
#define EBT_DHCPSNOOP_OPTION_MAX_LEN            100

#define EBT_DHCPSNOOP_GIADDR            0x1
#define EBT_DHCPSNOOP_SIADDR            0x2
#define EBT_DHCPSNOOP_CHADDR            0x4
#define EBT_DHCPSNOOP_B2U               0x8
#define EBT_DHCPSNOOP_CHADDR_VERIFY     0x10
#define EBT_DHCPSNOOP_CLIENTID_VERIFY   0x20
#define EBT_DHCPSNOOP_OPTION_AUTOFILL   0x40
#define EBT_DHCPSNOOP_DUMP              0x80
#define EBT_DHCPSNOOP_CLIENTDB          0x100

struct ebt_dhcp_option {
	__u8 tag;
	__u8 len;
	__u8 data[EBT_DHCPSNOOP_OPTION_MAX_LEN];
};

struct ebt_dhcp_option_info {
	__u8 parent_tag;
	struct ebt_dhcp_option option;
	__u8 action;
	/* tag[.subtag[:len:hexoctetstring]] */
	/* 18.1:2:1122     */
	/* 0x21:0x3:112233 */
	/* 0x21.0x2:4:11223344 */
	/* Each 8bit value is converted into hex string which occupies 2bytes */
	char display[2*EBT_DHCPSNOOP_OPTION_MAX_LEN+16];
};

struct ebt_dhcpsnoop_info {
	uint32_t siaddr;
	uint32_t simask;
	uint32_t giaddr;
	uint32_t gimask;
	__u8 chaddr[ETH_ALEN];
	__u8 chmask[ETH_ALEN];
	__u8 clientid[ETH_ALEN];
	__u8 clientid_init;
	__u8 pkt_type_mask;
	__u16  bitmask;
	__u16  invflags;
	int target;
	int noption;
	struct ebt_dhcp_option_info optlist[EBT_DHCPSNOOP_OPTION_MAX];
};
#define EBT_DHCPSNOOP_TARGET "dhcpsnoop"

#define DHCPDISCOVER    1
#define DHCPOFFER       2
#define DHCPREQUEST     3
#define DHCPDECLINE     4
#define DHCPACK         5
#define DHCPNAK         6
#define DHCPRELEASE     7
#define DHCPINFORM      8

#endif
