#!/bin/sh
PROFILES_DIR="/etc/apparmor.d/"
PROFILES_DIR_SEG="/etc/apparmor/service_profiles"
PROFILES_UNCONFINED_DIR="/etc/apparmor.d/unconfined/"
PARSER="/sbin/apparmor_parser"
SYSFS_AA_PATH="/sys/kernel/security/apparmor/profiles"
RDKLOGS="/rdklogs/logs/Consolelog.txt.0"
Apparmor_defaults="/etc/apparmor/apparmor_defaults"
FR_Flag="/nvram/apparmor_factory_reset"
PIN_FR=0
LoadedProfile_count=0
echo -n noquiet > /sys/module/apparmor/parameters/audit

if [ -d "$PROFILES_DIR_SEG" ];then
    $PARSER -rB "$PROFILES_DIR_SEG"/*
fi
source /etc/log_timestamp.sh
if [ -f /etc/device.properties ];then
     source /etc/device.properties
fi
if [ -f /lib/rdk/t2Shared_api.sh ]; then
    source /lib/rdk/t2Shared_api.sh
fi
if [ "$BOX_TYPE" = "HUB4" ]; then
      if [ `cat /data/HFRES_UTOPIA` -eq 1 ]; then
            PIN_FR=1
      fi
fi
if [ "$BOX_TYPE" = "SR213" ]; then
      if [ `cat /data/HFRES_UTOPIA` -eq 1 ]; then
            PIN_FR=1
      fi
fi
if [ "$MODEL_NUM" = "TG3482G" ]; then
      if [ -s /sys/bus/acpi/devices/INT34DB:00/reset_btn_dur ]; then
           PIN_FR=`cat /sys/bus/acpi/devices/INT34DB:00/reset_btn_dur`
      fi
fi
if [ "$MODEL_NUM" = "TG4482A" ]; then
      if [ -f /nvram/WPS_Factory_Reset ]; then
           PIN_FR=1
      fi
fi
if [ -f $FR_Flag ]; then
     PIN_FR=1
     rm -f $FR_Flag
fi
complain_list=()
enforce_list=()

if [ "$PIN_FR" -eq "0" ]; then
     while read line; do
        mode=`echo $line | cut -d ":" -f 2`
        process=`echo $line | cut -d ":" -f 1`
        profile=`ls -ltr $PROFILES_DIR | grep -w $process | awk '{print $9}'`
        if [ ! -z $profile ]; then
            if [ "$mode" == "enforce" ]; then
                enforce_list+=("$PROFILES_DIR/$profile")
                LoadedProfile_count=`expr $LoadedProfile_count + 1`
            elif [ "$mode" == "complain" ]; then
                complain_list+=("$PROFILES_DIR/$profile")
            fi
        fi
     done<$Apparmor_defaults
fi
if [[ ${#complain_list[@]} -gt 0 ]]; then
    joined_string=$(IFS=" "; echo "${complain_list[*]}")
    apparmor_parser -rWC $joined_string
fi

if [[ ${#enforce_list[@]} -gt 0 ]]; then
    joined_string=$(IFS=" "; echo "${enforce_list[*]}")
    apparmor_parser -rW $joined_string
fi

list=`cat $SYSFS_AA_PATH | grep complain | awk '{print $1}' | tr '\n' ','`
cnt=`cat $SYSFS_AA_PATH | grep complain | wc -l`
if [ ! -z "$list" ]; then
        echo_t "List of profiles in Apparmor-complain mode:$cnt,$list" >> $RDKLOGS
        t2ValNotify "APPARMOR_C_split" "$cnt,$list"
fi
list=`cat $SYSFS_AA_PATH | grep enforce | awk '{print $1}' | tr '\n' ','`
cnt=`cat $SYSFS_AA_PATH | grep enforce | wc -l`
if [ ! -z "$list" ]; then
     echo_t "List of profiles in Apparmor-enforce mode:$cnt,$list" >> $RDKLOGS
     t2ValNotify "APPARMOR_E_split" "$cnt,$list"
fi
if [ $LoadedProfile_count -ne $cnt ]; then
     echo_t "Mismatch in the number of loaded Apparmor profiles" >> $RDKLOGS
fi
if [ -f /etc/apparmor/aar_telemetry.sh ]; then
        /etc/apparmor/aar_telemetry.sh &
fi
