SUMMARY = "HN Reliability Duplicate DHCP Server Detection"

LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://COPYING;md5=1b9c3a810ba2d91cab5522ca08f70b47"

DEPENDS = "ccsp-common-library ccsp-misc"

SRC_URI = "${RDKB_COMPONENTS_ROOT_GIT}/opensource/DhcpServDt/generic;protocol=${RDK_GIT_PROTOCOL};branch=${RDK_GIT_BRANCH};name=dhcpservdt"

PV = "${RDK_RELEASE}+git${SRCPV}"
SRCREV_dhcpservdt = "${AUTOREV}"

S = "${WORKDIR}/git"

inherit autotools

CFLAGS += " -Wall -Werror -Wextra -Wno-type-limits "

PACKAGES =+ "${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', '${PN}-gtest', '', d)}"
FILES_${PN}-gtest = "\
    ${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', '${bindir}/DhcpServDt_gtest.bin', '', d)} \
"

DOWNLOAD_APPS="${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', 'gtestapp-DhcpServDt', '', d)}"
inherit comcast-package-deploy
CUSTOM_PKG_EXTNS="${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', 'gtest', '', d)}"
SKIP_MAIN_PKG="${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', 'yes', 'no', d)}"
DOWNLOAD_ON_DEMAND="${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', 'yes', 'no', d)}"
EXTRA_OECONF_append = " ${@bb.utils.contains('DISTRO_FEATURES', 'gtestapp', '--enable-gtestapp', '', d)}"
