 /****************************************************************************
 *
 * Copyright (c) 2015-2018 Broadcom. All rights reserved
 * The term "Broadcom" refers to Broadcom Inc. and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************/

#ifndef _ETHSW_3390_H_
#define _ETHSW_3390_H_

#include <linux/kernel.h>

#include "ethsw.h"
#include "ethsw_priv.h"

#define MAX_LED_PORT_CNTRL_REG	6
/***************************************************************************
 * SWITCH_CORE
 ***************************************************************************/

typedef struct {
	u8                          Pad[0x40000];
} CoreRegisters;

/***************************************************************************
 * SWITCH_REG
 ***************************************************************************/

typedef union {
	struct {
		u32 MdioMasterSel       :1;
		u32 Reserved            :31;
	} Bits;
	u32 Reg32;
} SwitchCntrlRegister;

typedef union {
	struct {
		u32 SwInitDone          :1;
		u32 Reserved            :31;
	} Bits;
	u32 Reg32;
} SwitchStatusRegister;

typedef union {
	struct {
		u32 IddqBias            :1;
		u32 ExtPwrDown          :4;
		u32 ForceDllEn          :1;
		u32 IddqGlobalPwr       :1;
		u32 Ck25Dis             :1;
		u32 PhyReset            :1;
		u32 Reserved2           :3;
		u32 PhyAd               :5;
		u32 Reserved            :15;
	} Bits;
	u32 Reg32;
} QphyCntrlRegister;

typedef union {
	struct {
		u32 EnergyDetMasked     :4;
		u32 EnergyDetApd        :4;
		u32 PllLock             :1;
		u32 Reserved            :23;
	} Bits;
	u32 Reg32;
} QphyStatusRegister;

typedef union {
	struct {
		u32 LedOffTime          :16;
		u32 LedOnTime           :16;
	} Bits;
	u32 Reg32;
} LedBlinkRateCntrlRegister;

typedef union {
	struct {
		u32 RefreshPeriod       :5;
		u32 SledClkPol          :1;
		u32 SledClkFrequency    :1;
		u32 Smode               :1;
		u32 PortEn              :8;
		u32 Reserved            :16;
	} Bits;
	u32 Reg32;
} LedSerialCntrlRegister;

typedef union {
	struct {
		u32 SpdNoLinkEncode     :2;
		u32 Spd10mEncode        :2;
		u32 Spd100mEncode       :2;
		u32 Spd1000mEncode      :2;
		u32 SelNoLinkEncode     :2;
		u32 Sel10mEncode        :2;
		u32 Sel100mEncode       :2;
		u32 Sel1000mEncode      :2;
		u32 RxDvEn              :1;
		u32 TxEnEn              :1;
		u32 SpdlnkLed0ActSel    :2;
		u32 SpdlnkLed1ActSel    :2;
		u32 ActLedActSel        :2;
		u32 SpdlnkSrcSel        :1;
		u32 SpdlnkLed0ActPolSel :1;
		u32 SpdlnkLed1ActPolSel :1;
		u32 ActLedPolSel        :1;
		u32 Reserved            :4;
	} Bits;
	u32 Reg32;
} LedCntrlRegister;

typedef union {
	struct {
		u32 Reserved            :24;
		u32 TxPauseEn           :1;
		u32 RxPauseEn           :1;
		u32 RvmiiRefSel         :1;
		u32 PortMode            :3;
		u32 IdModeDis           :1;
		u32 RgmiiModeEn         :1;
	} Bits;
	u32 Reg32;
} Rgmii9CntrlRegister;

typedef struct {
	u32                         SwitchCntrl;
	u32                         SwitchStatus;
	u32                         DirDataWrite;
	u32                         DirDataRead;
	u8                          Pad[0x14];
	u32                         QphyCntrl;
	u32                         QphyStatus;
	u8                          Pad1[0x5C];
	u32                         LedBlinkRateCntrl;
	u32                         LedSerialCntrl;
	u32                         LedCntrl[MAX_LED_PORT_CNTRL_REG];
	u32                         Led7Cntrl;
	u8                          Pad3[0x04];
	u32                         Rgmii9Cntrl;
	u32                         Rgmii9IbStatus;
	u32                         Rgmii9RxClockDelayCntrl;
} RegRegisters;

/***************************************************************************
 * SWITCH_INDIR_RW
 ***************************************************************************/

typedef struct {
	u8                          Pad[0x18];
} IndirRwRegisters;

/***************************************************************************
 * SWITCH_INTRL2_x
 ***************************************************************************/

typedef struct {
	u32                         CpuStatus;
	u32                         CpuSet;
	u32                         CpuClear;
	u32                         CpuMaskStatus;
	u32                         CpuMaskSet;
	u32                         CpuMaskClear;
	u32                         PciStatus;
	u32                         PciSet;
	u32                         PciClear;
	u32                         PciMaskStatus;
	u32                         PciMaskSet;
	u32                         PciMaskClear;
} IntrL2Registers;

/***************************************************************************
 * SWITCH_MDIO
 ***************************************************************************/

typedef union {
  struct {
    u32 DataAddr                :16;
    u32 RegDecAddr              :5;
    u32 PhyPrtAddr              :5;
    u32 OpCode                  :2;
    u32 Fail                    :1;
    u32 Busy                    :1;
    u32 Reserved                :2;
  } Bits;
  u32 Reg32;
}  MdioCmdRegister;

typedef union {
  struct {
    u32 MdioClause              :1;
    u32 Reserved3               :3;
    u32 MdioClkDivider          :6;
    u32 Reserved2               :2;
    u32 SupressPreamble         :1;
    u32 Reserved                :19;
  } Bits;
  u32 Reg32;
}  MdioCfgRegister;

typedef struct {
	u32                         MdioCmd;
	u32                         MdioCfg;
} MdioRegisters;

/***************************************************************************
 * SWITCH_FCB
 ***************************************************************************/

typedef struct {
	u8                          Pad[0x30];
} FcbRegisters;

/***************************************************************************
 * SWITCH_ACB
 ***************************************************************************/

typedef struct {
	u8                          Pad[0x108];
} AcbRegisters;

/***************************************************************************
 * SWITCH Top Level
 ***************************************************************************/

/*
 * The RDB names were changed starting on the 3390B0 onward.
 */
#ifdef BCHP_SWITCH_CORE_G_PCTL_P0
#define BCHP_SWITCH_CORE_START          BCHP_SWITCH_CORE_G_PCTL_P0
#else
#define BCHP_SWITCH_CORE_START          BCHP_SWITCH_CORE_G_PCTL_Port_0
#endif
#define BCHP_SWITCH_REG_START           BCHP_SWITCH_REG_SWITCH_CNTRL
#define BCHP_SWITCH_INDIR_RW_START      BCHP_SWITCH_INDIR_RW_INDIR_ADDR_REG_0
#define BCHP_SWITCH_INTRL2_0_START      BCHP_SWITCH_INTRL2_0_CPU_STATUS
#define BCHP_SWITCH_INTRL2_1_START      BCHP_SWITCH_INTRL2_1_CPU_STATUS
#define BCHP_SWITCH_MDIO_START          BCHP_SWITCH_MDIO_MDIO_CMD
#define BCHP_SWITCH_FCB_START           BCHP_SWITCH_FCB_FCB_CONTROL
#define BCHP_SWITCH_ACB_START           BCHP_SWITCH_ACB_ACB_CONTROL
#define BCHP_SWITCH_START               BCHP_SWITCH_CORE_START

typedef struct {
	union {
		struct {
			u8                          Pad0[BCHP_SWITCH_CORE_START - BCHP_SWITCH_START];
			CoreRegisters               Core;
		};
		struct {
			u8                          Pad1[BCHP_SWITCH_REG_START - BCHP_SWITCH_START];
			RegRegisters                Reg;
		};
		struct {
			u8                          Pad2[BCHP_SWITCH_INDIR_RW_START - BCHP_SWITCH_START];
			IndirRwRegisters            IndirRw;
		};
		struct {
			u8                          Pad3[BCHP_SWITCH_INTRL2_0_START - BCHP_SWITCH_START];
			IntrL2Registers             IntrL20;
		};
		struct {
			u8                          Pad4[BCHP_SWITCH_INTRL2_1_START - BCHP_SWITCH_START];
			IntrL2Registers             IntrL21;
		};
		struct {
			u8                          Pad5[BCHP_SWITCH_MDIO_START - BCHP_SWITCH_START];
			MdioRegisters               Mdio;
		};
		struct {
			u8                          Pad6[BCHP_SWITCH_FCB_START - BCHP_SWITCH_START];
			FcbRegisters                Fcb;
		};
		struct {
			u8                          Pad7[BCHP_SWITCH_ACB_START - BCHP_SWITCH_START];
			AcbRegisters                Acb;
		};
	};
} SwitchRegisters;

#define SWITCH                          ((volatile SwitchRegisters  *)(swdev->reg_base))
#define SWITCH_CORE                     ((volatile CoreRegisters    *)&SWITCH->Core)
#define SWITCH_REG                      ((volatile RegRegisters     *)&SWITCH->Reg)

#define QPHYCTRL_AFE_OFF_BITS BCHP_SWITCH_REG_QPHY_CNTRL_ext_pwr_down_DEFAULT
#define QPHYCTRL_AFE_ON_MASK(m) (QPHYCTRL_AFE_OFF_BITS & ~(m))

#endif /* _ETHSW_3390_H_ */
