#include <glib.h>
#include <glib-polyfill.h>
#include <stdbool.h>
#include <assert.h>

int main(int argc, char *argv[])
{
    g_autoptr(GUri) uri = g_uri_parse("https://example.com?q=test", G_URI_FLAGS_ENCODED_QUERY, NULL);
    assert(uri != NULL);

    g_autoptr(GHashTable) query_params = g_uri_parse_params(g_uri_get_query(uri), -1, "&", G_URI_PARAMS_NONE, NULL);
    assert(query_params != NULL);
    assert(g_strcmp0("test", g_hash_table_lookup(query_params, "q")) == 0);

    return 0;
}
