DESCRIPTION = "Broadcom Linux Kernel"
SECTION = "kernel"
LICENSE = "GPLv2"

LIC_FILES_CHKSUM = "file://COPYING;md5=6bc538ed5bd9a7fc9398086aedcd7e46"

INC_PR = "r1"

inherit kernel

DEPENDS += "xz-native bc-native lzop-native rsync-native virtual/gettext"

do_populate_sysroot[deptask] = "do_install"

## Broadcom RDK-B kernel configurations
## Kernel fragments in this section carry from SDK to SDK, and may get update with SDK
## Kernel fragments in this section are applied after the linux*.fragment in the chip meta layers
SRC_URI += "file://0011_kernel_cgroups.cfg"
SRC_URI += "file://0012_kernel_dummy_network.cfg"
SRC_URI += "file://0013_kernel_netfilter.cfg"
SRC_URI += "file://0014_kernel_debug.cfg"
SRC_URI += "file://0015_kernel_wifi.cfg"
SRC_URI += "file://0016_kernel_test.cfg"
# no need for 0017_kernel_apparmor.cfg as RDK has applied apparmor.cfg in the meta-rdk-ext layer
# SRC_URI += "${@bb.utils.contains("DISTRO_FEATURES", "apparmor", "file://0017_kernel_apparmor.cfg", "" ,d)}"
SRC_URI += "file://0018_kernel_squashfs_xattr.cfg"


## Comcast specific kernel patches for RDKB 339x / 3394x platforms
## Patches in this section usually carry from SDK to SDK.
## Kernel fragments in this section are applied after the above Broadcom RDK-B kernel configurations
# the following inherit from rglinux_4.9-%.bbappend
SRC_URI_append_arm     += "file://netfilter_5.4.cfg"
SRC_URI_append_aarch64 += "file://netfilter_5.4-aarch64.cfg"
SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES', 'OneWifi', ' file://netlink.cfg', '', d)}"

# SRC_URI += "file://0001_SWRGROUTER-12443_brcm93390b0_comcast.cfg"
SRC_URI += "file://quic_crypto.cfg"
SRC_URI += "file://cgroups.cfg"
SRC_URI += "file://dummy_network.cfg"
SRC_URI += "file://bcm_netxl.cfg"
SRC_URI += "file://disable_stackprotector.cfg"
SRC_URI += "file://xtables.cfg"
SRC_URI += "file://BCOMB-380_pcieaspm.cfg"
SRC_URI_append_broadband += "file://bluetooth.cfg"

# the following inherit from rglinux_4.9-2.1.bb 
SRC_URI += "file://suppress_gcc6_error.patch"
SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES', 'dunfell', 'file://Dunfell_Yocto_3_1.patch', '', d)}"

#SRC_URI += "file://long_obj_list.patch"
SRC_URI += "file://0001-add-support-for-http-host-headers-cookie-url-netfilt-broadband.patch"
SRC_URI += "file://netfilt_5.4.patch"
SRC_URI += "file://SWRDKB-1107_nmi_and_bolt_watchdog_support.patch"
#SRC_URI_append_aarch64 += "file://rdkb_modpost_external_module_build.patch"
SRC_URI_append_aarch64 += "file://SWRDKB-1785_arm64_cpuinfo_always_show_model.patch"

# boops
SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES','boops','file://boops.patch file://disable_oops_mmc.cfg','',d)}"

# TCHBCM-308 "ls" behavior change for secure directories
SRC_URI += "file://TCHBCM-308_revert-eCryptfs-donot-pass-up-plaintext-names-when-using-filename-encryption.patch"

# BCOMB-2923 boot-time spike
SRC_URI += "file://SWRGROUTER-18770_mdio.patch"

SRC_URI += "${@bb.utils.contains('DISTRO_FEATURES', 'cac', ' file://BCOMB-2543.patch', '', d)}"


S = "${WORKDIR}/linux"

EXTRA_OEMAKE += "V=1"

# Kernel configuration
COMPATIBLE_HOST = "(mips|arm|aarch64).*"

LINUX_VERSION ?= "${KERNEL_MAJOR_VERSION}"
LINUX_VERSION_EXTENSION ?= "-brcm"

do_configure_prepend () {
    # Clean old configurations to avoid "source tree not clean" error
    oe_runmake arch=${ARCH} mrproper -C ${S}

    # ARCH specific Kernel configurations.
    if [ ${ARCH} = "arm" ]; then
        KERNEL_CONFIG_ARCH_LIST="\
            ${S}/arch/arm/configs/bcmcm_defconfig \
            ${WORKDIR}/arm/linux.fragment \
            ${WORKDIR}/arm/linux_bcm.fragment \
            ${WORKDIR}/arm/linux_netfilter.fragment \
            ${WORKDIR}/arm/linux_slim.fragment"
    elif [ ${ARCH} = "arm64" ]; then
        KERNEL_CONFIG_ARCH_LIST="\
            ${S}/arch/arm64/configs/bcmcm_defconfig \
            ${WORKDIR}/arm64/linux.fragment \
            ${WORKDIR}/arm64/linux_netfilter.fragment"
    else
        echo "Error: ${ARCH} is not supported"
        exit 1
    fi

    # RDK Kernel configurations.
    KERNEL_CONFIG_RDK_LIST="$(ls ${WORKDIR}/*.cfg | sort -n)"

    # Merge Kernel configs
    echo "Merge configs: $KERNEL_CONFIG_ARCH_LIST $KERNEL_CONFIG_RDK_LIST $KERNEL_CONFIG_EXT_LIST"
    sh ${S}/scripts/kconfig/merge_config.sh -m $KERNEL_CONFIG_ARCH_LIST $KERNEL_CONFIG_RDK_LIST $KERNEL_CONFIG_EXT_LIST
    mv .config ${WORKDIR}/defconfig

    # Update Kernel EXTRAVERSION to Yocto style, "[a-z0-9.+-]"
    NEWVERSTR=$(grep "EXTRAVERSION *=" ${S}/Makefile | awk -F '=' -e '{ str = tolower($2); gsub("_","-", str); print str }')
    sed -i "/EXTRAVERSION/s/[-_][-_A-Za-z0-9.]*/$NEWVERSTR/" ${S}/Makefile
}

do_configure_append () {
    # [ -f "${WORKDIR}/build/.config" ] && echo "overwrite merged cfg w/ ${KERNEL_DEFCONFIG}" ; cp -a ${KERNEL_DEFCONFIG} ${WORKDIR}/build/.config

    echo "=============================== Final Kernel Config For Build ==============================="
    [ -f "${WORKDIR}/build/.config" ] && sed -nr '/^CONFIG/p' "${WORKDIR}/build/.config" | sort
    echo "============================================================================================="
}

# Install rglinux Kernel headers
do_compile_append() {
    install -d ${B}/include/${BPN}
    oe_runmake arch=${ARCH} INSTALL_HDR_PATH=${B}/include/${BPN} headers_install
}

do_compile_kernelmodules_append () {
       if [ ! -d "${STAGING_KERNEL_BUILDDIR}/scripts" ]; then
                mkdir ${STAGING_KERNEL_BUILDDIR}/scripts
       fi
       cp -f ${B}/scripts/module.lds ${STAGING_KERNEL_BUILDDIR}//scripts/module.lds
}

do_shared_workdir_append() {
    cp -fR ${B}/include/${BPN} $kerneldir/include/
}

# Add symbolic link for vmlinuz-${BRCM_CHIP}
do_deploy_append() {
    ln -sf ${KERNEL_IMAGETYPE}-${KERNEL_IMAGE_NAME}.bin ${DEPLOYDIR}/vmlinuz-${BRCM_CHIP}
}

RDEPENDS_kernel-base = ""
INHIBIT_PACKAGE_STRIP = "1"

# Remove /boot/zImage* from target root file system
RRECOMMENDS_${KERNEL_PACKAGE_NAME}-base = ""
