SUMMARY = "xmeshgre Linux kernel module"
LICENSE = "GPLv2"
LIC_FILES_CHKSUM = "file://${WORKDIR}/COPYING;md5=ee54d06935b550cdc4cfd68132adf385"

PACKAGE_ARCH = "${MACHINE_ARCH}"

PROVIDES += "xmeshgre"
RPROVIDES_${PN} += "xmeshgre"

SRC_URI = "file://Makefile \
           file://COPYING \
           file://xmeshgre.c \
          "

S="${WORKDIR}/xmeshgre"

CFLAGS += " -Wall -Wno-unused-function"
do_compile[lockfiles] = "${TMPDIR}/kernel-scripts.lock"

MAKE_TARGETS = "all"
MODULE_NAME = "xmeshgre"

inherit module pkgconfig

do_configure[noexec] ="1"

do_copy_source() {
    cp -f ${WORKDIR}/xmeshgre.c ${S}/.
    cp -f ${WORKDIR}/Makefile ${S}/.
}

module_do_install() {
    install -d ${D}/lib/modules/${KERNEL_VERSION}/misc
    bbnote "Copying ${MODULE_NAME}.ko to ${D}/lib/modules/${KERNEL_VERSION}/misc"
    install -m 0644 ${S}/${MODULE_NAME}.ko ${D}/lib/modules/${KERNEL_VERSION}/misc/${MODULE_NAME}.ko
}

addtask do_copy_source before do_patch after do_unpack
