/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2016 Broadcom. All rights reserved.
 * The term "Broadcom" refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Tim Ross <tross@broadcom.com>
 *****************************************************************************/
#ifndef __DQNET_PRIV_H_
#define __DQNET_PRIV_H_

#include <proc_cmd.h>
#include <bcmnethooks.h>
#include <hal_device.h>
#include <linux/phy.h>
#include "dqnet.h"
#include "dqm.h"

#define MODULE_VER		"2.0"
#define MODULE_NAME		"brcm-dqnet"
#define DQNET_OF_MATCH		"brcm,dqnet"

#ifdef CONFIG_SKB_RECYCLE
#define FPM_IN_SKB  /* Using FPM in SKB->data  in Rcv direction */
#endif

#define Q_PRIO_MAX		(8)
#define Q_US_DS_MAX		(2)
#define DQNET_MAC_ADDR_SIZE	(6)

#define ETH_MFG_ALEN		(3)
#define ETH_UNIQUE_ALEN		(ETH_ALEN - ETH_MFG_ALEN)

#define ETH_P_IEEE1905		0x893a	/* IEEE 1905.1  */
#define ETH_P_BRCM		0x886c	/* Broadcom Corp. */
#define ETH_P_802_1X		0x888e	/* 802.1x */
#define ETH_P_802_1X_PREAUTH	0x88c7	/* 802.1x preauthentication */

#define MAX_PHY_PORTS		(8)

#define DQNET_MAX_MSGSZ		4

#define DQNET_SYSCTL_PATH	"net/dqnet/"
#define DQNET_DEV_SYSCTL_ENTRY(var, name, mval, proc) \
	{ \
		.procname	= name, \
		.data		= (void *)offsetof(struct dqnet_netdev, var), \
		.maxlen		= sizeof(int), \
		.mode		= mval, \
		.proc_handler	= proc, \
	}

struct dqnet_sysctl {
	struct ctl_table_header *hdr;
	struct ctl_table *tbl;
};

struct dqnet_list {
	struct list_head list;
	spinlock_t lock;	/* list lock */
};

enum dqnet_demux_type {
	DQNET_DEMUX_TYPE_NONE,
	DQNET_DEMUX_TYPE_IFID_SUBID,
	DQNET_DEMUX_TYPE_IFID_ARL
};

enum dqnet_chan_type {
	DQNET_CHAN_TYPE_FAP_EXCEPT,
	DQNET_CHAN_TYPE_FAP_HOST,
	DQNET_CHAN_TYPE_POINT_TO_POINT,
	DQNET_CHAN_TYPE_POINT_TO_POINT_SWAP,
	DQNET_CHAN_TYPE_SPOOFED,
};

enum dqnet_qmsg_fmt {
	DQNET_QMSG_FMT_UNKNOWN,
	DQNET_QMSG_FMT_GFAP_FPM,
	DQNET_QMSG_FMT_GFAP_SKB,
	DQNET_QMSG_FMT_GFAP3_FPM,
	DQNET_QMSG_FMT_GFAP3_SKB,
	DQNET_QMSG_FMT_RFAP_FPM,
	DQNET_QMSG_FMT_RFAP_SKB,
	DQNET_QMSG_FMT_RFAP_SKB_RX
};

enum dqnet_link_type {
	DQNET_LINK_TYPE_UNKNOWN,
	DQNET_LINK_TYPE_SWITCH,
	DQNET_LINK_TYPE_RPC,
	DQNET_LINK_TYPE_PHY,
	DQNET_LINK_TYPE_WIFI,
	DQNET_LINK_TYPE_HOSTDRV,
	DQNET_LINK_TYPE_FIXED,
};

enum dqnet_link_state {
	DQNET_LINK_STATE_DOWN,
	DQNET_LINK_STATE_UP,
};

enum dqnet_q_type {
	DQNET_QUEUE_US,	/* Upstream */
	DQNET_QUEUE_DS,	/* Downstream */
	DQNET_QUEUE_CTL,/* Control */
	DQNET_QUEUE_EXP,/* Expected */
};

enum dqnet_tx_rx {
	DQNET_TX,
	DQNET_RX
};

enum dqnet_set_imp_cmd {
	DQNET_SET_IMP_AUTO,
	DQNET_SET_IMP_STATIC,
	DQNET_SET_IMP_RESERVE,
	DQNET_SET_IMP_RESET,
};

enum dqnet_imp_lag_action {

	/* For HW platforms with MoCA, there are 2 assumptions.
	 * 1. MoCA is connected to switch port 4.
	 * 2. MoCA port will be mapped to an IMP port such that the IMP port
	 *    is not oversubscribed. i.e., MoCA port is prioritized over LAN
	 *    switch ports. */

	/* SGMII @ 2.5G speed -> Mapping: IMP0(0,1,2,3,4) IMP1(7) */
	/* IMP0:4.0G (Oversubscribed), IMP1: 2.5G */
	DQNET_IMP_LAG_ACT_DEFAULT,

	/* All links @ 1G speed -> Mapping: IMP0(0,1,2,3) IMP1(4,7) */
	/* IMP0:3.0G (Oversubscribed), IMP1: 2.0G */
	DQNET_IMP_LAG_ACT_OPT1,

	/* SGMII @ 1G speed and 1 or more LAN slower than 1G
	 * Mapping: IMP0({W}) IMP1(4,7,Z)
	 * Where Z is the slow LAN port, and {W} = {0,1,2,3} - Z */
	/* IMP0:2.0G, IMP1: 2.1G */
	DQNET_IMP_LAG_ACT_OPT2,
	DQNET_IMP_LAG_ACT_OPT2_S0 = DQNET_IMP_LAG_ACT_OPT2, /* Slow port 0 */
	DQNET_IMP_LAG_ACT_OPT2_S1,   /* Slow port 1 */
	DQNET_IMP_LAG_ACT_OPT2_S2,   /* Slow port 2 */
	DQNET_IMP_LAG_ACT_OPT2_S3,   /* Slow port 3 */

	/* SGMII @ 100M speed -> Mapping: IMP0(X,Y,Z) IMP1(4,7,W)
	 * Where W is sure to be enabled and link up, and x,Y,Z may be
	 * disabled or link down */
	/* IMP0:2.0G, IMP1:2.1G MAX */
	DQNET_IMP_LAG_ACT_OPT3,

	/* ******************************************************** */
	/* Following values correspond to HW platforms without MoCA */
	/* ******************************************************** */

	/* SGMII @ 2.5G speed -> Mapping: IMP0(0,1,2,3) IMP1(7) */
	/* IMP0:4.0G (Oversubscribed), IMP1: 2.5G */
	DQNET_IMP_LAG_ACT_DEFAULT_NOMOCA,

	/* All links @ 1G speed -> Mapping: IMP0(1,2,3) IMP1(0,7) */
	/* IMP0:3.0G (Oversubscribed), IMP1: 2.0G */
	DQNET_IMP_LAG_ACT_OPT1_NM,

	/* SGMII @ 1G speed and 1 or more LAN slower than 1G
	 * Mapping: IMP0({W}) IMP1(0,7,Z)
	 * Where Z is the slow LAN port, and {W} = {1,2,3} - Z */
	/* IMP0:2.0G, IMP1: 2.1G */
	DQNET_IMP_LAG_ACT_OPT2_NM,
	DQNET_IMP_LAG_ACT_OPT2_S0_NM = DQNET_IMP_LAG_ACT_OPT2_NM,
	DQNET_IMP_LAG_ACT_OPT2_S1_NM,   /* Slow port 1 */
	DQNET_IMP_LAG_ACT_OPT2_S2_NM,   /* Slow port 2 */
	DQNET_IMP_LAG_ACT_OPT2_S3_NM,   /* Slow port 3 */

	/* SGMII @ 100M speed -> Mapping: IMP0(X,Y,Z) IMP1(0,7,W)
	 * Where W is sure to be enabled and link up, and x,Y,Z may be
	 * disabled or link down */
	/* IMP0:2.0G, IMP1:2.1G MAX */
	DQNET_IMP_LAG_ACT_OPT3_NM,

	DQNET_IMP_LAG_ACT_MAX = DQNET_IMP_LAG_ACT_OPT3_NM,
};


struct dqnet_channel;

/*
 * Demux function.
 *
 * If a packet needs to be demuxed this is the function
 * that will be used to do so.
 *
 * return 0 for success, < 0 for error
 */
typedef int (*dqnet_demux_fn)(struct dqnet_channel *chan,
			      struct fpm_buff *fb);

/* Net device private data structure. */
struct dqnet_netdev {
	void			*wifi_priv0;	/* must be 1st field */
	void			*wifi_priv1;	/* must be 2nd field */
	void			*wifi_priv2;	/* must be 3rd field */
	void			*wifi_priv3;	/* must be 4th field */
	struct bcm_nethooks	nethooks;	/* must be 5th field */

	struct list_head        list;
	struct list_head        open_list;
	struct list_head        tx_busy_list;

	struct platform_device  *pdev;
	struct net_device       *dev;
	struct hal_layers	hal;		/* HAL layered devices */
	struct dqnet_dev_stats	stats;		/* interface stats */
	union {
		struct net_device_ops 	*wifi_ops;     /* Wifi net dev ops */
		struct net_device_ops 	*hostdrv_ops;  /* HOSTDRV net dev ops */
	};
	union {
		struct net_device_ops 	*wifi_ops_orig;
		struct net_device_ops 	*hostdrv_ops_orig;
	};
	struct ethtool_ops      *ethtool_ops;
	struct ethtool_ops      *ethtool_ops_orig;

	char			mac_addr[6];	/* MAC address */

	char                    *name;		/* interface name */
	char                    *dt_name;	/* name in device tree */
	u32                     if_id;		/* IF ID used by FAP */
	u32                     if_sub_id;	/* IF sub ID used by FAP and switch */
	int                     tx_if_id;	/* Tx IF ID used by FAP */
	u32			*tx_qm_q;	/* Tx QM Q list */
	u32			tx_qm_q_count;	/* # of Tx QM Q per device */
	enum dqnet_demux_type   demux_type;	/* how to demux */
	dqnet_demux_fn		demux;		/* function to demux */
	bool			brcm_tag;	/* packets have BRCM tags */
	u32			svtag;	        /* packets have MACSEC SV tag */

	u32			head_pad;	/* buffer header space */
	u32			tail_pad;	/* buffer tail space */
	u32			mtu_pad;	/* optional padding for MTU */

	struct dqnet_channel    *chan;		/* channel to use */

	char			rpc_name[16];	/* RPC channel name */
	int			rpc_tunnel;	/* RPC tunnel ID */
	u32			msg_enable;	/* ethtool msg bitmask */
	int			bmcast_enable;	/* enable broad/multicast */
	int			brcmtag_opc_mc;	/* BRCM Tag opcode for multicast */
	int			brcmtag_opc_uc;	/* BRCM Tag opcode for unicast   */
	int			swport_imp;	/* Switch IMP port to use */
	int			phy_power;	/* phy power state */
	int			isolate;

	char		iperf_name[16]; /*IPERF name*/

#ifdef FPM_IN_SKB
	int			fpm_in_skb;	/* enable  use of FPM in RX SKB */
#endif
	int			tx_fpm;		/* enable  use of FPM in TX */
	struct dqnet_sysctl	sysctl;	        /* sysctl table and header */
	struct proc_dir_entry	*proc_dir_entry;
	struct rtnl_link_stats64 *(*link_stats)(struct net_device *dev,
					     struct rtnl_link_stats64 *stats);

	struct device_node	*phy_dn;	/* phy device node */
	struct phy_device	*phydev;	/* phy device */
	phy_interface_t		phy_mode;	/* phy interface type */

	enum dqnet_link_type	link_type;	/* how to get link status */
	enum dqnet_link_state	link_state;	/* link state */
	int			link_autoneg;	/* autoneg enabled */
	int			link_speed;	/* link speed */
	int			link_duplex;	/* link duplex */
	int			link_pause;	/* link pause enabled */
	bool dqnet_vlan_enable;
	bool swport_imp_reserve;		/* Reserve switch IMP port 1 */
	union {
		struct {
			dqnet_dhdol_get_flow_t	dhdol_get_flow;	/* Handler to get DHD offload flow */
			dqnet_dhdol_find_sta_t	dhdol_find_sta;	/* Handler to find a station */
			dqnet_dhd_tx_skb_nethook_t	dhd_tx_skb_nethook; /* DHD nethook TX callback */
			dqnet_dhd_rx_skb_nethook_t	dhd_rx_skb_nethook; /* DHD nethook RX callback */
			void		*dhd_cntx;		/* Context for DHD offload handler */
		};
		struct dqnet_hostdrv_info_t	hostdrv_info;
	};
	void		*fap_cntx;		/* FAP Specific data */
#if defined(CONFIG_BCM_PWR_RPC)
	/* work bottom half */
	struct work_struct work;
#endif
};

/* Q information read from the DT channel node. */
struct dqnet_q_info {
	char			dev[16];	/* DQM device name */
	int			q_num;		/* Q # on device */
	int			priority;	/* 0=highest */
	enum dqnet_q_type	q_type;		/* Q Type */
	u8			msg_size;	/* size of Q msgs */
};

struct dqnet_napi_complete {
	void	(*napi_complete_hook)(void *chan);
	atomic_t refcnt;
};

/* DQM channel structure.
 *
 * Each channel consists of a set of DQM's for TX and another
 * set for RX. Each set contains DQM's assigned unique
 * priorities, with index 0 being the highest priority DQM. Depending
 * on the FAP being used the TX Q's may also have a FAP processing
 * direction (upstream or downstream) associated with them. A
 * channel may be used by multiple network interfaces
 * (net_devices), and thus the channel contains a list of
 * packet processing functions that are used to demux, log,
 * filter packets, etc. as they make their way to the correct
 * network interface.
 */
struct dqnet_channel {
	struct list_head list;

	char			name[16];	/* name of this channel */
	int			tx_q_count;	/* # of TX Q's */
	int			rx_q_count;	/* # of RX Q's */

					/* Q info from DT */
	struct dqnet_q_info	tx_q_info[Q_PRIO_MAX * Q_US_DS_MAX];
	struct dqnet_q_info	rx_q_info[Q_PRIO_MAX];

				/* DQM handles */
	void			*tx_q[Q_PRIO_MAX][Q_US_DS_MAX];
	void			*rx_q[Q_PRIO_MAX];
	spinlock_t		rx_irq_lock;

					/* devs awaiting DQM room to TX */
	struct dqnet_list	tx_busy[Q_PRIO_MAX][Q_US_DS_MAX];

	int     ref_count;		/* count of devices */
	int     open_count;		/* count of open devices */

	enum dqnet_chan_type	type;	/* router or host mode */
	bool			tx_disable;	/* Tx disable */

	struct napi_struct	napi;	/* used by all devices */
	u32			*msgs;	/* msgs pulled from DQM */
	int			max_msg;/* Size of msgs[] */

	dqnet_demux_fn		demux;	/* function to demux */
	struct dqnet_netdev	*ndev;	/* device if not muxed */

					/* Q msg translation funcs */
	enum  dqnet_qmsg_fmt	qmsg_fmt;
	int			(*encode_q_msg)(struct dqnet_netdev *ndev,
						struct fpm_buff *pb,
						u32 *msgdata);
	int			(*decode_q_msg)(struct dqnet_channel *chan,
						u32 *msgdata,
						struct fpm_buff *pb);
	int			(*if_id_subid_to_port)(u32 if_id,
						       u32 if_sub_id,
						       u8 *port);
	int			(*port_to_if_id_subid)(u8 port,
						       u32 *if_id,
						       u32 *if_sub_id);
	enum buf_type		(*buf_type)(void);
	int			(*rx_pkt)(struct dqnet_netdev *ndev,
					  struct fpm_buff *fb);
	int			(*tx_pkt)(struct fpm_buff *fb,
					  struct net_device *dev);
	struct dqnet_napi_complete napi_complete;
};

enum dqnet_priv_drop_type {
	DQNET_PRIV_DROP_IPv4,
	DQNET_PRIV_DROP_IPv6,
	DQNET_PRIV_DROP_ICMPv6,
	DQNET_PRIV_DROP_ARP,
	DQNET_PRIV_DROP_MAX,
};
#define DQNET_PRIV_DROP_ENCAP_LIMIT 2
/*
 * Net device error stats that are outside Linux's standard
 * stats structure and reporting mechanism.
 */
struct dqnet_err_stats {
	u32 exceeded_budget;
	u32 dqm_rx;
	u32 bad_q_msg;
	u32 if_id_lookup;
	u32 if_sub_id_lookup;
	u32 no_eth_hdr;
	u32 switch_arl_lookup;
	u32 brcm_tag_lookup;
	u32 drop_if_down;
	u32 drop_carrier_off;
	u32 drop_tx_rebroadcast;
	u32 drop_switch_to_switch;
	u32 drop_priv_tx[DQNET_PRIV_DROP_ENCAP_LIMIT][DQNET_PRIV_DROP_MAX];
	u32 drop_priv_rx[DQNET_PRIV_DROP_ENCAP_LIMIT][DQNET_PRIV_DROP_MAX];
	u32 drop_priv_tx_cm[DQNET_PRIV_DROP_ENCAP_LIMIT][DQNET_PRIV_DROP_MAX];
	u32 dqm_tx_busy;
	u32 dqm_tx_failed;
	u32 fpm_alloc_failed;
	u32 wd_timeout;
	u32 rpc_dev_unknown;
	u32 rpc_msg_bad;
	u32 wlan_conversion_failed;
#ifdef FPM_IN_SKB
	atomic_t fpm_in_skb;
	atomic_t fpm_in_skb_free;
	atomic_t fpm_in_skb_shinfo_head;
#endif
};

extern struct dqnet_netdev ndevs;
extern struct dqnet_err_stats err_stats;
extern struct net_device_ops dqnet_netdev_ops;
extern struct dqnet_netdev ***demux_tbl;
extern spinlock_t demux_tbl_lock;
extern int if_id_max, if_sub_id_max;
extern u8 dqnet_swport_fwd[MAX_PHY_PORTS][MAX_PHY_PORTS];

int dqnet_switch_eee(struct net_device *dev, bool enable);
int dqnet_open(struct net_device *dev);
int dqnet_close(struct net_device *dev);
int dqnet_probe(struct platform_device *pdev);
int dqnet_remove(struct platform_device *pdev);
int dqnet_rx_fpm(struct dqnet_netdev *ndev,
		 struct fpm_buff *fb);
int dqnet_rx_skb(struct dqnet_netdev *ndev,
		 struct fpm_buff *fb);
int dqnet_tx_fpm(struct fpm_buff *fb, struct net_device *dev);
int dqnet_nethook_tx_fpm(struct fpm_buff *fb, struct net_device *dev);
int dqnet_tx_buf(struct fpm_buff *fb, struct net_device *dev);
int dqnet_rx_fpm_or_skb(struct dqnet_netdev *ndev,
			struct fpm_buff *fb);
int dqnet_set_wan(char *ifname, int enable);
int dqnet_get_wifi_idx(struct dqnet_netdev *dev);
int dqnet_rxqueue_cpu_affinity_default(struct dqnet_netdev *dev);
int dqnet_balance_imp_lag_ports(int action, int poi);

static inline int dqnet_get_runt_pad_len(int pkt_len)
{
	return pkt_len < ETH_ZLEN ? ETH_ZLEN - pkt_len : 0;
}

#define DQNET_PRIV_DATA_SIZE() \
	(sizeof(struct dqnet_netdev))
#define DQNET_WIFI_NAME_STRING	"wifi"
#define DQNET_MOCA_NAME_STRING	"moca"

#ifdef CONFIG_NET_SWITCHDEV
int dqnet_swdev_init(void);
void dqnet_swdev_exit(void);
#endif

#endif
