/****************************************************************************
 *
 * Broadcom Proprietary and Confidential.
 * (c) 2015-2019 Broadcom. All rights reserved.
 * The term Broadcom refers to Broadcom Limited and/or its subsidiaries.
 *
 * Unless you and Broadcom execute a separate written software license
 * agreement governing use of this software, this software is licensed to
 * you under the terms of the GNU General Public License version 2 (the
 * "GPL"), available at [http://www.broadcom.com/licenses/GPLv2.php], with
 * the following added to such license:
 *
 * As a special exception, the copyright holders of this software give you
 * permission to link this software with independent modules, and to copy
 * and distribute the resulting executable under terms of your choice,
 * provided that you also meet, for each linked independent module, the
 * terms and conditions of the license of that module. An independent
 * module is a module which is not derived from this software. The special
 * exception does not apply to any modifications of the software.
 *
 * Notwithstanding the above, under no circumstances may you combine this
 * software in any way with any other Broadcom software provided under a
 * license other than the GPL, without Broadcom's express prior written
 * consent.
 *
 ****************************************************************************
 * Author: Paul Tweedale <paul.tweedale@broadcom.com>
 ***************************************************************************/

#ifndef __FLOWMGR_MAP_H
#define __FLOWMGR_MAP_H

#ifdef CONFIG_BCM_FLOWMGR_TUNNEL

#include "bcmflowmap.h"

#define FLOWMGR_MAPT_MAX_DOMAINS        2       /* Maximum domains */

#define FLOWMGR_MAP_RETURN(x)	{ pr_debug("%s %d return (%d)\n",	\
					  __func__, __LINE__, (x));	\
				  return x; }
#define FLOWMGR_MAP_RETURN_NULL	{ pr_debug("%s %d return null\n",	\
				  __func__, __LINE__);			\
				  return NULL; }
#define FLOWMGR_MAP_GOTO(x)	{ pr_debug("%s %d goto handler\n",	\
					  __func__, __LINE__);		\
				  goto x; }

struct flowmgr_map_offload {
	struct flow_params params;
	struct nf_conn *master_ct;
	int flow_id_exp;
};

int flowmgr_mapt_domain_cmp(struct nf_conn *ct, void *match);
int flowmgr_mapt_process(struct sk_buff *skb,
			 struct nf_conn *ct,
			 struct nf_conn_offload *ct_offload,
			 const struct net_device *dev);
int flowmgr_promote_mapt(int prot,
			 struct sk_buff *skb,
			 struct nf_conn *ct,
			 struct offload_info *ct_offload_info);
int flowmgr_promote_mapt_duplex(int prot,
				struct sk_buff *skb,
				struct nf_conn *ct,
				struct offload_info *ct_offload_info);
void flowmgr_dump_mapt(struct flow_mapt_params *params);
int flowmgr_map_init(void);
void flowmgr_map_fini(void);
int flowmgr_map_disable(int);
bool flowmgr_is_feat_map_enable(void);

int flowmgr_map_ipv6_frag_check(struct ipv6hdr *ip6h,
				__u8 **payload, int *protocol);
int flowmgr_update_stats_mapt_dev(const struct nf_conn *ct,
				int direction,
				unsigned int packets_diff,
				unsigned int bytes_diff);
int flowmgr_conntrack_get_status_mapt(struct nf_conn *ct,
				struct nf_conn_offload *ct_offload);
#endif
#endif
