#ifndef _LINUX_BRCMXCVR_H
#define _LINUX_BRCMXCVR_H

#include <linux/brcmphy.h>
#include <linux/of_mdio.h>

#define PHY_ID_BCM54210EB0		0x600d84a1
#define PHY_ID_BCM50212EB1		0x600d84a6
#define PHY_ID_BCM54610C1		0x0143bd63
#define PHY_ID_BCM54810C0		0x03625d02
#define PHY_ID_BCM3390			0xae025240
#define PHY_ID_BCM53134			0xae025100
#define PHY_ID_BCM53124			0x03625f24
#define PHY_ID_BCM8488X_OUI		0xae025140
#define PHY_ID_BCM8488X_MASK		0xffffffc0
#define PHY_ID_BCM5499X_OUI		0x35905080
#define PHY_ID_BCM5499X_MASK		0xfffffe80
#define PHY_ID_BCM8499X_OUI		0xf7a61c00
#define PHY_ID_BCM8499X_MASK		0xffffffa0
#define PHY_ID_BCM8275X_OUI		0x08275000
#define PHY_ID_BCM8275X_MASK		0xfffff000
#define PHY_ID_BCM8275X_CHIP_MASK	(PHY_ID_BCM8275X_MASK | 0xf00)
#define PHY_ID_BCM8275X_REV_MASK	(0xff)
#define PHY_ID_BCM_MERLIN_OUI		0x00000000
#define PHY_ID_BCM_MERLIN_MASK		0xffff0000

#define MII_BCM54XX_AUXCTL_WRITE			0x8000
#define MII_BCM54XX_AUXCTL_REG_RD(r) \
	(((r & 0x7) << 12) | MII_BCM54XX_AUXCTL_SHDWSEL_MISC)
#define MII_BCM54XX_AUXCTL_REG_WR(r, d) \
	(((r & 0x7) << 0) | (d & 0xfff8) | MII_BCM54XX_AUXCTL_WRITE)
#define MII_BCM54XX_AUXCTL_DATA(x)		((x & 0xfff8) << 0)

#define MII_BCM54XX_AUXCTL_MISC_OOBS_DIS	0x0020

/* 00001: Spare Control Register 1 */
#define BCM54XX_SHD_SCR1		0x01
#define  BCM54XX_SHD_SCR1_LINKLED	0x0001

/* 00011: Clock Alignment Control */
#define BCM54XX_SHD_CAC			0x03
#define  BCM54XX_SHD_CAC_GTXCLK_DEL_EN	0x0200

/* 01001: LED Control Register */
#define BCM54XX_SHD_LEDCTL		0x09
#define  BCM54XX_SHD_LEDCTL_ACTLINK	0x0010

#define MII_BCM54XX_EXP_TOP_MISC_PIN_CTL	0x0d07
#define  MII_BCM54XX_EXP_TOP_MISC_PIN_CTL_LOM	0x0010

/* brcmphy core info */
struct brcmphy_core {
	struct mii_bus *bus;
	struct phy_device *core;
	struct phy_device *xcvr;
	int (*media_speed)(struct brcmphy_core *phycore, int media, int speed,
			int duplex);
	int (*suspend)(struct brcmphy_core *phycore);
	int (*resume)(struct brcmphy_core *phycore);
	__u32 speed;
	__u32 duplex;
};

/* brcmphy link info */
struct brcmphy_xcvr {
	struct brcmphy_core *phycore;
	void *phypriv;
	__u32 speed;
	__u32 duplex;
};

static inline int brcmphy_link_configurable(struct phy_device *phydev,
		const struct ethtool_link_ksettings *cmd)
{
	const unsigned long *supported = phydev->supported;
	const unsigned long *advertising = cmd->link_modes.advertising;
	u8 duplex = cmd->base.duplex;
	u8 autoneg = cmd->base.autoneg;

	if (!linkmode_subset(advertising, supported))
		return 0;

	if (linkmode_test_bit(ETHTOOL_LINK_MODE_10baseT_Half_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_10baseT_Full_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_100baseT_Half_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_100baseT_Full_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_1000baseT_Half_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_1000baseT_Full_BIT, (unsigned long *)advertising)) {
		return 1;
	} else if (linkmode_test_bit(ETHTOOL_LINK_MODE_100baseT1_Full_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_1000baseT1_Full_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_2500baseT_Full_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_5000baseT_Full_BIT, (unsigned long *)advertising) ||
		linkmode_test_bit(ETHTOOL_LINK_MODE_10000baseT_Full_BIT, (unsigned long *)advertising)) {
		if (autoneg == AUTONEG_DISABLE || duplex == DUPLEX_HALF)
			return 0;
		return 1;
	} else if (autoneg == AUTONEG_DISABLE && duplex == DUPLEX_FULL)
		return 1;

	return 0;
}

static inline int brcmphy_get_busxcvr(struct device *dev,
		struct brcmphy_core *phycore)
{
	struct device_node *node;
	struct brcmphy_xcvr *phyxcvr;

	node = of_parse_phandle(dev->of_node, "bus-handle", 0);
	if (node) {
		of_node_put(node);
		phycore->bus = of_mdio_find_bus(node);
		if (!phycore->bus) {
			dev_err(dev, "Unable to obtain MDIO bus\n");
			return -ENODEV;
		}
	}

	node = of_parse_phandle(dev->of_node, "xcvr-handle", 0);
	if (node) {
		of_node_put(node);
		phycore->xcvr = of_phy_find_device(node);
		if (!phycore->xcvr) {
			dev_err(dev, "Unable to obtain PHY XCVR\n");
			if (phycore->bus) {
				put_device(&phycore->bus->dev);
				phycore->bus = NULL;
			}

			return -ENODEV;
		}

		phyxcvr = dev_get_drvdata(&phycore->xcvr->mdio.dev);
		if (phyxcvr)
			phyxcvr->phycore = phycore;
	}

	return 0;
}

static inline void brcmphy_put_busxcvr(struct brcmphy_core *phycore)
{
	struct brcmphy_xcvr *phyxcvr;

	if (phycore->xcvr) {
		phyxcvr = dev_get_drvdata(&phycore->xcvr->mdio.dev);
		if (phyxcvr)
			phyxcvr->phycore = NULL;
		put_device(&phycore->xcvr->mdio.dev);
		phycore->xcvr = NULL;
	}

	if (phycore->bus) {
		put_device(&phycore->bus->dev);
		phycore->bus = NULL;
	}
}

/*
 * Indirect register access functions for the 1000BASE-T/100BASE-TX/10BASE-T
 * 0x1c shadow registers.
 */
static inline int bcm54xx_shadow_read(struct phy_device *phydev, u16 shadow)
{
	phy_write(phydev, MII_BCM54XX_SHD, MII_BCM54XX_SHD_VAL(shadow));
	return MII_BCM54XX_SHD_DATA(phy_read(phydev, MII_BCM54XX_SHD));
}

static inline int bcm54xx_shadow_write(struct phy_device *phydev, u16 shadow,
				       u16 val)
{
	return phy_write(phydev, MII_BCM54XX_SHD,
			 MII_BCM54XX_SHD_WRITE |
			 MII_BCM54XX_SHD_VAL(shadow) |
			 MII_BCM54XX_SHD_DATA(val));
}

/* Indirect register access functions for the Expansion Registers */
static inline int bcm54xx_exp_read(struct phy_device *phydev, u16 regnum)
{
	int val;

	val = phy_write(phydev, MII_BCM54XX_EXP_SEL, regnum);
	if (val < 0)
		return val;

	val = phy_read(phydev, MII_BCM54XX_EXP_DATA);

	/* Restore default value.  It's O.K. if this write fails. */
	phy_write(phydev, MII_BCM54XX_EXP_SEL, 0);

	return val;
}

static inline int bcm54xx_exp_write(struct phy_device *phydev, u16 regnum, u16 val)
{
	int ret;

	ret = phy_write(phydev, MII_BCM54XX_EXP_SEL, regnum);
	if (ret < 0)
		return ret;

	ret = phy_write(phydev, MII_BCM54XX_EXP_DATA, val);

	/* Restore default value.  It's O.K. if this write fails. */
	phy_write(phydev, MII_BCM54XX_EXP_SEL, 0);

	return ret;
}

#endif /* _LINUX_BRCMXCVR_H */
