# Copyright (C) 2018 Daniel Dickinson <cshored@thecshore.com>
# Released under the MIT license (see COPYING.MIT for the terms)

SUMMARY = "OpenWrt DHCPv6 client"
HOMEPAGE = "https://github.com/sbyx/odhcp6c"
LICENSE = "GPL-2.0"
LIC_FILES_CHKSUM = "file://COPYING;md5=eb723b61539feef013de476e68b5c50a"
SECTION = "base"
#DEPENDS = "libuboxi"

SRCREV = "dc186d6d2b0dd4ad23ca5fc69c00e81f796ff6d9" 
SRC_URI = "\
          git://github.com/sbyx/odhcp6c.git \
          file://dhcpv6.sh \
          file://dhcpv6.script \
          file://001-Fix-potential-buffer-overflow-in-entry_to_env.patch \
          file://002-Fix-possible-stack-buffer-overflow-in-s46_to_env.patch \
          file://003-Check-for-unsupported-PD-exclusion-configuration-in-dhcpv6_parse_ia.patch \
          file://004-Fixed-regression-in-entry_to_env.patch \
          file://110-osync-no-lifetime-update.patch \
          "

S = "${WORKDIR}/git"

#inherit cmake pkgconfig openwrt openwrt-services openwrt-base-files
#inherit autotools
inherit cmake pkgconfig

#SRCREV_openwrt = "${OPENWRT_SRCREV}"

do_install_append() {
    install -Dm 0755 ${WORKDIR}/dhcpv6.sh ${D}${base_libdir}/netifd/proto/dhcpv6.sh
    install -Dm 0755 ${WORKDIR}/dhcpv6.script ${D}${base_libdir}/netifd/dhcpv6.script
}

FILES_${PN} += "\
               ${base_libdir}/netifd/proto/dhcpv6.sh \
               ${base_libdir}/netifd/dhcpv6.script \
               "

#RRECOMMENDS_${PN} += "netifd"

