#!/bin/sh
####################################################################################
# If not stated otherwise in this file or this component's Licenses.txt file the
# following copyright and licenses apply:

#  Copyright 2019 RDK Management

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

# http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#######################################################################################
source /etc/device.properties
source /etc/log_timestamp.sh

mesh_ethbhaul_setup()
{
   echo_t "ETH_BACKHAUL : Start Vlan Creation...." >> /rdklogs/logs/ethbhaul.log

   if [  -d "/sys/class/net/l2sd0.100.1060" ]; then
      echo_t "ETH_BACKHAUL : Skipping 1060 vlan creation" >> /rdklogs/logs/ethbhaul.log
   else
      ip link add link l2sd0.100 l2sd0.100.1060 type vlan proto 802.1Q id 1060
      ip link set l2sd0.100.1060 up
      brctl addif br403 l2sd0.100.1060
      ip rule add from all iif l2sd0.100.1060 lookup erouter
      echo_t "ETH_BACKHAUL : Vlan 1060 is created ...." >> /rdklogs/logs/ethbhaul.log
   fi

   if [  -d "/sys/class/net/l2sd0.100.101" ]; then
      echo_t "ETH_BACKHAUL : Skipping 101 vlan creation" >> /rdklogs/logs/ethbhaul.log
   else
      ip link add link l2sd0.100 l2sd0.100.101 type vlan proto 802.1Q id 101
      ip link set l2sd0.100.101 up
      brctl addif brlan1 l2sd0.100.101
      ip rule add from all iif l2sd0.100.101 lookup erouter
      echo_t "ETH_BACKHAUL : Vlan 101 is created ...." >> /rdklogs/logs/ethbhaul.log
   fi

   if [  -d "/sys/class/net/l2sd0.100.106" ]; then
      echo_t "ETH_BACKHAUL : Skipping 106 vlan creation" >> /rdklogs/logs/ethbhaul.log
   else
      ip link add link l2sd0.100 l2sd0.100.106 type vlan proto 802.1Q id 106
      ip link set l2sd0.100.106 up
      brctl addif br106 l2sd0.100.106
      ip rule add from all iif l2sd0.100.106 lookup erouter
      echo_t "ETH_BACKHAUL : Vlan 106 is created ...." >> /rdklogs/logs/ethbhaul.log
   fi

   #Enable external switch for QinQ support in case of Cisco
   if [ "$MODEL_NUM" = "DPC3941" ]; then
      cli system/l2switch/extswitch/acceptTag
   fi
   echo_t "ETH_BACKHAUL : End Vlan Creation...." >> /rdklogs/logs/ethbhaul.log
}

remove_pod_ethbhaul()
{
   echo_t "ETH_BACKHAUL : Start Vlan Deletion...." >> /rdklogs/logs/ethbhaul.log
   ip link del l2sd0.100.1060
   ip link del l2sd0.100.106
   ip link del l2sd0.100.101
   echo_t "ETH_BACKHAUL : End Vlan Deletion...." >> /rdklogs/logs/ethbhaul.log
}

if [ "$1" == "enable" ]; then
   mesh_ethbhaul_setup
else
   remove_pod_ethbhaul
fi
